declare module '@sage/wh-output-stock-api-partial' {
    import type {
        Carrier,
        Currency,
        Customer,
        Depositor,
        GenericRound,
        GenericWave,
        Location,
        MovementCode,
        Operand,
        Package as SageWhMasterData$Package,
        ParcelType,
        PreparationArea,
        RangeOfParcel,
        ShippingUnitType,
        StockNature,
        Store,
        TariffCode,
        TransportMode,
        TransportType,
        UnitOfMeasure,
        WorkCenter,
    } from '@sage/wh-master-data-api';
    import type {
        AutoPalletizationOrder,
        AutoPalletizationOrderInput,
        CarriageReceipt,
        DeliveryNote,
        DeliveryNoteBillToAddresses,
        DeliveryNoteBillToAddressesBinding,
        DeliveryNoteBillToAddressesInput,
        DeliveryNoteBillToCompanyNames,
        DeliveryNoteBillToCompanyNamesBinding,
        DeliveryNoteBillToCompanyNamesInput,
        DeliveryNoteInput,
        DeliveryNoteNumberOfDispatchableParcels,
        DeliveryNoteNumberOfDispatchableParcelsBinding,
        DeliveryNoteNumberOfDispatchableParcelsInput,
        DeliveryNoteShipToAddresses,
        DeliveryNoteShipToAddressesBinding,
        DeliveryNoteShipToAddressesInput,
        DeliveryNoteShipToCompanyNames,
        DeliveryNoteShipToCompanyNamesBinding,
        DeliveryNoteShipToCompanyNamesInput,
        DeliveryOrder,
        DeliveryOrderBillToAddresses,
        DeliveryOrderBillToAddressesBinding,
        DeliveryOrderBillToAddressesInput,
        DeliveryOrderBillToCompanyNames,
        DeliveryOrderBillToCompanyNamesBinding,
        DeliveryOrderBillToCompanyNamesInput,
        DeliveryOrderInput,
        DeliveryOrderLine,
        DeliveryOrderLineInput,
        DeliveryOrderShipToAddresses,
        DeliveryOrderShipToAddressesBinding,
        DeliveryOrderShipToAddressesInput,
        DeliveryOrderShipToCompanyNames,
        DeliveryOrderShipToCompanyNamesBinding,
        DeliveryOrderShipToCompanyNamesInput,
        OutputMovement,
        OutputMovementContainerLevels,
        OutputMovementContainerLevelsBinding,
        OutputMovementContainerLevelsInput,
        OutputMovementInput,
        Package as SageWhOutput$Package,
        Parcel,
        ParcelInput,
        PickingOrder,
        PickingOrderInput,
        Round,
        ShippingUnit,
        ShippingUnitCompanyNames,
        ShippingUnitCompanyNamesBinding,
        ShippingUnitCompanyNamesInput,
        ShippingUnitInput,
    } from '@sage/wh-output-api';
    import type {
        Origin,
        Package as SageWhProductData$Package,
        PickingMode,
        Product,
        ProductContainer,
    } from '@sage/wh-product-data-api';
    import type {
        AdjustmentMovement,
        AssemblingWave,
        Package as SageWhStock$Package,
        TransferMovementContainerLevels,
        TransferMovementContainerLevelsBinding,
        TransferMovementContainerLevelsInput,
        TransferMovementInput,
    } from '@sage/wh-stock-api';
    import type { Package as SageWhStockData$Package, StockObject } from '@sage/wh-stock-data-api';
    import type { Country, Package as SageWhStructure$Package } from '@sage/wh-structure-api';
    import type { GenericPrintReport, Language, Package as SageWhSystem$Package, Site } from '@sage/wh-system-api';
    import type { Package as SageXtremAppMetadata$Package } from '@sage/xtrem-app-metadata-api';
    import type { Package as SageXtremX3SystemUtils$Package, SysUser } from '@sage/xtrem-x3-system-utils-api';
    import type {
        AggregateQueryOperation,
        AggregateReadOperation,
        ClientCollection,
        ClientNode,
        ClientNodeInput,
        GetDefaultsOperation,
        QueryOperation,
        ReadOperation,
        decimal,
        integer,
    } from '@sage/xtrem-client';
    export interface Wave extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        code: string;
        waveType: WaveType;
        launchDate: string;
        launchTime: string;
        numberOfDeliveryOrders: integer;
        numberOfDeliveryOrdersLines: integer;
        numberOfReserveMovements: integer;
        numberOfPickingMovements: integer;
        numberOfCrossDockingMovements: integer;
        numberOfIncompletesLines: integer;
        numberOfReplenishmentMovements: integer;
        numberOfParcelInState: integer;
        numberOfParcelinBulk: integer;
        numberOfShippingUnitInstate: integer;
        numberOfShippingUnitinBulk: integer;
        numberOfPickingOrderForReserve: integer;
        numberOfPickingOrderForPicking: integer;
        numberOfPickingOrderForMixed: integer;
        numberOfTransferOrder: integer;
        status: WaveStatus;
        volume: string;
        weight: string;
        numberOfTransferMovements: integer;
        carrier: Carrier;
        transportationMethod: TransportMode;
        round: Round;
        genericWave: GenericWave;
        workCenter: WorkCenter;
        unit: UnitOfMeasure;
        estimatedLoad: string;
        isAutoLaunch: boolean;
        isMissionToBlock: boolean;
        missionPriority: integer;
        transactionInProgress: string;
    }
    export interface WaveInput extends ClientNodeInput {
        site?: string;
        depositor?: string;
        code?: string;
        waveType?: WaveType;
        launchDate?: string;
        launchTime?: string;
        numberOfDeliveryOrders?: integer | string;
        numberOfDeliveryOrdersLines?: integer | string;
        numberOfReserveMovements?: integer | string;
        numberOfPickingMovements?: integer | string;
        numberOfCrossDockingMovements?: integer | string;
        numberOfIncompletesLines?: integer | string;
        numberOfReplenishmentMovements?: integer | string;
        numberOfParcelInState?: integer | string;
        numberOfParcelinBulk?: integer | string;
        numberOfShippingUnitInstate?: integer | string;
        numberOfShippingUnitinBulk?: integer | string;
        numberOfPickingOrderForReserve?: integer | string;
        numberOfPickingOrderForPicking?: integer | string;
        numberOfPickingOrderForMixed?: integer | string;
        numberOfTransferOrder?: integer | string;
        status?: WaveStatus;
        volume?: decimal | string;
        weight?: decimal | string;
        numberOfTransferMovements?: integer | string;
        carrier?: string;
        transportationMethod?: string;
        round?: string;
        genericWave?: string;
        workCenter?: string;
        unit?: string;
        estimatedLoad?: decimal | string;
        isAutoLaunch?: boolean | string;
        isMissionToBlock?: boolean | string;
        missionPriority?: integer | string;
        transactionInProgress?: string;
    }
    export interface WaveBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        code: string;
        waveType: WaveType;
        launchDate: string;
        launchTime: string;
        numberOfDeliveryOrders: integer;
        numberOfDeliveryOrdersLines: integer;
        numberOfReserveMovements: integer;
        numberOfPickingMovements: integer;
        numberOfCrossDockingMovements: integer;
        numberOfIncompletesLines: integer;
        numberOfReplenishmentMovements: integer;
        numberOfParcelInState: integer;
        numberOfParcelinBulk: integer;
        numberOfShippingUnitInstate: integer;
        numberOfShippingUnitinBulk: integer;
        numberOfPickingOrderForReserve: integer;
        numberOfPickingOrderForPicking: integer;
        numberOfPickingOrderForMixed: integer;
        numberOfTransferOrder: integer;
        status: WaveStatus;
        volume: string;
        weight: string;
        numberOfTransferMovements: integer;
        carrier: Carrier;
        transportationMethod: TransportMode;
        round: Round;
        genericWave: GenericWave;
        workCenter: WorkCenter;
        unit: UnitOfMeasure;
        estimatedLoad: string;
        isAutoLaunch: boolean;
        isMissionToBlock: boolean;
        missionPriority: integer;
        transactionInProgress: string;
    }
    export interface Wave$Lookups {
        site: QueryOperation<Site>;
        depositor: QueryOperation<Depositor>;
        carrier: QueryOperation<Carrier>;
        transportationMethod: QueryOperation<TransportMode>;
        round: QueryOperation<Round>;
        genericWave: QueryOperation<GenericWave>;
        workCenter: QueryOperation<WorkCenter>;
        unit: QueryOperation<UnitOfMeasure>;
    }
    export interface Wave$Operations {
        query: QueryOperation<Wave>;
        read: ReadOperation<Wave>;
        aggregate: {
            read: AggregateReadOperation<Wave>;
            query: AggregateQueryOperation<Wave>;
        };
        lookups(dataOrId: string | { data: WaveInput }): Wave$Lookups;
        getDefaults: GetDefaultsOperation<Wave>;
    }
    export interface AutoPalletizationOrderExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        code: string;
        status: AutoPalletizationStatus;
        deliveryOrder: DeliveryOrder;
        numberOfShippingUnits: integer;
        numberOfParcels: integer;
        date: string;
        time: string;
        preparationArea: PreparationArea;
        validatingOperator: Operand;
        postingDate: string;
        postingTime: integer;
        validatingUser: string;
        wave: Wave;
    }
    export interface AutoPalletizationOrderInputExtension {
        site?: string;
        depositor?: string;
        code?: string;
        status?: AutoPalletizationStatus;
        deliveryOrder?: string;
        numberOfShippingUnits?: integer | string;
        numberOfParcels?: integer | string;
        date?: string;
        time?: string;
        preparationArea?: string;
        validatingOperator?: string;
        postingDate?: string;
        postingTime?: integer | string;
        validatingUser?: string;
        wave?: string;
    }
    export interface AutoPalletizationOrderBindingExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        code: string;
        status: AutoPalletizationStatus;
        deliveryOrder: DeliveryOrder;
        numberOfShippingUnits: integer;
        numberOfParcels: integer;
        date: string;
        time: string;
        preparationArea: PreparationArea;
        validatingOperator: Operand;
        postingDate: string;
        postingTime: integer;
        validatingUser: string;
        wave: Wave;
    }
    export interface AutoPalletizationOrderExtension$Lookups {
        wave: QueryOperation<Wave>;
    }
    export interface AutoPalletizationOrderExtension$Operations {
        lookups(dataOrId: string | { data: AutoPalletizationOrderInput }): AutoPalletizationOrderExtension$Lookups;
    }
    export interface DeliveryNoteExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        code: string;
        creationDate: string;
        creationTime: string;
        isFinalDeliveryNote: boolean;
        isUpdateDeliveryNote: boolean;
        deliveryOrder: DeliveryOrder;
        reference: string;
        orderReference: string;
        orderNumber: string;
        orderDate: string;
        soldToCustomer: string;
        customerReference: string;
        pickingMode: PickingMode;
        movementCode: MovementCode;
        partialDeliveryManagement: PartialDeliveryAuthorized;
        expectedDeliveryDate: string;
        expectedDeliveryTime: string;
        shipmentDate: string;
        shipmentTime: string;
        shipmentSite: Site;
        round: Round;
        carriageReceipt: CarriageReceipt;
        carrier: Carrier;
        transportationMethod: TransportMode;
        carriageReference: string;
        freightCharge: string;
        currency: Currency;
        roundPosition: integer;
        genericRound: GenericRound;
        transportType: TransportType;
        deliveryArea: string;
        preparationArea: PreparationArea;
        shipToCustomer: Customer;
        shipToPostalCode: string;
        shipToCity: string;
        shipToCountry: Country;
        shipToCountryName: string;
        shipToRegion: string;
        shipToTelephone: string;
        shipToFax: string;
        shipToNotes: string;
        billToCustomer: Customer;
        billToPostalCode: string;
        billToCity: string;
        billToCountry: Country;
        billToCountryName: string;
        billToRegion: string;
        billToTelephone: string;
        billToFax: string;
        billToNotes: string;
        numberOfParcels: integer;
        numberOfShippingUnit: integer;
        weight: string;
        volume: string;
        linearMeters: string;
        numberOfDeliveryOrderLines: integer;
        deliveryNotePrintingReport: GenericPrintReport;
        printLanguage: Language;
        ediManagementStatus: EdiMngtStatus;
        numberOfParcelsWithoutMessage: integer;
        ediManagementLevel: EdiLevel;
        queryNumber: integer;
        billToAddresses: ClientCollection<DeliveryNoteBillToAddresses>;
        billToCompanyNames: ClientCollection<DeliveryNoteBillToCompanyNames>;
        numberOfDispatchableParcels: ClientCollection<DeliveryNoteNumberOfDispatchableParcels>;
        shipToAddresses: ClientCollection<DeliveryNoteShipToAddresses>;
        shipToCompanyNames: ClientCollection<DeliveryNoteShipToCompanyNames>;
        wave: Wave;
    }
    export interface DeliveryNoteInputExtension {
        site?: string;
        depositor?: string;
        code?: string;
        creationDate?: string;
        creationTime?: string;
        isFinalDeliveryNote?: boolean | string;
        isUpdateDeliveryNote?: boolean | string;
        deliveryOrder?: string;
        reference?: string;
        orderReference?: string;
        orderNumber?: string;
        orderDate?: string;
        soldToCustomer?: string;
        customerReference?: string;
        pickingMode?: string;
        movementCode?: string;
        partialDeliveryManagement?: PartialDeliveryAuthorized;
        expectedDeliveryDate?: string;
        expectedDeliveryTime?: string;
        shipmentDate?: string;
        shipmentTime?: string;
        shipmentSite?: string;
        round?: string;
        carriageReceipt?: string;
        carrier?: string;
        transportationMethod?: string;
        carriageReference?: string;
        freightCharge?: decimal | string;
        currency?: string;
        roundPosition?: integer | string;
        genericRound?: string;
        transportType?: string;
        deliveryArea?: string;
        preparationArea?: string;
        shipToCustomer?: string;
        shipToPostalCode?: string;
        shipToCity?: string;
        shipToCountry?: string;
        shipToCountryName?: string;
        shipToRegion?: string;
        shipToTelephone?: string;
        shipToFax?: string;
        shipToNotes?: string;
        billToCustomer?: string;
        billToPostalCode?: string;
        billToCity?: string;
        billToCountry?: string;
        billToCountryName?: string;
        billToRegion?: string;
        billToTelephone?: string;
        billToFax?: string;
        billToNotes?: string;
        numberOfParcels?: integer | string;
        numberOfShippingUnit?: integer | string;
        weight?: decimal | string;
        volume?: decimal | string;
        linearMeters?: decimal | string;
        numberOfDeliveryOrderLines?: integer | string;
        deliveryNotePrintingReport?: string;
        printLanguage?: string;
        ediManagementStatus?: EdiMngtStatus;
        numberOfParcelsWithoutMessage?: integer | string;
        ediManagementLevel?: EdiLevel;
        queryNumber?: integer | string;
        billToAddresses?: Partial<DeliveryNoteBillToAddressesInput>[];
        billToCompanyNames?: Partial<DeliveryNoteBillToCompanyNamesInput>[];
        numberOfDispatchableParcels?: Partial<DeliveryNoteNumberOfDispatchableParcelsInput>[];
        shipToAddresses?: Partial<DeliveryNoteShipToAddressesInput>[];
        shipToCompanyNames?: Partial<DeliveryNoteShipToCompanyNamesInput>[];
        wave?: string;
    }
    export interface DeliveryNoteBindingExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        code: string;
        creationDate: string;
        creationTime: string;
        isFinalDeliveryNote: boolean;
        isUpdateDeliveryNote: boolean;
        deliveryOrder: DeliveryOrder;
        reference: string;
        orderReference: string;
        orderNumber: string;
        orderDate: string;
        soldToCustomer: string;
        customerReference: string;
        pickingMode: PickingMode;
        movementCode: MovementCode;
        partialDeliveryManagement: PartialDeliveryAuthorized;
        expectedDeliveryDate: string;
        expectedDeliveryTime: string;
        shipmentDate: string;
        shipmentTime: string;
        shipmentSite: Site;
        round: Round;
        carriageReceipt: CarriageReceipt;
        carrier: Carrier;
        transportationMethod: TransportMode;
        carriageReference: string;
        freightCharge: string;
        currency: Currency;
        roundPosition: integer;
        genericRound: GenericRound;
        transportType: TransportType;
        deliveryArea: string;
        preparationArea: PreparationArea;
        shipToCustomer: Customer;
        shipToPostalCode: string;
        shipToCity: string;
        shipToCountry: Country;
        shipToCountryName: string;
        shipToRegion: string;
        shipToTelephone: string;
        shipToFax: string;
        shipToNotes: string;
        billToCustomer: Customer;
        billToPostalCode: string;
        billToCity: string;
        billToCountry: Country;
        billToCountryName: string;
        billToRegion: string;
        billToTelephone: string;
        billToFax: string;
        billToNotes: string;
        numberOfParcels: integer;
        numberOfShippingUnit: integer;
        weight: string;
        volume: string;
        linearMeters: string;
        numberOfDeliveryOrderLines: integer;
        deliveryNotePrintingReport: GenericPrintReport;
        printLanguage: Language;
        ediManagementStatus: EdiMngtStatus;
        numberOfParcelsWithoutMessage: integer;
        ediManagementLevel: EdiLevel;
        queryNumber: integer;
        billToAddresses: ClientCollection<DeliveryNoteBillToAddressesBinding>;
        billToCompanyNames: ClientCollection<DeliveryNoteBillToCompanyNamesBinding>;
        numberOfDispatchableParcels: ClientCollection<DeliveryNoteNumberOfDispatchableParcelsBinding>;
        shipToAddresses: ClientCollection<DeliveryNoteShipToAddressesBinding>;
        shipToCompanyNames: ClientCollection<DeliveryNoteShipToCompanyNamesBinding>;
        wave: Wave;
    }
    export interface DeliveryNoteExtension$Lookups {
        wave: QueryOperation<Wave>;
    }
    export interface DeliveryNoteExtension$Operations {
        lookups(dataOrId: string | { data: DeliveryNoteInput }): DeliveryNoteExtension$Lookups;
    }
    export interface DeliveryOrderExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        code: string;
        referenceNumber: string;
        status: DoHeaderStatus;
        isMergingOfFlows: boolean;
        date: string;
        plannedLaunchDate: string;
        plannedLaunchTime: string;
        expectedDeliveryDate: string;
        expectedDeliveryTime: string;
        orderReference: string;
        orderNumber: string;
        orderDate: string;
        soldTo: string;
        customerReference: string;
        movementCode: MovementCode;
        pickingMode: PickingMode;
        partialDelivery: PartialDeliveryAuthorized;
        servicePriority: ServicePriority;
        isUrgent: boolean;
        originalDeliveryOrder: DeliveryOrder;
        splittingNumber: integer;
        isOutputShortageManagement: boolean;
        isPacking: Packing;
        isParcelPalletisation: boolean;
        isLoadingOfParcels: boolean;
        isShipmentManagement: boolean;
        shipTo: Customer;
        shipToPostalCode: string;
        shipToCity: string;
        shipToCountry: Country;
        shipToCountryName: string;
        shipToRegion: string;
        shipToTelephone: string;
        shipToFax: string;
        deliveryArea: string;
        deliveryNotePrintingReport: GenericPrintReport;
        printLanguage: Language;
        shipToCustomerNotes: string;
        round: Round;
        genericRound: GenericRound;
        carrier: Carrier;
        transportationMethod: TransportMode;
        carriageReference: string;
        transportType: TransportType;
        roundPosition: integer;
        billToCustomer: Customer;
        billToCountry: Country;
        billToCountryName: string;
        billToCity: string;
        billToPostalCode: string;
        billToRegion: string;
        billToTelephone: string;
        billToFax: string;
        billToCustomerNotes: string;
        launchDate: string;
        launchTime: string;
        pickingDate: string;
        pickingTime: string;
        packingDate: string;
        packingTime: string;
        shipmentDate: string;
        shipmentTime: string;
        transmittedFromL3: TransmissionL3;
        isCarrierAmountCalculation: boolean;
        priceListCode: TariffCode;
        currency: Currency;
        crossDockingLevel: CrossDockingBlockingLevel;
        isCrossDockingManagement: boolean;
        isSsccManagementOnOutput: boolean;
        isShippingUnitSingleDeliveryOrder: boolean;
        isShippingUnitSingleCustomer: boolean;
        shippingUnitType: ShippingUnitType;
        shippingUnitGroup: string;
        lines: ClientCollection<DeliveryOrderLine>;
        billToAddresses: ClientCollection<DeliveryOrderBillToAddresses>;
        billToCompanyNames: ClientCollection<DeliveryOrderBillToCompanyNames>;
        shipToAddresses: ClientCollection<DeliveryOrderShipToAddresses>;
        shipToCompanyNames: ClientCollection<DeliveryOrderShipToCompanyNames>;
        wave: Wave;
    }
    export interface DeliveryOrderInputExtension {
        site?: string;
        depositor?: string;
        code?: string;
        referenceNumber?: string;
        status?: DoHeaderStatus;
        isMergingOfFlows?: boolean | string;
        date?: string;
        plannedLaunchDate?: string;
        plannedLaunchTime?: string;
        expectedDeliveryDate?: string;
        expectedDeliveryTime?: string;
        orderReference?: string;
        orderNumber?: string;
        orderDate?: string;
        soldTo?: string;
        customerReference?: string;
        movementCode?: string;
        pickingMode?: string;
        partialDelivery?: PartialDeliveryAuthorized;
        servicePriority?: ServicePriority;
        isUrgent?: boolean | string;
        originalDeliveryOrder?: string;
        splittingNumber?: integer | string;
        isOutputShortageManagement?: boolean | string;
        isPacking?: Packing;
        isParcelPalletisation?: boolean | string;
        isLoadingOfParcels?: boolean | string;
        isShipmentManagement?: boolean | string;
        shipTo?: string;
        shipToPostalCode?: string;
        shipToCity?: string;
        shipToCountry?: string;
        shipToCountryName?: string;
        shipToRegion?: string;
        shipToTelephone?: string;
        shipToFax?: string;
        deliveryArea?: string;
        deliveryNotePrintingReport?: string;
        printLanguage?: string;
        shipToCustomerNotes?: string;
        round?: string;
        genericRound?: string;
        carrier?: string;
        transportationMethod?: string;
        carriageReference?: string;
        transportType?: string;
        roundPosition?: integer | string;
        billToCustomer?: string;
        billToCountry?: string;
        billToCountryName?: string;
        billToCity?: string;
        billToPostalCode?: string;
        billToRegion?: string;
        billToTelephone?: string;
        billToFax?: string;
        billToCustomerNotes?: string;
        launchDate?: string;
        launchTime?: string;
        pickingDate?: string;
        pickingTime?: string;
        packingDate?: string;
        packingTime?: string;
        shipmentDate?: string;
        shipmentTime?: string;
        transmittedFromL3?: TransmissionL3;
        isCarrierAmountCalculation?: boolean | string;
        priceListCode?: string;
        currency?: string;
        crossDockingLevel?: CrossDockingBlockingLevel;
        isCrossDockingManagement?: boolean | string;
        isSsccManagementOnOutput?: boolean | string;
        isShippingUnitSingleDeliveryOrder?: boolean | string;
        isShippingUnitSingleCustomer?: boolean | string;
        shippingUnitType?: string;
        shippingUnitGroup?: string;
        lines?: Partial<DeliveryOrderLineInput>[];
        billToAddresses?: Partial<DeliveryOrderBillToAddressesInput>[];
        billToCompanyNames?: Partial<DeliveryOrderBillToCompanyNamesInput>[];
        shipToAddresses?: Partial<DeliveryOrderShipToAddressesInput>[];
        shipToCompanyNames?: Partial<DeliveryOrderShipToCompanyNamesInput>[];
        wave?: string;
    }
    export interface DeliveryOrderBindingExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        code: string;
        referenceNumber: string;
        status: DoHeaderStatus;
        isMergingOfFlows: boolean;
        date: string;
        plannedLaunchDate: string;
        plannedLaunchTime: string;
        expectedDeliveryDate: string;
        expectedDeliveryTime: string;
        orderReference: string;
        orderNumber: string;
        orderDate: string;
        soldTo: string;
        customerReference: string;
        movementCode: MovementCode;
        pickingMode: PickingMode;
        partialDelivery: PartialDeliveryAuthorized;
        servicePriority: ServicePriority;
        isUrgent: boolean;
        originalDeliveryOrder: DeliveryOrder;
        splittingNumber: integer;
        isOutputShortageManagement: boolean;
        isPacking: Packing;
        isParcelPalletisation: boolean;
        isLoadingOfParcels: boolean;
        isShipmentManagement: boolean;
        shipTo: Customer;
        shipToPostalCode: string;
        shipToCity: string;
        shipToCountry: Country;
        shipToCountryName: string;
        shipToRegion: string;
        shipToTelephone: string;
        shipToFax: string;
        deliveryArea: string;
        deliveryNotePrintingReport: GenericPrintReport;
        printLanguage: Language;
        shipToCustomerNotes: string;
        round: Round;
        genericRound: GenericRound;
        carrier: Carrier;
        transportationMethod: TransportMode;
        carriageReference: string;
        transportType: TransportType;
        roundPosition: integer;
        billToCustomer: Customer;
        billToCountry: Country;
        billToCountryName: string;
        billToCity: string;
        billToPostalCode: string;
        billToRegion: string;
        billToTelephone: string;
        billToFax: string;
        billToCustomerNotes: string;
        launchDate: string;
        launchTime: string;
        pickingDate: string;
        pickingTime: string;
        packingDate: string;
        packingTime: string;
        shipmentDate: string;
        shipmentTime: string;
        transmittedFromL3: TransmissionL3;
        isCarrierAmountCalculation: boolean;
        priceListCode: TariffCode;
        currency: Currency;
        crossDockingLevel: CrossDockingBlockingLevel;
        isCrossDockingManagement: boolean;
        isSsccManagementOnOutput: boolean;
        isShippingUnitSingleDeliveryOrder: boolean;
        isShippingUnitSingleCustomer: boolean;
        shippingUnitType: ShippingUnitType;
        shippingUnitGroup: string;
        lines: ClientCollection<DeliveryOrderLine>;
        billToAddresses: ClientCollection<DeliveryOrderBillToAddressesBinding>;
        billToCompanyNames: ClientCollection<DeliveryOrderBillToCompanyNamesBinding>;
        shipToAddresses: ClientCollection<DeliveryOrderShipToAddressesBinding>;
        shipToCompanyNames: ClientCollection<DeliveryOrderShipToCompanyNamesBinding>;
        wave: Wave;
    }
    export interface DeliveryOrderExtension$Lookups {
        wave: QueryOperation<Wave>;
    }
    export interface DeliveryOrderExtension$Operations {
        lookups(dataOrId: string | { data: DeliveryOrderInput }): DeliveryOrderExtension$Lookups;
    }
    export interface OutputMovementExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        code: string;
        deliveryOrder: DeliveryOrder;
        deliveryLineNumber: integer;
        subWaveNumber: integer;
        pickingOrder: PickingOrder;
        pickingOrderSorting: string;
        lineType: DoLineType;
        product: Product;
        numberOfContainers: string;
        container: ProductContainer;
        homogeneousContainerCoefficient: string;
        numberOfConsumptionUnit: string;
        numberOfKit: string;
        movementCode: MovementCode;
        lotNumber: string;
        stockStatus: StockNature;
        reservationNumber: string;
        supportNumber: string;
        status: OutputMovementStatus;
        source: Origin;
        fifoDate: string;
        manufacturedDate: string;
        detentionDate: string;
        sellByDate: string;
        shipByDate: string;
        useByDate: string;
        pickingMode: PickingMode;
        store: Store;
        location: Location;
        locationType: LocationType;
        stockObject: StockObject;
        containerNumber: string;
        homogeneousContainer: ProductContainer;
        homogeneousQuantity: string;
        originContainer: ProductContainer;
        sourceQuantity: string;
        parcel: Parcel;
        shippingUnit: ShippingUnit;
        parcelSequence: integer;
        deliveryNote: DeliveryNote;
        round: Round;
        roundSite: Site;
        travelSequence: string;
        rowByLevel: string;
        isInTransit: boolean;
        destinationSite: Site;
        validatingOperator: Operand;
        validatingUser: string;
        postingDate: string;
        postingTime: integer;
        groupingCode: string;
        isContractDate: boolean;
        parcels: ClientCollection<Parcel>;
        containerLevels: ClientCollection<OutputMovementContainerLevels>;
        wave: Wave;
    }
    export interface OutputMovementInputExtension {
        site?: string;
        depositor?: string;
        code?: string;
        deliveryOrder?: string;
        deliveryLineNumber?: integer | string;
        subWaveNumber?: integer | string;
        pickingOrder?: string;
        pickingOrderSorting?: string;
        lineType?: DoLineType;
        product?: string;
        numberOfContainers?: decimal | string;
        container?: string;
        homogeneousContainerCoefficient?: decimal | string;
        numberOfConsumptionUnit?: decimal | string;
        numberOfKit?: decimal | string;
        movementCode?: string;
        lotNumber?: string;
        stockStatus?: string;
        reservationNumber?: string;
        supportNumber?: string;
        status?: OutputMovementStatus;
        source?: string;
        fifoDate?: string;
        manufacturedDate?: string;
        detentionDate?: string;
        sellByDate?: string;
        shipByDate?: string;
        useByDate?: string;
        pickingMode?: string;
        store?: string;
        location?: string;
        locationType?: LocationType;
        stockObject?: string;
        containerNumber?: string;
        homogeneousContainer?: string;
        homogeneousQuantity?: decimal | string;
        originContainer?: string;
        sourceQuantity?: decimal | string;
        parcel?: string;
        shippingUnit?: string;
        parcelSequence?: integer | string;
        deliveryNote?: string;
        round?: string;
        roundSite?: string;
        travelSequence?: string;
        rowByLevel?: string;
        isInTransit?: boolean | string;
        destinationSite?: string;
        validatingOperator?: string;
        validatingUser?: string;
        postingDate?: string;
        postingTime?: integer | string;
        groupingCode?: string;
        isContractDate?: boolean | string;
        parcels?: Partial<ParcelInput>[];
        containerLevels?: Partial<OutputMovementContainerLevelsInput>[];
        wave?: string;
    }
    export interface OutputMovementBindingExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        code: string;
        deliveryOrder: DeliveryOrder;
        deliveryLineNumber: integer;
        subWaveNumber: integer;
        pickingOrder: PickingOrder;
        pickingOrderSorting: string;
        lineType: DoLineType;
        product: Product;
        numberOfContainers: string;
        container: ProductContainer;
        homogeneousContainerCoefficient: string;
        numberOfConsumptionUnit: string;
        numberOfKit: string;
        movementCode: MovementCode;
        lotNumber: string;
        stockStatus: StockNature;
        reservationNumber: string;
        supportNumber: string;
        status: OutputMovementStatus;
        source: Origin;
        fifoDate: string;
        manufacturedDate: string;
        detentionDate: string;
        sellByDate: string;
        shipByDate: string;
        useByDate: string;
        pickingMode: PickingMode;
        store: Store;
        location: Location;
        locationType: LocationType;
        stockObject: StockObject;
        containerNumber: string;
        homogeneousContainer: ProductContainer;
        homogeneousQuantity: string;
        originContainer: ProductContainer;
        sourceQuantity: string;
        parcel: Parcel;
        shippingUnit: ShippingUnit;
        parcelSequence: integer;
        deliveryNote: DeliveryNote;
        round: Round;
        roundSite: Site;
        travelSequence: string;
        rowByLevel: string;
        isInTransit: boolean;
        destinationSite: Site;
        validatingOperator: Operand;
        validatingUser: string;
        postingDate: string;
        postingTime: integer;
        groupingCode: string;
        isContractDate: boolean;
        parcels: ClientCollection<Parcel>;
        containerLevels: ClientCollection<OutputMovementContainerLevelsBinding>;
        wave: Wave;
    }
    export interface OutputMovementExtension$Lookups {
        wave: QueryOperation<Wave>;
    }
    export interface OutputMovementExtension$Operations {
        lookups(dataOrId: string | { data: OutputMovementInput }): OutputMovementExtension$Lookups;
    }
    export interface ParcelExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        code: string;
        deliveryOrder: DeliveryOrder;
        pickingOrder: PickingOrder;
        palletisationOrder: AutoPalletizationOrder;
        status: ParcelStatus;
        preparationArea: PreparationArea;
        pickingMode: PickingMode;
        parcelRange: RangeOfParcel;
        parcelType: ParcelType;
        height: string;
        width: string;
        depth: string;
        volume: string;
        estimatedWeight: string;
        realWeight: string;
        isDispatchableInState: boolean;
        isPalettizableAsIs: boolean;
        carrierParcelNumber: string;
        carrier: Carrier;
        transportationMethod: TransportMode;
        deliveryNote: DeliveryNote;
        shippingUnit: ShippingUnit;
        isPostponed: boolean;
        validatingOperator: Operand;
        validatingUser: string;
        postingDate: string;
        postingTime: integer;
        pickingOrderSorting: string;
        ssccParcelCode: string;
        dockStore: Store;
        dockAddress: Location;
        originDockStore: Store;
        originDockAddress: Location;
        stockOnDockStatus: Colis;
        isStockOnDockControl: boolean;
        pickingOrderType: PoType;
        shippingUnits: ClientCollection<ShippingUnit>;
        outputMovements: ClientCollection<OutputMovement>;
        wave: Wave;
    }
    export interface ParcelInputExtension {
        site?: string;
        depositor?: string;
        code?: string;
        deliveryOrder?: string;
        pickingOrder?: string;
        palletisationOrder?: string;
        status?: ParcelStatus;
        preparationArea?: string;
        pickingMode?: string;
        parcelRange?: string;
        parcelType?: string;
        height?: decimal | string;
        width?: decimal | string;
        depth?: decimal | string;
        volume?: decimal | string;
        estimatedWeight?: decimal | string;
        realWeight?: decimal | string;
        isDispatchableInState?: boolean | string;
        isPalettizableAsIs?: boolean | string;
        carrierParcelNumber?: string;
        carrier?: string;
        transportationMethod?: string;
        deliveryNote?: string;
        shippingUnit?: string;
        isPostponed?: boolean | string;
        validatingOperator?: string;
        validatingUser?: string;
        postingDate?: string;
        postingTime?: integer | string;
        pickingOrderSorting?: string;
        ssccParcelCode?: string;
        dockStore?: string;
        dockAddress?: string;
        originDockStore?: string;
        originDockAddress?: string;
        stockOnDockStatus?: Colis;
        isStockOnDockControl?: boolean | string;
        pickingOrderType?: PoType;
        shippingUnits?: Partial<ShippingUnitInput>[];
        outputMovements?: Partial<OutputMovementInput>[];
        wave?: string;
    }
    export interface ParcelBindingExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        code: string;
        deliveryOrder: DeliveryOrder;
        pickingOrder: PickingOrder;
        palletisationOrder: AutoPalletizationOrder;
        status: ParcelStatus;
        preparationArea: PreparationArea;
        pickingMode: PickingMode;
        parcelRange: RangeOfParcel;
        parcelType: ParcelType;
        height: string;
        width: string;
        depth: string;
        volume: string;
        estimatedWeight: string;
        realWeight: string;
        isDispatchableInState: boolean;
        isPalettizableAsIs: boolean;
        carrierParcelNumber: string;
        carrier: Carrier;
        transportationMethod: TransportMode;
        deliveryNote: DeliveryNote;
        shippingUnit: ShippingUnit;
        isPostponed: boolean;
        validatingOperator: Operand;
        validatingUser: string;
        postingDate: string;
        postingTime: integer;
        pickingOrderSorting: string;
        ssccParcelCode: string;
        dockStore: Store;
        dockAddress: Location;
        originDockStore: Store;
        originDockAddress: Location;
        stockOnDockStatus: Colis;
        isStockOnDockControl: boolean;
        pickingOrderType: PoType;
        shippingUnits: ClientCollection<ShippingUnit>;
        outputMovements: ClientCollection<OutputMovement>;
        wave: Wave;
    }
    export interface ParcelExtension$Lookups {
        wave: QueryOperation<Wave>;
    }
    export interface ParcelExtension$Operations {
        lookups(dataOrId: string | { data: ParcelInput }): ParcelExtension$Lookups;
    }
    export interface PickingOrderExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        code: string;
        status: StoringListPurchaseOrderStatus;
        pickingOrderType: PoType;
        pickingMode: PickingMode;
        preparationArea: PreparationArea;
        deliveryOrder: DeliveryOrder;
        round: Round;
        level: ContainerLevel;
        isPreparationOrderKit: boolean;
        date: string;
        time: string;
        totalMovements: integer;
        totalConsumptionUnit: string;
        totalWeight: string;
        totalVolume: string;
        preparationTime: string;
        equivalentSurface: string;
        numberOfParcels: integer;
        numberOfShippingUnits: integer;
        subWaveNumber: integer;
        shipTo: Customer;
        validatingOperator: Operand;
        postingDate: string;
        postingTime: integer;
        validatingUser: string;
        wave: Wave;
        outputMovements: ClientCollection<OutputMovement>;
    }
    export interface PickingOrderInputExtension {
        site?: string;
        depositor?: string;
        code?: string;
        status?: StoringListPurchaseOrderStatus;
        pickingOrderType?: PoType;
        pickingMode?: string;
        preparationArea?: string;
        deliveryOrder?: string;
        round?: string;
        level?: ContainerLevel;
        isPreparationOrderKit?: boolean | string;
        date?: string;
        time?: string;
        totalMovements?: integer | string;
        totalConsumptionUnit?: decimal | string;
        totalWeight?: decimal | string;
        totalVolume?: decimal | string;
        preparationTime?: decimal | string;
        equivalentSurface?: decimal | string;
        numberOfParcels?: integer | string;
        numberOfShippingUnits?: integer | string;
        subWaveNumber?: integer | string;
        shipTo?: string;
        validatingOperator?: string;
        postingDate?: string;
        postingTime?: integer | string;
        validatingUser?: string;
        wave?: string;
        outputMovements?: Partial<OutputMovementInput>[];
    }
    export interface PickingOrderBindingExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        code: string;
        status: StoringListPurchaseOrderStatus;
        pickingOrderType: PoType;
        pickingMode: PickingMode;
        preparationArea: PreparationArea;
        deliveryOrder: DeliveryOrder;
        round: Round;
        level: ContainerLevel;
        isPreparationOrderKit: boolean;
        date: string;
        time: string;
        totalMovements: integer;
        totalConsumptionUnit: string;
        totalWeight: string;
        totalVolume: string;
        preparationTime: string;
        equivalentSurface: string;
        numberOfParcels: integer;
        numberOfShippingUnits: integer;
        subWaveNumber: integer;
        shipTo: Customer;
        validatingOperator: Operand;
        postingDate: string;
        postingTime: integer;
        validatingUser: string;
        wave: Wave;
        outputMovements: ClientCollection<OutputMovement>;
    }
    export interface PickingOrderExtension$Lookups {
        wave: QueryOperation<Wave>;
    }
    export interface PickingOrderExtension$Operations {
        lookups(dataOrId: string | { data: PickingOrderInput }): PickingOrderExtension$Lookups;
    }
    export interface ShippingUnitExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        code: string;
        status: ShippingUnitStatus;
        shippingUnitType: ShippingUnitType;
        deliveryOrder: DeliveryOrder;
        isShippingUnitSingleDeliveryOrder: boolean;
        isShippingUnitSingleCustomer: boolean;
        pickingOrder: PickingOrder;
        preparationArea: PreparationArea;
        pickingMode: PickingMode;
        palletisationOrder: AutoPalletizationOrder;
        shipTo: Customer;
        postalCode: string;
        isPostponed: boolean;
        height: string;
        width: string;
        depth: string;
        volume: string;
        weight: string;
        estimatedWeight: string;
        numberOfParcels: integer;
        parcel: Parcel;
        ssccShippingUnitCode: string;
        dockStore: Store;
        dockAddress: Location;
        originDockStore: Store;
        originDockAddress: Location;
        stockOnDockStatus: Colis;
        isStockOnDockControl: boolean;
        isWrappedShippingUnit: boolean;
        creationType: SuCreationType;
        subWaveNumber: integer;
        isDispatchableInState: boolean;
        parcels: ClientCollection<Parcel>;
        companyNames: ClientCollection<ShippingUnitCompanyNames>;
        wave: Wave;
    }
    export interface ShippingUnitInputExtension {
        site?: string;
        depositor?: string;
        code?: string;
        status?: ShippingUnitStatus;
        shippingUnitType?: string;
        deliveryOrder?: string;
        isShippingUnitSingleDeliveryOrder?: boolean | string;
        isShippingUnitSingleCustomer?: boolean | string;
        pickingOrder?: string;
        preparationArea?: string;
        pickingMode?: string;
        palletisationOrder?: string;
        shipTo?: string;
        postalCode?: string;
        isPostponed?: boolean | string;
        height?: decimal | string;
        width?: decimal | string;
        depth?: decimal | string;
        volume?: decimal | string;
        weight?: decimal | string;
        estimatedWeight?: decimal | string;
        numberOfParcels?: integer | string;
        parcel?: string;
        ssccShippingUnitCode?: string;
        dockStore?: string;
        dockAddress?: string;
        originDockStore?: string;
        originDockAddress?: string;
        stockOnDockStatus?: Colis;
        isStockOnDockControl?: boolean | string;
        isWrappedShippingUnit?: boolean | string;
        creationType?: SuCreationType;
        subWaveNumber?: integer | string;
        isDispatchableInState?: boolean | string;
        parcels?: Partial<ParcelInput>[];
        companyNames?: Partial<ShippingUnitCompanyNamesInput>[];
        wave?: string;
    }
    export interface ShippingUnitBindingExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        code: string;
        status: ShippingUnitStatus;
        shippingUnitType: ShippingUnitType;
        deliveryOrder: DeliveryOrder;
        isShippingUnitSingleDeliveryOrder: boolean;
        isShippingUnitSingleCustomer: boolean;
        pickingOrder: PickingOrder;
        preparationArea: PreparationArea;
        pickingMode: PickingMode;
        palletisationOrder: AutoPalletizationOrder;
        shipTo: Customer;
        postalCode: string;
        isPostponed: boolean;
        height: string;
        width: string;
        depth: string;
        volume: string;
        weight: string;
        estimatedWeight: string;
        numberOfParcels: integer;
        parcel: Parcel;
        ssccShippingUnitCode: string;
        dockStore: Store;
        dockAddress: Location;
        originDockStore: Store;
        originDockAddress: Location;
        stockOnDockStatus: Colis;
        isStockOnDockControl: boolean;
        isWrappedShippingUnit: boolean;
        creationType: SuCreationType;
        subWaveNumber: integer;
        isDispatchableInState: boolean;
        parcels: ClientCollection<Parcel>;
        companyNames: ClientCollection<ShippingUnitCompanyNamesBinding>;
        wave: Wave;
    }
    export interface ShippingUnitExtension$Lookups {
        wave: QueryOperation<Wave>;
    }
    export interface ShippingUnitExtension$Operations {
        lookups(dataOrId: string | { data: ShippingUnitInput }): ShippingUnitExtension$Lookups;
    }
    export interface TransferMovementExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        transferNumber: string;
        code: string;
        movementCode: MovementCode;
        assemblingWave: AssemblingWave;
        subWaveNumber: integer;
        adjustment: AdjustmentMovement;
        store: Store;
        location: Location;
        stockObject: StockObject;
        containerNumber: string;
        originStore: Store;
        originAddress: Location;
        locationType: LocationType;
        sourceProduct: Product;
        originStockObject: StockObject;
        originContainer: ProductContainer;
        originQuantity: string;
        originSource: Origin;
        numberOfContainer: string;
        container: ProductContainer;
        numberOfConsumptionUnit: string;
        level: ContainerLevel;
        status: ReplenishmentMovementType;
        movementType: MovementType;
        masterStockObject: StockObject;
        masterContainerNumber: string;
        masterProduct: Product;
        date: string;
        time: string;
        homogeneousQuantity: string;
        homogeneousContainer: ProductContainer;
        homogeneousContainerCoefficient: string;
        receiptDate: string;
        manufacturedDate: string;
        detentionDate: string;
        sellByDate: string;
        shipByDate: string;
        useByDate: string;
        fifoDate: string;
        lotNumber: string;
        supportNumber: string;
        reservationNumber: string;
        stockStatus: StockNature;
        sortPreparationOrder: string;
        rowLevel: string;
        travelSequence: string;
        transferObject: StockObject;
        transferStore: Store;
        transferAddress: Location;
        position: integer;
        validatingOperator: Operand;
        validatingUser: string;
        postingDate: string;
        postingTime: integer;
        flowNumber: integer;
        pickingOperator: Operand;
        pickingUser: string;
        pickingDate: string;
        pickingTime: integer;
        groupingCode: string;
        depositObject: StockObject;
        depositStore: Store;
        depositLocation: Location;
        containerLevels: ClientCollection<TransferMovementContainerLevels>;
        wave: Wave;
    }
    export interface TransferMovementInputExtension {
        site?: string;
        depositor?: string;
        transferNumber?: string;
        code?: string;
        movementCode?: string;
        assemblingWave?: string;
        subWaveNumber?: integer | string;
        adjustment?: string;
        store?: string;
        location?: string;
        stockObject?: string;
        containerNumber?: string;
        originStore?: string;
        originAddress?: string;
        locationType?: LocationType;
        sourceProduct?: string;
        originStockObject?: string;
        originContainer?: string;
        originQuantity?: decimal | string;
        originSource?: string;
        numberOfContainer?: decimal | string;
        container?: string;
        numberOfConsumptionUnit?: decimal | string;
        level?: ContainerLevel;
        status?: ReplenishmentMovementType;
        movementType?: MovementType;
        masterStockObject?: string;
        masterContainerNumber?: string;
        masterProduct?: string;
        date?: string;
        time?: string;
        homogeneousQuantity?: decimal | string;
        homogeneousContainer?: string;
        homogeneousContainerCoefficient?: decimal | string;
        receiptDate?: string;
        manufacturedDate?: string;
        detentionDate?: string;
        sellByDate?: string;
        shipByDate?: string;
        useByDate?: string;
        fifoDate?: string;
        lotNumber?: string;
        supportNumber?: string;
        reservationNumber?: string;
        stockStatus?: string;
        sortPreparationOrder?: string;
        rowLevel?: string;
        travelSequence?: string;
        transferObject?: string;
        transferStore?: string;
        transferAddress?: string;
        position?: integer | string;
        validatingOperator?: string;
        validatingUser?: string;
        postingDate?: string;
        postingTime?: integer | string;
        flowNumber?: integer | string;
        pickingOperator?: string;
        pickingUser?: string;
        pickingDate?: string;
        pickingTime?: integer | string;
        groupingCode?: string;
        depositObject?: string;
        depositStore?: string;
        depositLocation?: string;
        containerLevels?: Partial<TransferMovementContainerLevelsInput>[];
        wave?: string;
    }
    export interface TransferMovementBindingExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        transferNumber: string;
        code: string;
        movementCode: MovementCode;
        assemblingWave: AssemblingWave;
        subWaveNumber: integer;
        adjustment: AdjustmentMovement;
        store: Store;
        location: Location;
        stockObject: StockObject;
        containerNumber: string;
        originStore: Store;
        originAddress: Location;
        locationType: LocationType;
        sourceProduct: Product;
        originStockObject: StockObject;
        originContainer: ProductContainer;
        originQuantity: string;
        originSource: Origin;
        numberOfContainer: string;
        container: ProductContainer;
        numberOfConsumptionUnit: string;
        level: ContainerLevel;
        status: ReplenishmentMovementType;
        movementType: MovementType;
        masterStockObject: StockObject;
        masterContainerNumber: string;
        masterProduct: Product;
        date: string;
        time: string;
        homogeneousQuantity: string;
        homogeneousContainer: ProductContainer;
        homogeneousContainerCoefficient: string;
        receiptDate: string;
        manufacturedDate: string;
        detentionDate: string;
        sellByDate: string;
        shipByDate: string;
        useByDate: string;
        fifoDate: string;
        lotNumber: string;
        supportNumber: string;
        reservationNumber: string;
        stockStatus: StockNature;
        sortPreparationOrder: string;
        rowLevel: string;
        travelSequence: string;
        transferObject: StockObject;
        transferStore: Store;
        transferAddress: Location;
        position: integer;
        validatingOperator: Operand;
        validatingUser: string;
        postingDate: string;
        postingTime: integer;
        flowNumber: integer;
        pickingOperator: Operand;
        pickingUser: string;
        pickingDate: string;
        pickingTime: integer;
        groupingCode: string;
        depositObject: StockObject;
        depositStore: Store;
        depositLocation: Location;
        containerLevels: ClientCollection<TransferMovementContainerLevelsBinding>;
        wave: Wave;
    }
    export interface TransferMovementExtension$Lookups {
        wave: QueryOperation<Wave>;
    }
    export interface TransferMovementExtension$Operations {
        lookups(dataOrId: string | { data: TransferMovementInput }): TransferMovementExtension$Lookups;
    }
    export interface Package {
        '@sage/wh-output-stock/Wave': Wave$Operations;
    }
    export interface GraphApi
        extends Package,
            SageWhMasterData$Package,
            SageWhOutput$Package,
            SageWhProductData$Package,
            SageWhStock$Package,
            SageWhStockData$Package,
            SageWhStructure$Package,
            SageWhSystem$Package,
            SageXtremAppMetadata$Package,
            SageXtremX3SystemUtils$Package {}
}
declare module '@sage/wh-output-stock-api' {
    export type * from '@sage/wh-output-stock-api-partial';
}
declare module '@sage/wh-master-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/wh-output-stock-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/wh-output-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/wh-output-stock-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/wh-product-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/wh-output-stock-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/wh-stock-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/wh-output-stock-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/wh-stock-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/wh-output-stock-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/wh-structure-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/wh-output-stock-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/wh-system-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/wh-output-stock-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/xtrem-app-metadata-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/wh-output-stock-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/xtrem-x3-system-utils-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/wh-output-stock-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/wh-output-api-partial' {
    import type {
        AutoPalletizationOrderBindingExtension,
        AutoPalletizationOrderExtension,
        AutoPalletizationOrderExtension$Lookups,
        AutoPalletizationOrderExtension$Operations,
        AutoPalletizationOrderInputExtension,
        DeliveryNoteBindingExtension,
        DeliveryNoteExtension,
        DeliveryNoteExtension$Lookups,
        DeliveryNoteExtension$Operations,
        DeliveryNoteInputExtension,
        DeliveryOrderBindingExtension,
        DeliveryOrderExtension,
        DeliveryOrderExtension$Lookups,
        DeliveryOrderExtension$Operations,
        DeliveryOrderInputExtension,
        OutputMovementBindingExtension,
        OutputMovementExtension,
        OutputMovementExtension$Lookups,
        OutputMovementExtension$Operations,
        OutputMovementInputExtension,
        ParcelBindingExtension,
        ParcelExtension,
        ParcelExtension$Lookups,
        ParcelExtension$Operations,
        ParcelInputExtension,
        PickingOrderBindingExtension,
        PickingOrderExtension,
        PickingOrderExtension$Lookups,
        PickingOrderExtension$Operations,
        PickingOrderInputExtension,
        ShippingUnitBindingExtension,
        ShippingUnitExtension,
        ShippingUnitExtension$Lookups,
        ShippingUnitExtension$Operations,
        ShippingUnitInputExtension,
    } from '@sage/wh-output-stock-api';
    export interface AutoPalletizationOrder extends AutoPalletizationOrderExtension {}
    export interface AutoPalletizationOrderBinding extends AutoPalletizationOrderBindingExtension {}
    export interface AutoPalletizationOrderInput extends AutoPalletizationOrderInputExtension {}
    export interface AutoPalletizationOrder$Lookups extends AutoPalletizationOrderExtension$Lookups {}
    export interface AutoPalletizationOrder$Operations extends AutoPalletizationOrderExtension$Operations {}
    export interface DeliveryNote extends DeliveryNoteExtension {}
    export interface DeliveryNoteBinding extends DeliveryNoteBindingExtension {}
    export interface DeliveryNoteInput extends DeliveryNoteInputExtension {}
    export interface DeliveryNote$Lookups extends DeliveryNoteExtension$Lookups {}
    export interface DeliveryNote$Operations extends DeliveryNoteExtension$Operations {}
    export interface DeliveryOrder extends DeliveryOrderExtension {}
    export interface DeliveryOrderBinding extends DeliveryOrderBindingExtension {}
    export interface DeliveryOrderInput extends DeliveryOrderInputExtension {}
    export interface DeliveryOrder$Lookups extends DeliveryOrderExtension$Lookups {}
    export interface DeliveryOrder$Operations extends DeliveryOrderExtension$Operations {}
    export interface OutputMovement extends OutputMovementExtension {}
    export interface OutputMovementBinding extends OutputMovementBindingExtension {}
    export interface OutputMovementInput extends OutputMovementInputExtension {}
    export interface OutputMovement$Lookups extends OutputMovementExtension$Lookups {}
    export interface OutputMovement$Operations extends OutputMovementExtension$Operations {}
    export interface Parcel extends ParcelExtension {}
    export interface ParcelBinding extends ParcelBindingExtension {}
    export interface ParcelInput extends ParcelInputExtension {}
    export interface Parcel$Lookups extends ParcelExtension$Lookups {}
    export interface Parcel$Operations extends ParcelExtension$Operations {}
    export interface PickingOrder extends PickingOrderExtension {}
    export interface PickingOrderBinding extends PickingOrderBindingExtension {}
    export interface PickingOrderInput extends PickingOrderInputExtension {}
    export interface PickingOrder$Lookups extends PickingOrderExtension$Lookups {}
    export interface PickingOrder$Operations extends PickingOrderExtension$Operations {}
    export interface ShippingUnit extends ShippingUnitExtension {}
    export interface ShippingUnitBinding extends ShippingUnitBindingExtension {}
    export interface ShippingUnitInput extends ShippingUnitInputExtension {}
    export interface ShippingUnit$Lookups extends ShippingUnitExtension$Lookups {}
    export interface ShippingUnit$Operations extends ShippingUnitExtension$Operations {}
}
declare module '@sage/wh-stock-api-partial' {
    import type {
        TransferMovementBindingExtension,
        TransferMovementExtension,
        TransferMovementExtension$Lookups,
        TransferMovementExtension$Operations,
        TransferMovementInputExtension,
    } from '@sage/wh-output-stock-api';
    export interface TransferMovement extends TransferMovementExtension {}
    export interface TransferMovementBinding extends TransferMovementBindingExtension {}
    export interface TransferMovementInput extends TransferMovementInputExtension {}
    export interface TransferMovement$Lookups extends TransferMovementExtension$Lookups {}
    export interface TransferMovement$Operations extends TransferMovementExtension$Operations {}
}
