/**
 * Get the RegExp equivalent for the 4GL pattern given
 *
 * @param pattern The 4GL pattern you want to get the RegExp equivalent
 * @returns The RegExp
 */
export function getRegExp(pattern: string): RegExp {
    const rule: string =
        // escape RegExp spécial chars
        pattern
            .replace(/[-[\]{}()+.,\\^$|\s]/g, '\\$&')
            // translate the pattern
            .replace(/\*/g, '.*')
            .replace(/\?/g, '.')
            .replace(/#/g, '\\d')
            .replace(/!/g, '[A-Za-z]');
    return new RegExp(`^${rule}$`);
}

export function getRegExpForMultiplePat(multiplePattern: string): RegExp {
    // const str1 = '(';
    const rule: string = `${`(${
        // convert each pattern individually and join them using |
        multiplePattern
            .split(',')
            .map(multPat => getRegExp(multPat).source.replace(/\^/g, '').replace(/\$/g, ''))
            .join('|')
    }`})`;
    return new RegExp(`^${rule}$`);
}

/**
 * Perform a 4GL pattern check
 *
 * @param text The text to be tested
 * @param pat The 4GL pattern to apply
 * @returns The result of the test as a boolean
 */
export function pat(text: string, pattern: string): boolean {
    return getRegExp(pattern).test(text);
}
