import { BarcodeParser } from './barcode-parser-abstract';
import { BarcodeParserComposite } from './barcode-parser-composite';
import { ParserConfiguration, TypeOfBarcodeParser } from './barcode-parser-configuration';
import { BarcodeParserGs1 } from './barcode-parser-gs1';

export interface BarcodeParserFactoryBase {
    createParser(): BarcodeParser;
}

export class BarcodeParserFactory implements BarcodeParserFactoryBase {
    constructor(protected readonly _parserConfiguration?: ParserConfiguration) {}

    createParser(): BarcodeParser {
        if (
            !this._parserConfiguration ||
            this._parserConfiguration.typeOfBarcodeParser === <TypeOfBarcodeParser>'gs1'
        ) {
            return new BarcodeParserGs1();
        }

        switch (this._parserConfiguration.typeOfBarcodeParser) {
            case 'composite':
                return new BarcodeParserComposite(this._parserConfiguration);

            // Add other cases for different service types
            default:
                throw new Error(`Unsupported parser type ${this._parserConfiguration?.typeOfBarcodeParser ?? ''}`);
        }
    }
}
