import { ParsedGenericBarcode, ParserConfiguration, TypeOfBarcodeParser } from './barcode-parser-configuration';
import { ParsedBarcode } from './parsed-element';

export interface BarcodeParser {
    parse(barcode: string): ParsedBarcode | ParsedGenericBarcode;
    parserConfiguration: ParserConfiguration | undefined;
    parserType: TypeOfBarcodeParser;
}

export abstract class AbstractBarcodeParser implements BarcodeParser {
    constructor(private readonly _parserConfiguration?: ParserConfiguration) {}

    abstract parse(barcode: string): ParsedBarcode | ParsedGenericBarcode;

    /**
     * Parser configuration
     */
    get parserConfiguration(): ParserConfiguration | undefined {
        return this._parserConfiguration;
    }

    /**
     *  Type of parser
     */
    public get parserType(): TypeOfBarcodeParser {
        return this._parserConfiguration?.typeOfBarcodeParser ?? <TypeOfBarcodeParser>'gs1';
    }
}
