import type { Destination, User } from '@sage/wh-system-api';

export function getDestinations(user: User | null): Destination[] | null {
    const defaultDestinations: Destination[] = [];
    if (user) {
        user.userDestinations.query.edges.forEach(item => {
            const userDestination = item.node.destination;
            if (userDestination) {
                defaultDestinations.push(userDestination);
            }
        });
    }
    return defaultDestinations;
}
