import type { Site, User, UserFunctionProfile } from '@sage/wh-system-api';

export function getUserProfile(user: User | null): UserFunctionProfile | null {
    if (user) {
        const { functionProfile } = user;
        if (!functionProfile) {
            return user.profession?.functionProfile ?? null;
        }
        return functionProfile;
    }
    return null;
}

export function getSiteFromModule(moduleNumber: number, profile: UserFunctionProfile): Site | null {
    const _edges = profile?.userProfileDefaultSites?.query?.edges;
    if (_edges && moduleNumber > 0 && moduleNumber <= (_edges?.length ?? 0)) {
        return _edges[moduleNumber - 1].node.site;
    }
    return null;
}

export function getDefaultSiteFromModule(user: User, moduleNumber: number): Site | null {
    const userProfile = getUserProfile(user);
    if (userProfile) {
        return getSiteFromModule(moduleNumber, userProfile);
    }
    return null;
}
