import type { GraphApi } from '@sage/wh-system-api';
import * as ui from '@sage/xtrem-ui';
import { BarcodeConfigurator } from './barcode-configurator';
import { ManagementServiceComposite } from './management-service-composite';
import { ManagementServiceGs1 } from './management-service-gs1';
import { BarcodeManagementServiceInterface, ServiceFactoryManagementBarcode } from './type-of-barcode-management';

export class BarcodeManagementServiceFactory implements ServiceFactoryManagementBarcode {
    // eslint-disable-next-line class-methods-use-this
    async createService(
        pageInstance: ui.Page<GraphApi>,
        serviceKey: string,
        codeFlow?: string,
    ): Promise<BarcodeManagementServiceInterface> {
        // If the flow code is not provided or the configuration was not found, the default service gs1 is applied
        if (codeFlow) {
            const _barcodeConfigurator = new BarcodeConfigurator();
            if (await _barcodeConfigurator.initConfigurator(pageInstance, codeFlow)) {
                return new ManagementServiceComposite(serviceKey, _barcodeConfigurator.barcodeManagementConfiguration);
            }
        }
        return new ManagementServiceGs1(serviceKey);
    }
}
