"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ParsedGenericElement = exports.ElementTypeEnum = void 0;
exports.getElementType = getElementType;
var ElementTypeEnum;
(function (ElementTypeEnum) {
    ElementTypeEnum["string"] = "string";
    ElementTypeEnum["number"] = "number";
    ElementTypeEnum["date"] = "date";
})(ElementTypeEnum || (exports.ElementTypeEnum = ElementTypeEnum = {}));
/*
 * GetElementType returns the ElementTypeEnum for a given DataTypeSupported
 * @param _currentType: DataTypeSupported - the data type
 * @returns ElementTypeEnum - the element type
 */
function getElementType(_currentType) {
    switch (_currentType) {
        case 'string':
            return ElementTypeEnum.string;
        case 'number':
            return ElementTypeEnum.number;
        case 'DateValue':
            return ElementTypeEnum.date;
        default:
            return ElementTypeEnum.string;
    }
}
/**
 * ParsedGenericElement class represents a single element of the barcode data
 * It is common for compatibility reasons with its GS1 counterpart except that the elementDataTitle is a string.
 */
class ParsedGenericElement {
    constructor(ai, elementDataTitle, elementType) {
        this.ai = ai;
        this.elementDataTitle = elementDataTitle;
        this.elementType = elementType;
        this._defineData(elementType);
    }
    _defineData(elementType) {
        /* defines the object which represents a single element
         */
        switch (elementType) {
            case ElementTypeEnum.string:
                this._data = '';
                break;
            case ElementTypeEnum.number:
                this._data = 0;
                break;
            case ElementTypeEnum.date:
                this._data = '';
                break;
            default:
                this._data = '';
                break;
        }
        this.unit = undefined; // some elements are accompanied by an unit of
    }
    get data() {
        return this._data;
    }
    set data(data) {
        this._data = data;
    }
    get unit() {
        return this._unit;
    }
    set unit(unit) {
        this._unit = unit;
    }
}
exports.ParsedGenericElement = ParsedGenericElement;
//# sourceMappingURL=parsed-generic-element.js.map