import { DateValue } from '@sage/xtrem-date-time';
export declare enum ElementTypeEnum {
    string = "string",
    number = "number",
    date = "date"
}
export type ElementType = keyof typeof ElementTypeEnum;
export type DataTypeSupported = string | DateValue | number;
export type UnitTypeSupported = string | undefined;
export declare function getElementType(_currentType: DataTypeSupported): ElementTypeEnum;
export interface ParsedGenericBarcode {
    codeName: string;
    parsedCodeItems: ParsedGenericElement[];
}
/**
 * ParsedGenericElement class represents a single element of the barcode data
 * It is common for compatibility reasons with its GS1 counterpart except that the elementDataTitle is a string.
 */
export declare class ParsedGenericElement {
    readonly ai: string;
    readonly elementDataTitle: string;
    readonly elementType: ElementType;
    private _data;
    private _unit;
    constructor(ai: string, elementDataTitle: string, elementType: ElementType);
    protected _defineData(elementType: ElementType): void;
    get data(): DataTypeSupported;
    set data(data: DataTypeSupported);
    get unit(): UnitTypeSupported;
    set unit(unit: UnitTypeSupported);
}
//# sourceMappingURL=parsed-generic-element.d.ts.map