import { ElementType, ParsedGenericBarcode, ParsedGenericElement } from './parsed-generic-element';
export declare enum DataTitle {
    amount = "AMOUNT",
    price = "PRICE",
    prodDate = "PROD DATE",
    batchLot = "BATCH/LOT",
    dueDate = "DUE DATE",
    packDate = "PACK DATE",
    bestBefore = "BEST BEFORE or BEST BY",
    expiryDate = "USE BY OR EXPIRY",
    sellBy = "SELL BY",
    sscc = "SSCC",
    gtin = "GTIN",
    ginc = "GINC",
    gsin = "GSIN",
    content = "CONTENT",
    variant = "VARIANT",
    serial = "SERIAL",
    cpv = "CPV",
    additionalId = "ADDITIONAL ID",
    customPartNumber = "CUST. PART NO.",
    mtoVariant = "MTO VARIAN",
    pcn = "PCN",
    varCount = "VAR. COUNT",
    orderNumber = "ORDER NUMBER",
    route = "ROUTE",
    shipToLoc = "SHIP TO LOC",
    billTo = "BILL TO",
    purchaseFrom = "PURCHASE FROM",
    shipForLoc = "SHIP FOR LOC",
    shipToPost = "SHIP TO POST",
    origin = "ORIGIN",
    countryInitialProcess = "COUNTRY - INITIAL PROCESS.",
    countryProcess = "COUNTRY - PROCESS.",
    countryDisassembly = "COUNTRY - DISASSEMBLY",
    countryFullProcess = "COUNTRY - FULL PROCESS",
    countrySubdivision = "ORIGIN SUBDIVISION",
    nsn = "NSN",
    meatCut = "MEAT CUT",
    expiryTime = "EXPIRY TIME",
    activePotency = "ACTIVE POTENCY",
    netWeight = "NET WEIGHT",
    grossWeight = "GROSS WEIGHT",
    length = "LENGTH",
    width = "WIDTH",
    height = "HEIGHT",
    area = "AREA",
    netVolume = "NET VOLUME",
    volume = "VOLUME",
    kgPerSquareMeter = "KG PER SQUARE METER"
}
export declare enum UnitOfMeasure {
    EACH = "EACH",
    MILLIMETER = "MILLIMETER",
    CENTIMETER = "CENTIMETER",
    METER = "METER",
    KILOMETER = "KILOMETER",
    INCH = "INCH",
    FOOT = "FOOT",
    YARD = "YARD",
    MILE = "MILE",
    MILLILITER = "MILLILITER",
    LITER = "LITER",
    CUBIC_METER = "CUBIC_METER",
    FLUID_OUNCE = "FLUID_OUNCE",
    CUP = "CUP",
    PINT = "PINT",
    QUART = "QUART",
    GALLON = "GALLON",
    CUBIC_INCH = "CUBIC_INCH",
    CUBIC_FOOT = "CUBIC_FOOT",
    CUBIC_YARD = "CUBIC_YARD",
    GRAM = "GRAM",
    KILOGRAM = "KILOGRAM",
    METRIC_TON = "METRIC_TON",
    OUNCE = "OUNCE",
    POUND = "POUND",
    STONE = "STONE",
    HUNDREDWEIGHT = "HUNDREDWEIGHT",
    SHORT_TON = "SHORT_TON",
    SECOND = "SECOND",
    MINUTE = "MINUTE",
    HOUR = "HOUR",
    DAY = "DAY",
    SQUARE_MILLIMETER = "SQUARE_MILLIMETER",
    SQUARE_CENTIMETER = "SQUARE_CENTIMETER",
    SQUARE_METER = "SQUARE_METER",
    SQUARE_INCH = "SQUARE_INCH",
    SQUARE_FOOT = "SQUARE_FOOT",
    SQUARE_YARD = "SQUARE_YARD",
    TROY_OUNCES = "TROY_OUNCES",
    _28 = "28"
}
export interface ParsedBarcode extends Omit<ParsedGenericBarcode, 'parsedCodeItems'> {
    parsedCodeItems: ParsedElement[];
}
export declare class ParsedElement extends ParsedGenericElement {
    readonly ai: string;
    readonly elementDataTitle: DataTitle;
    readonly elementType: ElementType;
    constructor(ai: string, elementDataTitle: DataTitle, elementType: ElementType);
}
//# sourceMappingURL=parsed-element.d.ts.map