"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BarcodeParserFactory = void 0;
const typesLib = require("@sage/xtrem-decimal");
const barcode_parser_composite_1 = require("./barcode-parser-composite");
const barcode_parser_gs1_1 = require("./barcode-parser-gs1");
class BarcodeParserFactory {
    constructor(_parserConfiguration) {
        this._parserConfiguration = _parserConfiguration;
    }
    createParser() {
        if (!this._parserConfiguration || typesLib.strictEq(this._parserConfiguration.typeOfBarcodeParser, 'gs1')) {
            return new barcode_parser_gs1_1.BarcodeParserGs1();
        }
        switch (this._parserConfiguration.typeOfBarcodeParser) {
            case 'composite':
                return new barcode_parser_composite_1.BarcodeParserComposite(this._parserConfiguration);
            // Add other cases for different service types
            default:
                throw new Error(`Unsupported parser type ${this._parserConfiguration?.typeOfBarcodeParser ?? ''}`);
        }
    }
}
exports.BarcodeParserFactory = BarcodeParserFactory;
//# sourceMappingURL=barcode-parser-factory.js.map