"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ParsedGenericElement = exports.CompositeFormat = exports.CompositeDateFormat = void 0;
exports.getDateFormatSize = getDateFormatSize;
exports.getDateFormat = getDateFormat;
const parsed_generic_element_1 = require("./parsed-generic-element");
var CompositeDateFormat;
(function (CompositeDateFormat) {
    CompositeDateFormat["ddmmyy"] = "ddmmyy";
    CompositeDateFormat["ddmmyyyy"] = "ddmmyyyy";
    CompositeDateFormat["yymmdd"] = "yymmdd";
    CompositeDateFormat["yyyymmdd"] = "yyyymmdd";
    CompositeDateFormat["yyyy_mm_dd"] = "yyyy_mm_dd";
})(CompositeDateFormat || (exports.CompositeDateFormat = CompositeDateFormat = {}));
var CompositeFormat;
(function (CompositeFormat) {
    CompositeFormat["delimited"] = "delimited";
    CompositeFormat["fixedLength"] = "fixed";
})(CompositeFormat || (exports.CompositeFormat = CompositeFormat = {}));
/* getDateFormatSize returns the size of the date format
 * @param dateFormat: CompositeDateFormat - the date format
 * @returns number - the size of the date format
 */
function getDateFormatSize(dateFormat) {
    switch (dateFormat) {
        case CompositeDateFormat.ddmmyy:
        case CompositeDateFormat.yymmdd:
            return 6;
        case CompositeDateFormat.ddmmyyyy:
        case CompositeDateFormat.yyyymmdd:
            return 8;
        case CompositeDateFormat.yyyy_mm_dd:
            return 10;
        default:
            return 0;
    }
}
/* getDateFormat returns the date format
 * @param dateFormat: CompositeDateFormat - the date format
 * @returns string - the date format
 */
function getDateFormat(dateFormat) {
    switch (dateFormat) {
        case CompositeDateFormat.ddmmyy:
            return 'DDMMYY';
        case CompositeDateFormat.ddmmyyyy:
            return 'DDMMYYYY';
        case CompositeDateFormat.yymmdd:
            return 'YYMMDD';
        case CompositeDateFormat.yyyymmdd:
            return 'YYYYMMDD';
        case CompositeDateFormat.yyyy_mm_dd:
            return 'YYYY-MM-DD';
        default:
            return 'YYYYMMDD';
    }
}
/**
 * ParsedGenericElement class represents a single element of the barcode data
 * It is common for compatibility reasons with its GS1 counterpart except that the elementDataTitle is a string.
 */
class ParsedGenericElement {
    constructor(ai, elementDataTitle, elementType) {
        this.ai = ai;
        this.elementDataTitle = elementDataTitle;
        this.elementType = elementType;
        this._defineData(elementType);
    }
    _defineData(elementType) {
        /* defines the object which represents a single element
         */
        switch (elementType) {
            case parsed_generic_element_1.ElementTypeEnum.string:
                this._data = '';
                break;
            case parsed_generic_element_1.ElementTypeEnum.number:
                this._data = 0;
                break;
            case parsed_generic_element_1.ElementTypeEnum.date:
                this._data = '';
                break;
            default:
                this._data = '';
                break;
        }
        this.unit = undefined; // some elements are accompanied by an unit of
    }
    set unit(unit) {
        this._unit = unit;
    }
    get unit() {
        return this._unit;
    }
    set data(data) {
        this._data = data;
    }
    get data() {
        return this._data;
    }
}
exports.ParsedGenericElement = ParsedGenericElement;
//# sourceMappingURL=barcode-parser-configuration.js.map