import { DataTypeSupported, ElementType, UnitTypeSupported } from './parsed-generic-element';
export type TypeOfBarcodeParser = 'gs1' | 'composite';
export declare enum CompositeDateFormat {
    ddmmyy = "ddmmyy",
    ddmmyyyy = "ddmmyyyy",
    yymmdd = "yymmdd",
    yyyymmdd = "yyyymmdd",
    yyyy_mm_dd = "yyyy_mm_dd"
}
export declare enum CompositeFormat {
    delimited = "delimited",
    fixedLength = "fixed"
}
export interface ParserConfigurationLine {
    fieldKey: string;
    fieldAlias?: string;
    fieldDataType: DataTypeSupported;
    description?: string;
    startPosition?: number;
    length?: number;
}
export interface ParserConfiguration {
    typeOfBarcodeParser: TypeOfBarcodeParser;
    compositeCode: string;
    localizedDescription?: string;
    isBlankDeletion: boolean;
    compositeFormat: CompositeFormat;
    dateFormat: CompositeDateFormat;
    dateLabel: string;
    fieldSeparator: string;
    decimalSeparator: string;
    recordSize: number;
    numberOfAlias: number;
    lines: ParserConfigurationLine[];
}
export declare function getDateFormatSize(dateFormat: CompositeDateFormat): number;
export declare function getDateFormat(dateFormat: CompositeDateFormat): string;
export interface ParsedGenericBarcode {
    codeName: string;
    parsedCodeItems: ParsedGenericElement[];
}
/**
 * ParsedGenericElement class represents a single element of the barcode data
 * It is common for compatibility reasons with its GS1 counterpart except that the elementDataTitle is a string.
 */
export declare class ParsedGenericElement {
    readonly ai: string;
    readonly elementDataTitle: string;
    readonly elementType: ElementType;
    private _data;
    private _unit;
    constructor(ai: string, elementDataTitle: string, elementType: ElementType);
    protected _defineData(elementType: ElementType): void;
    set unit(unit: UnitTypeSupported);
    get unit(): UnitTypeSupported;
    set data(data: DataTypeSupported);
    get data(): DataTypeSupported;
}
//# sourceMappingURL=barcode-parser-configuration.d.ts.map