import { ParsedGenericBarcode, ParserConfiguration, TypeOfBarcodeParser } from './barcode-parser-configuration';
import { ParsedBarcode } from './parsed-element';
export interface BarcodeParser {
    parse(barcode: string): ParsedBarcode | ParsedGenericBarcode;
    parserConfiguration: ParserConfiguration | undefined;
    parserType: TypeOfBarcodeParser;
}
export declare abstract class AbstractBarcodeParser implements BarcodeParser {
    private readonly _parserConfiguration?;
    constructor(_parserConfiguration?: ParserConfiguration);
    abstract parse(barcode: string): ParsedBarcode | ParsedGenericBarcode;
    /**
     * Parser configuration
     */
    get parserConfiguration(): ParserConfiguration | undefined;
    /**
     *  Type of parser
     */
    get parserType(): TypeOfBarcodeParser;
}
//# sourceMappingURL=barcode-parser-abstract.d.ts.map