"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.User = void 0;
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageWhSystem = require("..");
const joins = {
    referenceJoins: {
        profession: {
            profession: 'profession',
        },
        menuProfile: {
            profile() {
                return 0;
            },
            module: 'menuProfile',
        },
        functionProfile: {
            profile: 'functionProfile',
        },
        access: {
            access: 'access',
        },
        userModel: {
            code: 'userModel',
        },
        image: {
            code() {
                return 'AUSPIC';
            },
            identifier1: 'code',
            identifier2() {
                return null;
            },
            identifier3() {
                return null;
            },
        },
    },
};
const compositeReferences = {
    image: {
        picture: 'data',
    },
};
let User = class User extends xtrem_core_1.Node {
};
exports.User = User;
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'USR',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], User.prototype, "code", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ENAFLG',
    })
], User.prototype, "activeInSelec", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'NOMUSR',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], User.prototype, "name", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'INTUSR',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.translatableTextDatatype,
    })
], User.prototype, "nameDescription", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CODMET',
        columnType: 'string',
        node: () => sageWhSystem.nodes.SyracusMethod,
    })
], User.prototype, "profession", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PRFMEN',
        columnType: 'integer',
        filters: {
            lookup: {
                profile: 0,
            },
            control: {
                profile: 0,
            },
        },
        node: () => sageWhSystem.nodes.UserProfileMenu,
    })
], User.prototype, "menuProfile", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PRFFCT',
        columnType: 'string',
        node: () => sageWhSystem.nodes.UserFunctionProfile,
    })
], User.prototype, "functionProfile", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ADDEML',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], User.prototype, "email", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'LOGIN',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], User.prototype, "login", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ALLACS',
    })
], User.prototype, "allAccessCodes", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'USREXT',
    })
], User.prototype, "externalUser", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'USRCONNECT',
    })
], User.prototype, "x3Connection", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'USRCONXTD',
    })
], User.prototype, "webServicesConnection", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CODRIBDFT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], User.prototype, "defaultBankId", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ACSUSR',
        columnType: 'string',
        node: () => sageWhSystem.nodes.Access,
    })
], User.prototype, "access", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BIDNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], User.prototype, "bankIdNumber", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'USRPRT',
        columnType: 'string',
        node: () => sageWhSystem.nodes.User,
    })
], User.prototype, "userModel", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ARCPRF',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], User.prototype, "profile", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnType: 'string',
        filters: {
            lookup: {
                code: 'AUSPIC',
                identifier2: null,
                identifier3: null,
            },
            control: {
                code: 'AUSPIC',
                identifier2: null,
                identifier3: null,
            },
        },
        node: () => sageWhSystem.nodes.Image,
    })
], User.prototype, "image", void 0);
__decorate([
    xtrem_core_1.decorators.binaryStreamProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BLOB',
    })
], User.prototype, "picture", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageWhSystem.nodes.UserFunctions,
    })
], User.prototype, "functions", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageWhSystem.nodes.UserSupervisors,
    })
], User.prototype, "supervisors", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageWhSystem.nodes.UserUserDestinations,
    })
], User.prototype, "userDestinations", void 0);
exports.User = User = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'AUTILIS',
        keyPropertyNames: ['code'],
        indexes: [
            {
                orderBy: {
                    code: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            compositeReferences,
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], User);
//# sourceMappingURL=user.js.map