"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserProfileMenu = void 0;
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageWhSystem = require("..");
const joins = {
    localizedStrings: {
        profileDescription: {
            tableName() {
                return 'APROFIL';
            },
            columnName() {
                return 'INTPRF';
            },
            key1: [() => 0],
            key2: ['profile'],
        },
    },
};
let UserProfileMenu = class UserProfileMenu extends xtrem_core_1.Node {
};
exports.UserProfileMenu = UserProfileMenu;
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CODPRF',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], UserProfileMenu.prototype, "profile", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'MODULE',
        dataType: () => sageWhSystem.enums.moduleTableDatatype,
        lookupAccess: true,
    })
], UserProfileMenu.prototype, "module", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TYPPRF',
        dataType: () => sageWhSystem.enums.profileTypeFunctionDatatype,
        lookupAccess: true,
    })
], UserProfileMenu.prototype, "profileType", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'MEM',
        lookupAccess: true,
    })
], UserProfileMenu.prototype, "memory", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'INTPRF',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.translatableTextDatatype,
        lookupAccess: true,
    })
], UserProfileMenu.prototype, "profileDescription", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'MENDEP',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], UserProfileMenu.prototype, "startMenu", void 0);
exports.UserProfileMenu = UserProfileMenu = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'APROFIL',
        keyPropertyNames: ['profile', 'module'],
        indexes: [
            {
                orderBy: {
                    profile: 1,
                    module: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            joinFallbackProperties: ['module'],
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], UserProfileMenu);
//# sourceMappingURL=user-profile-menu.js.map