"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserParameterValue = void 0;
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageWhSystem = require("..");
const joins = {
    referenceJoins: {
        user: {
            code: 'user',
        },
        defaultSetOfValues: {
            glossaryId() {
                return 912;
            },
            code: 'defaultSetOfValues',
        },
    },
};
let UserParameterValue = class UserParameterValue extends xtrem_core_1.Node {
    static readByUserParameterValueDate(context, parameters) {
        return xtrem_x3_gateway_1.X3StorageManager.executeApiOperation(context, 'SCRIPT', 'UserParameterValue', 'readByUserParameterValueDate', parameters);
    }
    static readByUserParameterValueInteger(context, parameters) {
        return xtrem_x3_gateway_1.X3StorageManager.executeApiOperation(context, 'SCRIPT', 'UserParameterValue', 'readByUserParameterValueInteger', parameters);
    }
    static readByUserParameterValueString(context, parameters) {
        return xtrem_x3_gateway_1.X3StorageManager.executeApiOperation(context, 'SCRIPT', 'UserParameterValue', 'readByUserParameterValueString', parameters);
    }
    static readParameterValueDate(context, parameters) {
        return xtrem_x3_gateway_1.X3StorageManager.executeApiOperation(context, 'SCRIPT', 'UserParameterValue', 'readParameterValueDate', parameters);
    }
    static readParameterValueInteger(context, parameters) {
        return xtrem_x3_gateway_1.X3StorageManager.executeApiOperation(context, 'SCRIPT', 'UserParameterValue', 'readParameterValueInteger', parameters);
    }
    static readParameterValueString(context, parameters) {
        return xtrem_x3_gateway_1.X3StorageManager.executeApiOperation(context, 'SCRIPT', 'UserParameterValue', 'readParameterValueString', parameters);
    }
    static updateUserSiteDepositor(context, parameters) {
        return xtrem_x3_gateway_1.X3StorageManager.executeApiOperation(context, 'SCRIPT', 'UserParameterValue', 'updateUserSiteDepositor', parameters);
    }
};
exports.UserParameterValue = UserParameterValue;
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PARAM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], UserParameterValue.prototype, "description", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CODUSR',
        columnType: 'string',
        node: () => sageWhSystem.nodes.User,
        lookupAccess: true,
    })
], UserParameterValue.prototype, "user", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'VALEUR',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], UserParameterValue.prototype, "value", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'JEU',
        columnType: 'string',
        filters: {
            lookup: {
                glossaryId: 912,
            },
            control: {
                glossaryId: 912,
            },
        },
        node: () => sageWhSystem.nodes.MiscellaneousTable,
        lookupAccess: true,
    })
], UserParameterValue.prototype, "defaultSetOfValues", void 0);
__decorate([
    xtrem_core_1.decorators.mutation({
        /* RequestNodeName: ReadBaseUserParameterValueDate */
        isPublished: true,
        parameters: [
            {
                name: 'parameters',
                type: 'object',
                properties: {
                    code: {
                        isMandatory: true,
                        type: 'string',
                    },
                    user: {
                        isMandatory: true,
                        type: 'string',
                    },
                },
            },
        ],
        return: {
            type: 'object',
            properties: {
                value: {
                    isMandatory: true,
                    type: 'date',
                },
            },
        },
    })
], UserParameterValue, "readByUserParameterValueDate", null);
__decorate([
    xtrem_core_1.decorators.mutation({
        /* RequestNodeName: ReadBaseUserParameterValueInteger */
        isPublished: true,
        parameters: [
            {
                name: 'parameters',
                type: 'object',
                properties: {
                    code: {
                        isMandatory: true,
                        type: 'string',
                    },
                    user: {
                        isMandatory: true,
                        type: 'string',
                    },
                },
            },
        ],
        return: {
            type: 'object',
            properties: {
                value: {
                    isMandatory: true,
                    type: 'integer',
                },
            },
        },
    })
], UserParameterValue, "readByUserParameterValueInteger", null);
__decorate([
    xtrem_core_1.decorators.mutation({
        /* RequestNodeName: ReadBaseUserParameterValueString */
        isPublished: true,
        parameters: [
            {
                name: 'parameters',
                type: 'object',
                properties: {
                    code: {
                        isMandatory: true,
                        type: 'string',
                    },
                    user: {
                        isMandatory: true,
                        type: 'string',
                    },
                },
            },
        ],
        return: {
            type: 'object',
            properties: {
                value: {
                    isMandatory: true,
                    type: 'string',
                },
            },
        },
    })
], UserParameterValue, "readByUserParameterValueString", null);
__decorate([
    xtrem_core_1.decorators.mutation({
        /* RequestNodeName: ReadUserParameterValueDate */
        isPublished: true,
        parameters: [
            {
                name: 'parameters',
                type: 'object',
                properties: {
                    code: {
                        isMandatory: true,
                        type: 'string',
                    },
                },
            },
        ],
        return: {
            type: 'object',
            properties: {
                value: {
                    isMandatory: true,
                    type: 'date',
                },
            },
        },
    })
], UserParameterValue, "readParameterValueDate", null);
__decorate([
    xtrem_core_1.decorators.mutation({
        /* RequestNodeName: ReadUserParameterValueInteger */
        isPublished: true,
        parameters: [
            {
                name: 'parameters',
                type: 'object',
                properties: {
                    code: {
                        isMandatory: true,
                        type: 'string',
                    },
                },
            },
        ],
        return: {
            type: 'object',
            properties: {
                value: {
                    isMandatory: true,
                    type: 'integer',
                },
            },
        },
    })
], UserParameterValue, "readParameterValueInteger", null);
__decorate([
    xtrem_core_1.decorators.mutation({
        /* RequestNodeName: ReadUserParameterValueString */
        isPublished: true,
        parameters: [
            {
                name: 'parameters',
                type: 'object',
                properties: {
                    code: {
                        isMandatory: true,
                        type: 'string',
                    },
                },
            },
        ],
        return: {
            type: 'object',
            properties: {
                value: {
                    isMandatory: true,
                    type: 'string',
                },
            },
        },
    })
], UserParameterValue, "readParameterValueString", null);
__decorate([
    xtrem_core_1.decorators.mutation({
        /* RequestNodeName: UpdateUserSiteDepositor */
        isPublished: true,
        parameters: [
            {
                name: 'parameters',
                type: 'object',
                properties: {
                    user: {
                        isMandatory: true,
                        type: 'string',
                    },
                    site: {
                        isMandatory: true,
                        type: 'string',
                    },
                    depositor: {
                        isMandatory: true,
                        type: 'string',
                    },
                    errorCode: {
                        isMandatory: true,
                        type: 'integer',
                    },
                },
            },
        ],
        return: {
            type: 'object',
            properties: {
                errorCode: {
                    isMandatory: true,
                    type: 'integer',
                },
            },
        },
    })
], UserParameterValue, "updateUserSiteDepositor", null);
exports.UserParameterValue = UserParameterValue = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'ADOVALAUS',
        keyPropertyNames: ['description', 'user'],
        indexes: [
            {
                orderBy: {
                    description: 1,
                    user: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            joinFallbackProperties: ['user'],
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], UserParameterValue);
//# sourceMappingURL=user-parameter-value.js.map