import { Node, Reference, Context, DateValue } from '@sage/xtrem-core';
import * as sageWhSystem from '..';
export declare class UserParameterValue extends Node {
    readonly description: Promise<string>;
    readonly user: Reference<sageWhSystem.nodes.User | null>;
    readonly value: Promise<string>;
    readonly defaultSetOfValues: Reference<sageWhSystem.nodes.MiscellaneousTable | null>;
    static readByUserParameterValueDate(context: Context, parameters: {
        code: string;
        user: string;
    }): Promise<{
        value: DateValue;
    }>;
    static readByUserParameterValueInteger(context: Context, parameters: {
        code: string;
        user: string;
    }): Promise<{
        value: number;
    }>;
    static readByUserParameterValueString(context: Context, parameters: {
        code: string;
        user: string;
    }): Promise<{
        value: string;
    }>;
    static readParameterValueDate(context: Context, parameters: {
        code: string;
    }): Promise<{
        value: DateValue;
    }>;
    static readParameterValueInteger(context: Context, parameters: {
        code: string;
    }): Promise<{
        value: number;
    }>;
    static readParameterValueString(context: Context, parameters: {
        code: string;
    }): Promise<{
        value: string;
    }>;
    static updateUserSiteDepositor(context: Context, parameters: {
        user: string;
        site: string;
        depositor: string;
        errorCode: number;
    }): Promise<{
        errorCode: number;
    }>;
}
//# sourceMappingURL=user-parameter-value.d.ts.map