"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MiscellaneousTables = void 0;
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageWhSystem = require("..");
const joins = {
    referenceJoins: {
        activityCode: {
            code: 'activityCode',
        },
        access: {
            access: 'access',
        },
        dependency: {
            glossaryId: 'dependency',
        },
    },
    localizedStrings: {
        description: {
            tableName() {
                return 'ATABTAB';
            },
            columnName() {
                return 'LNGDES';
            },
            key1: ['tableNumber'],
        },
        shortDescription: {
            tableName() {
                return 'ATABTAB';
            },
            columnName() {
                return 'SHODES';
            },
            key1: ['tableNumber'],
        },
        alpha1: {
            tableName() {
                return 'ATABTAB';
            },
            columnName() {
                return 'ALPDES1';
            },
            key1: ['tableNumber'],
        },
        alpha2: {
            tableName() {
                return 'ATABTAB';
            },
            columnName() {
                return 'ALPDES2';
            },
            key1: ['tableNumber'],
        },
        numeric1: {
            tableName() {
                return 'ATABTAB';
            },
            columnName() {
                return 'NUMDES1';
            },
            key1: ['tableNumber'],
        },
        numeric2: {
            tableName() {
                return 'ATABTAB';
            },
            columnName() {
                return 'NUMDES2';
            },
            key1: ['tableNumber'],
        },
    },
};
let MiscellaneousTables = class MiscellaneousTables extends xtrem_core_1.Node {
};
exports.MiscellaneousTables = MiscellaneousTables;
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'NUMTAB',
        lookupAccess: true,
    })
], MiscellaneousTables.prototype, "glossaryId", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'NUMCAR',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], MiscellaneousTables.prototype, "tableNumber", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'LNGDES',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.translatableTextDatatype,
        lookupAccess: true,
    })
], MiscellaneousTables.prototype, "description", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SHODES',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.translatableTextDatatype,
        lookupAccess: true,
    })
], MiscellaneousTables.prototype, "shortDescription", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ALPDES1',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.translatableTextDatatype,
        lookupAccess: true,
    })
], MiscellaneousTables.prototype, "alpha1", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CODTYP1',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], MiscellaneousTables.prototype, "type1", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SUP1',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], MiscellaneousTables.prototype, "option1", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ALPDES2',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.translatableTextDatatype,
        lookupAccess: true,
    })
], MiscellaneousTables.prototype, "alpha2", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CODTYP2',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], MiscellaneousTables.prototype, "type2", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SUP2',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], MiscellaneousTables.prototype, "option2", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'NUMDES1',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.translatableTextDatatype,
        lookupAccess: true,
    })
], MiscellaneousTables.prototype, "numeric1", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CODTYP3',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], MiscellaneousTables.prototype, "type3", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SUP3',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], MiscellaneousTables.prototype, "option3", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'NUMDES2',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.translatableTextDatatype,
        lookupAccess: true,
    })
], MiscellaneousTables.prototype, "numeric2", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CODTYP4',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], MiscellaneousTables.prototype, "type4", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SUP4',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], MiscellaneousTables.prototype, "option4", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'NBCOL',
        lookupAccess: true,
    })
], MiscellaneousTables.prototype, "number", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CODACT',
        columnType: 'string',
        node: () => sageWhSystem.nodes.ActivityCode,
        lookupAccess: true,
    })
], MiscellaneousTables.prototype, "activityCode", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ACS',
        columnType: 'string',
        node: () => sageWhSystem.nodes.Access,
        lookupAccess: true,
    })
], MiscellaneousTables.prototype, "access", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'MODULE',
        dataType: () => sageWhSystem.enums.moduleTableDatatype,
        lookupAccess: true,
    })
], MiscellaneousTables.prototype, "module", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DEPNUM',
        columnType: 'integer',
        node: () => sageWhSystem.nodes.MiscellaneousTables,
        lookupAccess: true,
    })
], MiscellaneousTables.prototype, "dependency", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'LNGFLG',
        lookupAccess: true,
    })
], MiscellaneousTables.prototype, "modifiableLength", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LNG',
        lookupAccess: true,
    })
], MiscellaneousTables.prototype, "length", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FLGSOC',
        lookupAccess: true,
    })
], MiscellaneousTables.prototype, "companyFilter", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'OBLLEG',
        lookupAccess: true,
    })
], MiscellaneousTables.prototype, "legislationMandatory", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FLGLEG',
        lookupAccess: true,
    })
], MiscellaneousTables.prototype, "filterLegislation", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FLGENA',
        lookupAccess: true,
    })
], MiscellaneousTables.prototype, "activeFlag", void 0);
exports.MiscellaneousTables = MiscellaneousTables = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'ATABTAB',
        keyPropertyNames: ['glossaryId'],
        indexes: [
            {
                orderBy: {
                    glossaryId: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], MiscellaneousTables);
//# sourceMappingURL=miscellaneous-tables.js.map