"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.GeneralParametersData = void 0;
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageWhSystem = require("..");
const joins = {
    referenceJoins: {
        company: {
            code: 'company',
        },
        siteOrLegislationCode: {
            code: 'siteOrLegislationCode',
        },
        defaultSetOfValues: {
            glossaryId() {
                return 912;
            },
            code: 'defaultSetOfValues',
        },
    },
};
let GeneralParametersData = class GeneralParametersData extends xtrem_core_1.Node {
    static readParameterValueDate(context, parameters) {
        return xtrem_x3_gateway_1.X3StorageManager.executeApiOperation(context, 'SCRIPT', 'GeneralParametersData', 'readParameterValueDate', parameters);
    }
    static readParameterValueInteger(context, parameters) {
        return xtrem_x3_gateway_1.X3StorageManager.executeApiOperation(context, 'SCRIPT', 'GeneralParametersData', 'readParameterValueInteger', parameters);
    }
    static readParameterValueString(context, parameters) {
        return xtrem_x3_gateway_1.X3StorageManager.executeApiOperation(context, 'SCRIPT', 'GeneralParametersData', 'readParameterValueString', parameters);
    }
};
exports.GeneralParametersData = GeneralParametersData;
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PARAM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], GeneralParametersData.prototype, "code", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CMP',
        columnType: 'string',
        node: () => sageWhSystem.nodes.Company,
        lookupAccess: true,
    })
], GeneralParametersData.prototype, "company", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'FCY',
        columnType: 'string',
        node: () => sageWhSystem.nodes.Site,
        lookupAccess: true,
    })
], GeneralParametersData.prototype, "siteOrLegislationCode", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'VALEUR',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], GeneralParametersData.prototype, "value", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'JEU',
        columnType: 'string',
        filters: {
            lookup: {
                glossaryId: 912,
            },
            control: {
                glossaryId: 912,
            },
        },
        node: () => sageWhSystem.nodes.MiscellaneousTable,
        lookupAccess: true,
    })
], GeneralParametersData.prototype, "defaultSetOfValues", void 0);
__decorate([
    xtrem_core_1.decorators.mutation({
        /* RequestNodeName: ReadParameterValueDate */
        isPublished: true,
        parameters: [
            {
                name: 'parameters',
                type: 'object',
                properties: {
                    company: {
                        isMandatory: true,
                        type: 'string',
                    },
                    site: {
                        isMandatory: true,
                        type: 'string',
                    },
                    code: {
                        isMandatory: true,
                        type: 'string',
                    },
                },
            },
        ],
        return: {
            type: 'object',
            properties: {
                value: {
                    isMandatory: true,
                    type: 'date',
                },
            },
        },
    })
], GeneralParametersData, "readParameterValueDate", null);
__decorate([
    xtrem_core_1.decorators.mutation({
        /* RequestNodeName: ReadParameterValueInteger */
        isPublished: true,
        parameters: [
            {
                name: 'parameters',
                type: 'object',
                properties: {
                    company: {
                        isMandatory: true,
                        type: 'string',
                    },
                    site: {
                        isMandatory: true,
                        type: 'string',
                    },
                    code: {
                        isMandatory: true,
                        type: 'string',
                    },
                },
            },
        ],
        return: {
            type: 'object',
            properties: {
                value: {
                    isMandatory: true,
                    type: 'integer',
                },
            },
        },
    })
], GeneralParametersData, "readParameterValueInteger", null);
__decorate([
    xtrem_core_1.decorators.mutation({
        /* RequestNodeName: ReadParameterValueString */
        isPublished: true,
        parameters: [
            {
                name: 'parameters',
                type: 'object',
                properties: {
                    company: {
                        isMandatory: true,
                        type: 'string',
                    },
                    site: {
                        isMandatory: true,
                        type: 'string',
                    },
                    code: {
                        isMandatory: true,
                        type: 'string',
                    },
                },
            },
        ],
        return: {
            type: 'object',
            properties: {
                value: {
                    isMandatory: true,
                    type: 'string',
                },
            },
        },
    })
], GeneralParametersData, "readParameterValueString", null);
exports.GeneralParametersData = GeneralParametersData = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'ADOVAL',
        keyPropertyNames: ['code', 'company', 'siteOrLegislationCode'],
        indexes: [
            {
                orderBy: {
                    code: 1,
                    company: 1,
                    siteOrLegislationCode: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            joinFallbackProperties: ['company', 'siteOrLegislationCode'],
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], GeneralParametersData);
//# sourceMappingURL=general-parameters-data.js.map