import { Node, Reference, Context, DateValue } from '@sage/xtrem-core';
import * as sageWhSystem from '..';
export declare class GeneralParametersData extends Node {
    readonly code: Promise<string>;
    readonly company: Reference<sageWhSystem.nodes.Company | null>;
    readonly siteOrLegislationCode: Reference<sageWhSystem.nodes.Site | null>;
    readonly value: Promise<string>;
    readonly defaultSetOfValues: Reference<sageWhSystem.nodes.MiscellaneousTable | null>;
    static readParameterValueDate(context: Context, parameters: {
        company: string;
        site: string;
        code: string;
    }): Promise<{
        value: DateValue;
    }>;
    static readParameterValueInteger(context: Context, parameters: {
        company: string;
        site: string;
        code: string;
    }): Promise<{
        value: number;
    }>;
    static readParameterValueString(context: Context, parameters: {
        company: string;
        site: string;
        code: string;
    }): Promise<{
        value: string;
    }>;
}
//# sourceMappingURL=general-parameters-data.d.ts.map