"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.GeneralParameter = void 0;
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageWhSystem = require("..");
const joins = {
    referenceJoins: {
        chapter: {
            glossaryId() {
                return 901;
            },
            code: 'chapter',
        },
        group: {
            glossaryId() {
                return 903;
            },
            code: 'group',
        },
        activityCode: {
            code: 'activityCode',
        },
        access: {
            access: 'access',
        },
    },
};
let GeneralParameter = class GeneralParameter extends xtrem_core_1.Node {
};
exports.GeneralParameter = GeneralParameter;
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PARAM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], GeneralParameter.prototype, "code", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CHAPITRE',
        columnType: 'string',
        filters: {
            lookup: {
                glossaryId: 901,
            },
            control: {
                glossaryId: 901,
            },
        },
        node: () => sageWhSystem.nodes.MiscellaneousTable,
        lookupAccess: true,
    })
], GeneralParameter.prototype, "chapter", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'GRPPAR',
        columnType: 'string',
        filters: {
            lookup: {
                glossaryId: 903,
            },
            control: {
                glossaryId: 903,
            },
        },
        node: () => sageWhSystem.nodes.MiscellaneousTable,
        lookupAccess: true,
    })
], GeneralParameter.prototype, "group", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'NAM',
        lookupAccess: true,
    })
], GeneralParameter.prototype, "description", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CODACT',
        columnType: 'string',
        node: () => sageWhSystem.nodes.ActivityCode,
        lookupAccess: true,
    })
], GeneralParameter.prototype, "activityCode", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TYPVAL',
        dataType: () => sageWhSystem.enums.fieldTypeDatatype,
        lookupAccess: true,
    })
], GeneralParameter.prototype, "valueType", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'MODIF',
        lookupAccess: true,
    })
], GeneralParameter.prototype, "isEditable", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'NOLIB',
        lookupAccess: true,
    })
], GeneralParameter.prototype, "localMenu", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'NIVDEF',
        dataType: () => sageWhSystem.enums.parameterDefinitionLevelDatatype,
        lookupAccess: true,
    })
], GeneralParameter.prototype, "definitionLevel", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'VALFLG',
        lookupAccess: true,
    })
], GeneralParameter.prototype, "isOffValue", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TRAIT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], GeneralParameter.prototype, "processing", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SELOPT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], GeneralParameter.prototype, "selectionOptions", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'AUSMODIF',
        lookupAccess: true,
    })
], GeneralParameter.prototype, "canUserUpdate", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'RANG',
        lookupAccess: true,
    })
], GeneralParameter.prototype, "sequence", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ACS',
        columnType: 'string',
        node: () => sageWhSystem.nodes.Access,
        lookupAccess: true,
    })
], GeneralParameter.prototype, "access", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'VALDEF',
        lookupAccess: true,
    })
], GeneralParameter.prototype, "folderValue", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CNDMOD',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], GeneralParameter.prototype, "modifyingCondition", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageWhSystem.nodes.GeneralParameterSelectableValues,
    })
], GeneralParameter.prototype, "selectableValues", void 0);
exports.GeneralParameter = GeneralParameter = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'ADOPAR',
        keyPropertyNames: ['code'],
        indexes: [
            {
                orderBy: {
                    code: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], GeneralParameter);
//# sourceMappingURL=general-parameter.js.map