"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.FunctionalProfilePerSite = void 0;
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageWhSystem = require("..");
const joins = {
    referenceJoins: {
        site: {
            code: 'site',
        },
        profile: {
            profile: 'profile',
        },
        function: {
            internal: 'function',
        },
    },
};
let FunctionalProfilePerSite = class FunctionalProfilePerSite extends xtrem_core_1.Node {
};
exports.FunctionalProfilePerSite = FunctionalProfilePerSite;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'FCY',
        columnType: 'string',
        node: () => sageWhSystem.nodes.Site,
        lookupAccess: true,
    })
], FunctionalProfilePerSite.prototype, "site", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PRFCOD',
        columnType: 'string',
        node: () => sageWhSystem.nodes.UserFunctionProfile,
        lookupAccess: true,
    })
], FunctionalProfilePerSite.prototype, "profile", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'FNC',
        columnType: 'string',
        node: () => sageWhSystem.nodes.Function,
        lookupAccess: true,
    })
], FunctionalProfilePerSite.prototype, "function", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'OPT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], FunctionalProfilePerSite.prototype, "options", void 0);
exports.FunctionalProfilePerSite = FunctionalProfilePerSite = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'AFCTFCY',
        keyPropertyNames: ['site', 'profile', 'function'],
        indexes: [
            {
                orderBy: {
                    site: 1,
                    profile: 1,
                    function: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            joinFallbackProperties: ['site', 'profile', 'function'],
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], FunctionalProfilePerSite);
//# sourceMappingURL=functional-profile-per-site.js.map