"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.FunctionOptions = void 0;
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageWhSystem = require("..");
const denormalized = { maxRepeat: 19 };
const joins = {
    referenceJoins: {
        _denormalizedParent: {
            internal: 'internal',
        },
        activityCode: {
            code: 'activityCode',
        },
        function: {
            internal: 'function',
        },
    },
};
let FunctionOptions = class FunctionOptions extends xtrem_core_1.Node {
};
exports.FunctionOptions = FunctionOptions;
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        lookupAccess: true,
    })
], FunctionOptions.prototype, "denormalizedIndex", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'CODINT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], FunctionOptions.prototype, "internal", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isStored: true,
        isVitalParent: true,
        columnType: 'string',
        node: () => sageWhSystem.nodes.Function,
    })
], FunctionOptions.prototype, "_denormalizedParent", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FLAG',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], FunctionOptions.prototype, "code", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ACTOPT',
        columnType: 'string',
        node: () => sageWhSystem.nodes.ActivityCode,
        lookupAccess: true,
    })
], FunctionOptions.prototype, "activityCode", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'OPTION',
        lookupAccess: true,
    })
], FunctionOptions.prototype, "title", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'FNCOPT',
        columnType: 'string',
        node: () => sageWhSystem.nodes.Function,
        lookupAccess: true,
    })
], FunctionOptions.prototype, "function", void 0);
exports.FunctionOptions = FunctionOptions = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'AFONCTION',
        keyPropertyNames: ['denormalizedIndex', 'internal'],
        indexes: [],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            isDenormalized: true,
            denormalized,
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
        isVitalCollectionChild: true,
    })
], FunctionOptions);
//# sourceMappingURL=function-options.js.map