"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Company = void 0;
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageWhSystem = require("..");
const joins = {
    referenceJoins: {
        legislation: {
            glossaryId() {
                return 909;
            },
            code: 'legislation',
        },
        mainSite: {
            code: 'mainSite',
        },
        sector1: {
            glossaryId() {
                return 360;
            },
            code: 'sector1',
        },
        sector2: {
            glossaryId() {
                return 361;
            },
            code: 'sector2',
        },
        federalState: {
            glossaryId() {
                return 80;
            },
            code: 'federalState',
        },
        rexNumber: {
            glossaryId() {
                return 1;
            },
            code: 'rexNumber',
        },
        logo: {
            code() {
                return 'LOGO';
            },
            identifier1: 'code',
            identifier2() {
                return null;
            },
            identifier3() {
                return null;
            },
        },
    },
};
let Company = class Company extends xtrem_core_1.Node {
};
exports.Company = Company;
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CPY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], Company.prototype, "code", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CPYNAM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], Company.prototype, "name", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CPYSHO',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], Company.prototype, "shortName", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CPYLEGFLG',
    })
], Company.prototype, "isLegalCompany", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LEG',
        columnType: 'string',
        filters: {
            lookup: {
                glossaryId: 909,
            },
            control: {
                glossaryId: 909,
            },
        },
        node: () => sageWhSystem.nodes.MiscellaneousTable,
        lookupAccess: true,
    })
], Company.prototype, "legislation", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'MAIFCY',
        columnType: 'string',
        node: () => sageWhSystem.nodes.Site,
    })
], Company.prototype, "mainSite", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CRN',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], Company.prototype, "identificationNumber", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'NAF',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], Company.prototype, "standardIndustrialClassificationCode", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'NID',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], Company.prototype, "uniqueIdentificationNumber", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CPYLOG',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], Company.prototype, "legalForm", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CCE',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], Company.prototype, "analyticalDimension", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'RGCAMT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageWhSystem.serviceOptions.EurActivityCode],
    })
], Company.prototype, "registredCapital", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'GRUCOD',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], Company.prototype, "consolidation", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DIVCOD',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageWhSystem.serviceOptions.KusActivityCode],
    })
], Company.prototype, "divisionCode", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'EECNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], Company.prototype, "europeanUnionVatNumber", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'STRPER',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], Company.prototype, "firstFiscalYear", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SCT1',
        columnType: 'string',
        filters: {
            lookup: {
                glossaryId: 360,
            },
            control: {
                glossaryId: 360,
            },
        },
        node: () => sageWhSystem.nodes.MiscellaneousTable,
    })
], Company.prototype, "sector1", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SCT2',
        columnType: 'string',
        filters: {
            lookup: {
                glossaryId: 361,
            },
            control: {
                glossaryId: 361,
            },
        },
        node: () => sageWhSystem.nodes.MiscellaneousTable,
    })
], Company.prototype, "sector2", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'NUMADD',
    })
], Company.prototype, "additionalNumber", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'STAFED',
        columnType: 'string',
        filters: {
            lookup: {
                glossaryId: 80,
            },
            control: {
                glossaryId: 80,
            },
        },
        node: () => sageWhSystem.nodes.MiscellaneousTable,
    })
], Company.prototype, "federalState", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'RTZFLG',
    })
], Company.prototype, "isRetention", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'AGTPCP',
    })
], Company.prototype, "isCollectionAgent", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'VACCPY',
        columnType: 'string',
        filters: {
            lookup: {
                glossaryId: 1,
            },
            control: {
                glossaryId: 1,
            },
        },
        node: () => sageWhSystem.nodes.MiscellaneousTable,
    })
], Company.prototype, "rexNumber", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'EORINUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageWhSystem.serviceOptions.EoriActivityCode],
    })
], Company.prototype, "eoriNumber", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SUBTOTAX',
    })
], Company.prototype, "subjectToTax", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnType: 'string',
        filters: {
            lookup: {
                code: 'LOGO',
                identifier2: null,
                identifier3: null,
            },
            control: {
                code: 'LOGO',
                identifier2: null,
                identifier3: null,
            },
        },
        node: () => sageWhSystem.nodes.Image,
    })
], Company.prototype, "logo", void 0);
exports.Company = Company = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'COMPANY',
        keyPropertyNames: ['code'],
        indexes: [
            {
                orderBy: {
                    code: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], Company);
//# sourceMappingURL=company.js.map