import { Node, Reference, decimal, date, integer } from '@sage/xtrem-core';
import * as sageWhSystem from '..';
export declare class Company extends Node {
    readonly code: Promise<string>;
    readonly name: Promise<string>;
    readonly shortName: Promise<string>;
    readonly isLegalCompany: Promise<boolean>;
    readonly legislation: Reference<sageWhSystem.nodes.MiscellaneousTable | null>;
    readonly mainSite: Reference<sageWhSystem.nodes.Site | null>;
    readonly identificationNumber: Promise<string>;
    readonly standardIndustrialClassificationCode: Promise<string>;
    readonly uniqueIdentificationNumber: Promise<string>;
    readonly legalForm: Promise<string>;
    readonly analyticalDimension: Promise<string>;
    readonly registredCapital: Promise<decimal | null>;
    readonly consolidation: Promise<string>;
    readonly divisionCode: Promise<string>;
    readonly europeanUnionVatNumber: Promise<string>;
    readonly firstFiscalYear: Promise<date | null>;
    readonly sector1: Reference<sageWhSystem.nodes.MiscellaneousTable | null>;
    readonly sector2: Reference<sageWhSystem.nodes.MiscellaneousTable | null>;
    readonly additionalNumber: Promise<integer | null>;
    readonly federalState: Reference<sageWhSystem.nodes.MiscellaneousTable | null>;
    readonly isRetention: Promise<boolean>;
    readonly isCollectionAgent: Promise<boolean>;
    readonly rexNumber: Reference<sageWhSystem.nodes.MiscellaneousTable | null>;
    readonly eoriNumber: Promise<string>;
    readonly subjectToTax: Promise<boolean>;
    readonly logo: Reference<sageWhSystem.nodes.Image | null>;
}
//# sourceMappingURL=company.d.ts.map