"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ActivityCode = void 0;
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageWhSystem = require("..");
const joins = {
    referenceJoins: {
        activityCode: {
            code: 'activityCode',
        },
    },
};
let ActivityCode = class ActivityCode extends xtrem_core_1.Node {
};
exports.ActivityCode = ActivityCode;
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CODACT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], ActivityCode.prototype, "code", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DIME',
        lookupAccess: true,
    })
], ActivityCode.prototype, "screenSize", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DIMFIL',
        lookupAccess: true,
    })
], ActivityCode.prototype, "databaseMinimumSize", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DIMMAX',
        lookupAccess: true,
    })
], ActivityCode.prototype, "maximumSize", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FLACT',
        lookupAccess: true,
    })
], ActivityCode.prototype, "activeFlag", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LIBACT',
        lookupAccess: true,
    })
], ActivityCode.prototype, "description", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'MODULE',
        dataType: () => sageWhSystem.enums.moduleTableDatatype,
        lookupAccess: true,
    })
], ActivityCode.prototype, "module", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'RANG',
        lookupAccess: true,
    })
], ActivityCode.prototype, "sequence", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ORDRE',
        lookupAccess: true,
    })
], ActivityCode.prototype, "order", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TYP',
        dataType: () => sageWhSystem.enums.typesOfActivityCodeDatatype,
        lookupAccess: true,
    })
], ActivityCode.prototype, "type", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DEP',
        dataType: () => sageWhSystem.enums.typeOfDependencyDatatype,
        lookupAccess: true,
    })
], ActivityCode.prototype, "dependency", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ACTDEP',
        columnType: 'string',
        node: () => sageWhSystem.nodes.ActivityCode,
        lookupAccess: true,
    })
], ActivityCode.prototype, "activityCode", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ACTFOR',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], ActivityCode.prototype, "formula", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'INTIT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], ActivityCode.prototype, "description1", void 0);
exports.ActivityCode = ActivityCode = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'ACTIV',
        keyPropertyNames: ['code'],
        indexes: [
            {
                orderBy: {
                    code: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], ActivityCode);
//# sourceMappingURL=activity-code.js.map