"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getUserProfile = getUserProfile;
exports.getSiteFromModule = getSiteFromModule;
exports.getDefaultSiteFromModule = getDefaultSiteFromModule;
const typesLib = require("@sage/xtrem-decimal");
/**
 * Server-side function to get user profile
 */
/**
 * Internal function to get user profile
 * @param _this Instance of the user
 * @returns
 */
async function getUserProfile(_this) {
    if (_this) {
        const functionProfile = await _this.functionProfile;
        if (!functionProfile) {
            return (await (await _this.profession)?.functionProfile) ?? null;
        }
        return functionProfile;
    }
    return null;
}
/**
 *  get site from module
 * @param _this
 * @param moduleNumber
 * @param profile
 * @returns
 */
async function getSiteFromModule(_this, moduleNumber, profile) {
    const _userDefaultSites = await profile?.userProfileDefaultSites?.toArray();
    if (_userDefaultSites && typesLib.gt(moduleNumber, 0) && typesLib.lte(moduleNumber, _userDefaultSites.length)) {
        return _userDefaultSites[typesLib.sub(moduleNumber, 1)]?.site;
    }
    return null;
}
/**
 *  get default site for the user for given module
 * @param _this
 * @param moduleNumber
 * @returns
 */
async function getDefaultSiteFromModule(_this, moduleNumber) {
    const userProfile = await getUserProfile(_this);
    if (userProfile) {
        return (await getSiteFromModule(_this, moduleNumber, userProfile)) ?? null;
    }
    return null;
}
//# sourceMappingURL=user-parameters-values.js.map