"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getUserProfile = getUserProfile;
exports.getSiteFromModule = getSiteFromModule;
exports.getDefaultSiteFromModule = getDefaultSiteFromModule;
const typesLib = require("@sage/xtrem-decimal");
function getUserProfile(user) {
    if (user) {
        const { functionProfile } = user;
        if (!functionProfile) {
            return user.profession?.functionProfile ?? null;
        }
        return functionProfile;
    }
    return null;
}
function getSiteFromModule(moduleNumber, profile) {
    const _edges = profile?.userProfileDefaultSites?.query?.edges;
    if (_edges && typesLib.gt(moduleNumber, 0) && typesLib.lte(moduleNumber, (_edges?.length ?? 0))) {
        return _edges[typesLib.sub(moduleNumber, 1)].node.site;
    }
    return null;
}
function getDefaultSiteFromModule(user, moduleNumber) {
    const userProfile = getUserProfile(user);
    if (userProfile) {
        return getSiteFromModule(moduleNumber, userProfile);
    }
    return null;
}
//# sourceMappingURL=user-parameters-values.js.map