import type { GraphApi } from '@sage/wh-system-api';
import * as ui from '@sage/xtrem-ui';
import { BarcodeManagementConfiguration } from './barcode-configurator';
import { AsyncAndVoidFunction, AsyncCompositeAllowed, BarcodeManagerSupportedFields, DictionaryDataGs1, DictionaryFieldSupported } from './screen-management';
export type TypeOfServiceBarcode = 'gs1' | 'composite';
export interface BarcodeManagementServiceInterface {
    abortDispatch(postActionAbortDispatch?: AsyncAndVoidFunction): boolean;
    clearAllCompositeDataAndStorage(pageInstance: ui.Page<any, any>, storageKey: string | undefined): void;
    clearCompositeData(): void;
    clearCompositeDataStorage(pageInstance: ui.Page<any, any>, storageKey: string | undefined): void;
    barcodeManagementConfiguration: BarcodeManagementConfiguration | undefined;
    scannedFieldId: string | undefined;
    initialize(pageInstance: ui.Page<GraphApi>, dictionaryFieldSupported: DictionaryFieldSupported, dictionaryDataComposites: DictionaryDataGs1 | undefined, checkCompositeDataAllowed?: AsyncCompositeAllowed): Promise<boolean>;
    isCompositeData(rawData: any): boolean;
    isDispatchInProgress: boolean;
    isInitializationInProgress: boolean;
    loadCompositeData(pageInstance: ui.Page<any, any>): boolean;
    saveCompositeData(pageInstance: ui.Page<any, any>): boolean;
    setScreenFieldSupported(pageInstance: ui.Page<any, any>, dictionaryFieldSupported: DictionaryFieldSupported): boolean | PromiseLike<boolean>;
    scan(pageInstance: ui.Page<GraphApi>, currentField: BarcodeManagerSupportedFields, rawData: any, appendCompositeData?: boolean): Promise<boolean>;
    typeOfServiceBarcode: TypeOfServiceBarcode;
}
export interface ServiceFactoryManagementBarcode {
    createService(pageInstance: ui.Page<GraphApi>, typeService: TypeOfServiceBarcode, serviceKey: string, codeFlow?: string): Promise<BarcodeManagementServiceInterface>;
}
//# sourceMappingURL=type-of-barcode-management.d.ts.map