import * as ui from '@sage/xtrem-ui';
import { AsyncCompositeAllowed, BarcodeManagerSupportedFields, DictionaryDataGs1, DictionaryFieldSupported } from './screen-management';
import { BarcodeManagementServiceInterface, TypeOfServiceBarcode } from './type-of-barcode-management';
export declare class SupportManagementService<GraphqlApi = any, NodeType extends ui.ClientNode = any> extends ui.Page<GraphqlApi, NodeType> {
    /**
     * Internal only
     */
    private _factory;
    /**
     *  Constructor of control manager GS 1
     * @param typeOfServiceBarCode type of service barcode
     */
    constructor();
    /**
     * Remove composite data
     */
    /** @protected */
    protected clearCompositeData(): void;
    /**
     * Remove composite data from storage
     * @param storageKey optional, for overriding current service key (use with caution)
     */
    /** @protected */
    protected clearCompositeDataStorage(storageKey?: string): void;
    /**
     * Remove all composite and storage data
     * @param storageKey optional, for overriding current service key (use with caution)
     */
    /** @protected */
    protected clearAllCompositeDataAndStorage(storageKey?: string): void;
    /**
     * Get current control manager instance
     * @returns current instance of control manager
     */
    /** @protected */
    protected get controlManager(): BarcodeManagementServiceInterface;
    /**
     * Create and initialize manager for a given service :
     * Depending on the type of manager used (not Gs1), the dictionary and checkCompositeDataAllowed parameters
     * may be ignored because the factory retrieves the configuration to know whether or not to use them.
     * The flow code is mandatory in order to load the configuration, except in the case of Gs1.
     *
     * @param site current site
     * @param compositePageKey key for storage operation
     * @param codeFlow optional flow code (mandatory for non-Gs1)
     * @param dictionaryFieldSupported fields screen to manage and control
     * @param dictionaryDataComposites? optional composite data
     * @param checkCompositeDataAllowed? optional client callback to check composite data code before to dispatch them
     * @return false when service has not properly initialized (unavailable)
     */
    /** @protected */
    protected createAndInitServiceManagement(site: string, compositePageKey: string, codeFlow: string | undefined, dictionaryFieldSupported: DictionaryFieldSupported, dictionaryDataComposites?: DictionaryDataGs1, checkCompositeDataAllowed?: AsyncCompositeAllowed): Promise<boolean>;
    /**
     * Disable or enable service (default : enable) :
     * Disabling clearing all composite data
     */
    /** @protected */
    protected set disableBarcodeService(disableServiceBarcode: boolean);
    /**
     * Protected only
     */
    /**
     * Return current state of service
     */
    /** @protected */
    protected get isBarcodeServiceDisabled(): boolean;
    /**
     * Load composite data from storage and erase them
     * @returns true when some data has been loaded
     */
    /** @protected */
    protected loadCompositeData(): boolean;
    /**
     * Save composite data, zero elements allowed
     * @returns true when operation has performed
     */
    /** @protected */
    protected saveCompositeData(): boolean;
    /**
     * Update screen fields supported (only when exists Gs1 parameters).
     * mapping field has been performed after
     * @param dictionaryFieldSupported dictionary of page fields submitted
     * @returns true when done, false when no any field to process with data
     */
    protected setScreenFieldSupported(dictionaryFieldSupported: DictionaryFieldSupported): Promise<boolean>;
    /**
     * call scan evaluator only when manager available and rawData has minimum requirement
     * @param mainField current screen field reference
     * @param rawData data to parse
     * @return false when is not a bar code composite
     */
    /** @protected */
    protected scan(mainField: BarcodeManagerSupportedFields, rawData: string): Promise<boolean>;
    /**
     * Return type of service barcode
     * @returns type of service barcode
     *
     */
    protected get typeOfServiceBarcode(): TypeOfServiceBarcode;
}
//# sourceMappingURL=support-management-service.d.ts.map