"use strict";
/** Interfaces and types for management code GS 1 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.isSoundSupportedField = isSoundSupportedField;
exports.isSupportedField = isSupportedField;
const xtrem_ui_1 = require("@sage/xtrem-ui");
/**
 * Check if the supported field support sound
 * @param field
 */
function isSoundSupportedField(field) {
    return [xtrem_ui_1.fields.Reference, xtrem_ui_1.fields.FilterSelect, xtrem_ui_1.fields.Select, xtrem_ui_1.fields.DropdownList].some(supportedFieldType => field instanceof supportedFieldType);
}
/**
 * Check if the field is an instance of any type in BarcodeManagerSupportedFields
 * @param field
 */
function isSupportedField(field) {
    return [
        xtrem_ui_1.fields.Reference,
        xtrem_ui_1.fields.Date,
        xtrem_ui_1.fields.Text,
        xtrem_ui_1.fields.Numeric,
        xtrem_ui_1.fields.FilterSelect,
        xtrem_ui_1.fields.Select,
        xtrem_ui_1.fields.DropdownList,
    ].some(supportedFieldType => field instanceof supportedFieldType);
}
//# sourceMappingURL=screen-management.js.map