/** Interfaces and types for management code GS 1 */
import { DateValue } from '@sage/xtrem-date-time';
import { fields } from '@sage/xtrem-ui';
import { DataTitle } from '../shared-functions/index';
export type BarcodeManagerSupportedFields = fields.Date | fields.DropdownList | fields.FilterSelect | fields.Numeric | fields.Reference | fields.Select | fields.Text;
/**
 * Check if the supported field support sound
 * @param field
 */
export declare function isSoundSupportedField(field: any): boolean;
/**
 * Check if the field is an instance of any type in BarcodeManagerSupportedFields
 * @param field
 */
export declare function isSupportedField(field: any): boolean;
export type ElementTypeSupported = string | DateValue | number | undefined;
export type AsyncVoidFunction = () => Promise<void>;
export type VoidFunction = () => void;
export type AsyncAndVoidFunction = AsyncVoidFunction | VoidFunction;
export interface FieldSupported {
    mainField: BarcodeManagerSupportedFields;
    unitField?: BarcodeManagerSupportedFields;
}
export type DictionaryFieldSupported = Record<DataTitle, FieldSupported>;
export type DictionaryGenericFieldSupported = Record<string, FieldSupported>;
export interface DataGeneric {
    dataKey: string;
    data: ElementTypeSupported;
    unit?: ElementTypeSupported;
}
/**
 * This composite item is used in storage and service
 */
export interface DataGs1 extends DataGeneric {
    dataKey: DataTitle;
}
/**
 * All composite data have stored in dictionary.
 */
export type DictionaryDataGs1 = Record<DataTitle, DataGs1>;
export type DictionaryDataGeneric = Record<string, DataGeneric>;
/**
 * This asynchronous function signature is used only for specifying
 * a call back to check composite data before continuous
 * @param dictionaryDataComposite : current dictionary  (may be empty)
 * @param scannedFieldId : the field id that has been scanned
 * @return true when dispatching is allowing to continue action
 *         false when dispatching must clear all composites and exiting
 */
export type AsyncCompositeAllowed = (dictionaryDataComposite: DictionaryDataGs1 | DictionaryDataGeneric, scannedFieldId?: string) => Promise<boolean>;
//# sourceMappingURL=screen-management.d.ts.map