"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ManagementServiceGs1 = void 0;
const typesLib = require("@sage/xtrem-decimal");
const barcode_management_service_1 = require("./barcode-management-service");
class ManagementServiceGs1 extends barcode_management_service_1.BarcodeManagementService {
    /**
     * This Method build instance with retrieving all data
     * @param pageInstance : current page
     * @param dictionaryFieldSupported : page fields supported
     * @param dictionaryDataComposites : extracted composite data, may be send to storage
     * @param checkCompositeDataAllowed? : optional client callback to check composite data code before to dispatch them
     */
    // eslint-disable-next-line require-await
    async initialize(pageInstance, dictionaryFieldSupported = {}, dictionaryDataComposites = {}, checkCompositeDataAllowed) {
        return super.initialize(pageInstance, ManagementServiceGs1._getDictionaryFieldSupported(dictionaryFieldSupported), dictionaryDataComposites, checkCompositeDataAllowed);
    }
    /**
     * Check if raw data is a composite data
     * @param rawData
     * @returns
     */
    // eslint-disable-next-line class-methods-use-this
    isCompositeData(rawData) {
        const groupSeparator = String.fromCharCode(0x1d); // GS1 Group Separator
        const compositeCodePrefix = new RegExp(`^(\\d{2,4}|\\][A-Za-z]\\d{3,5}|${groupSeparator.replace(/[.*+?^${}()|[\]\\]/g, '\\$&')}\\d{2,4})`);
        return (rawData && typesLib.strictEq(typeof rawData, 'string') && typesLib.gte(rawData.length, 4) &&
            !!Number(rawData.match(compositeCodePrefix)?.length ?? 0));
    }
    /**
     * Update screen fields supported.
     * field mapping was done after
     * @param pageInstance current page
     * @param dictionaryFieldSupported dictionary of page fields submitted
     * @returns true when done, false when no any field to process with data
     */
    // eslint-disable-next-line require-await
    async setScreenFieldSupported(pageInstance, dictionaryFieldSupported) {
        return super.setScreenFieldSupported(pageInstance, ManagementServiceGs1._getDictionaryFieldSupported(dictionaryFieldSupported));
    }
    /**
     * Called when field update is in progress
     * @param pageInstance current page
     * @param currentField reference of field to updating
     * @param rawData received raw data
     * @param appendCompositeData true when is necessary to appending current date to previous set
     * @return true when is not necessary to continue and affect a value : composite value has been processed
     */
    scan(pageInstance, currentField, rawData, appendCompositeData = false) {
        return super.scan(pageInstance, currentField, rawData, appendCompositeData);
    }
    /**
     * Load composite data from storage and erase them
     * @param dictionaryFieldSupported dictionary of page fields submitted
     * @returns true when some data has been loaded
     */
    static _getDictionaryFieldSupported(dictionaryFieldSupported) {
        return dictionaryFieldSupported ?? {};
    }
}
exports.ManagementServiceGs1 = ManagementServiceGs1;
//# sourceMappingURL=management-service-gs1.js.map