"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ManagementServiceComposite = void 0;
const typesLib = require("@sage/xtrem-decimal");
const barcode_management_service_1 = require("./barcode-management-service");
class ManagementServiceComposite extends barcode_management_service_1.BarcodeManagementService {
    /**
     * This Method build instance with retrieving all data
     * @param pageInstance : current page
     * @param dictionaryFieldSupported : page fields supported
     * @param dictionaryDataComposites : extracted composite data, may be send to storage
     * @param checkCompositeDataAllowed? : optional client callback to check composite data code before to dispatch them
     */
    // eslint-disable-next-line require-await
    async initialize(pageInstance, dictionaryFieldSupported = {}, dictionaryDataComposites = {}, checkCompositeDataAllowed) {
        return super.initialize(pageInstance, this._getDictionaryFieldSupported(dictionaryFieldSupported), dictionaryDataComposites, checkCompositeDataAllowed);
    }
    /**
     * Check if raw data is a composite data
     * @param rawData
     * @returns
     */
    isCompositeData(rawData) {
        // prefix to exclude GS1 composite data
        const groupSeparator = String.fromCharCode(0x1d); // GS1 Group Separator
        const compositeCodePrefix = new RegExp(`^(\\][A-Za-z]\\d{3,5}|${groupSeparator.replace(/[.*+?^${}()|[\]\\]/g, '\\$&')}\\d{2,4})`);
        return (rawData && typesLib.strictEq(typeof rawData, 'string') && typesLib.gte(rawData.length, typesLib.max(4, Number(this.barcodeManagementConfiguration?.recordSize))) &&
            !Number(rawData.match(compositeCodePrefix)?.length ?? 0));
    }
    /**
     * Called when field update is in progress
     * @param pageInstance current page
     * @param currentField reference of field to updating
     * @param rawData received raw data
     * @param appendCompositeData true when is necessary to appending current date to previous set
     * @return true when is not necessary to continue and affect a value : composite value has been processed
     */
    scan(pageInstance, currentField, rawData, appendCompositeData = false) {
        return super.scan(pageInstance, currentField, rawData, appendCompositeData);
    }
    /**
     * Update screen fields supported.
     * field mapping was done after
     * @param pageInstance current page
     * @param dictionaryFieldSupported dictionary of page fields submitted
     * @returns true when done, false when no any field to process with data
     */
    setScreenFieldSupported(pageInstance, dictionaryFieldSupported) {
        return super.setScreenFieldSupported(pageInstance, this._getDictionaryFieldSupported(dictionaryFieldSupported));
    }
    /**
     * Load composite data from storage and erase them
     * @param _dictionaryFieldSupported dictionary of page fields submitted
     * @returns true when some data has been loaded
     */
    _getDictionaryFieldSupported(_dictionaryFieldSupported) {
        return this.barcodeManagementConfiguration?.dictionaryFieldSupported ?? {};
    }
}
exports.ManagementServiceComposite = ManagementServiceComposite;
//# sourceMappingURL=management-service-composite.js.map