import type { GraphApi } from '@sage/wh-system-api';
import * as ui from '@sage/xtrem-ui';
import { BarcodeManagementService } from './barcode-management-service';
import { AsyncCompositeAllowed, BarcodeManagerSupportedFields, DictionaryDataGeneric, DictionaryGenericFieldSupported } from './screen-management';
export declare class ManagementServiceComposite extends BarcodeManagementService {
    /**
     * This Method build instance with retrieving all data
     * @param pageInstance : current page
     * @param dictionaryFieldSupported : page fields supported
     * @param dictionaryDataComposites : extracted composite data, may be send to storage
     * @param checkCompositeDataAllowed? : optional client callback to check composite data code before to dispatch them
     */
    initialize(pageInstance: ui.Page<GraphApi>, dictionaryFieldSupported?: DictionaryGenericFieldSupported, dictionaryDataComposites?: DictionaryDataGeneric, checkCompositeDataAllowed?: AsyncCompositeAllowed): Promise<boolean>;
    /**
     * Check if raw data is a composite data
     * @param rawData
     * @returns
     */
    isCompositeData(rawData: any): boolean;
    /**
     * Called when field update is in progress
     * @param pageInstance current page
     * @param currentField reference of field to updating
     * @param rawData received raw data
     * @param appendCompositeData true when is necessary to appending current date to previous set
     * @return true when is not necessary to continue and affect a value : composite value has been processed
     */
    scan(pageInstance: ui.Page<GraphApi>, currentField: BarcodeManagerSupportedFields, rawData: any, appendCompositeData?: boolean): Promise<boolean>;
    /**
     * Update screen fields supported.
     * field mapping was done after
     * @param pageInstance current page
     * @param dictionaryFieldSupported dictionary of page fields submitted
     * @returns true when done, false when no any field to process with data
     */
    setScreenFieldSupported(pageInstance: ui.Page<GraphApi>, dictionaryFieldSupported: DictionaryGenericFieldSupported): Promise<boolean>;
    /**
     * Load composite data from storage and erase them
     * @param _dictionaryFieldSupported dictionary of page fields submitted
     * @returns true when some data has been loaded
     */
    private _getDictionaryFieldSupported;
}
//# sourceMappingURL=management-service-composite.d.ts.map