"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.genericPrintReport = genericPrintReport;
const typesLib = require("@sage/xtrem-decimal");
const xtrem_shared_1 = require("@sage/xtrem-shared");
const ui = require("@sage/xtrem-ui");
const generic_print_payload_mapping_1 = require("./generic-print-payload-mapping");
async function genericPrintReport(pageInstance, reportName, language, destination, graphQlPayload) {
    let result;
    if (typesLib.strictEq((reportName || ''), '')) {
        throw new xtrem_shared_1.SystemError('Report name is mandatory');
    }
    if (typesLib.strictEq((destination || ''), '')) {
        throw new xtrem_shared_1.SystemError('Destination is mandatory');
    }
    // Custom parameters has object
    if (typesLib.eq(graphQlPayload, null) || typesLib.strictNe(typeof graphQlPayload, 'object') || typesLib.strictEq(Object.keys(graphQlPayload).length, 0)) {
        throw new xtrem_shared_1.SystemError('Custom parameters is mandatory');
    }
    ui.console.debug(`Custom payload in input : ${JSON.stringify(graphQlPayload)}`);
    const _customParameters = generic_print_payload_mapping_1.GenericPrintPayloadMapping.buildGraphQLPayload(graphQlPayload);
    ui.console.debug(`Prepared custom payload : ${JSON.stringify(_customParameters)}`);
    /**
     * Explanation of errorCode cases :
     *  n = Error code number.
     *  0 = Done.
     * -1 = Result of mutation not return expected errorCode message.
     * -2 = Failure without error when calling mutation (unchanged value).
     */
    // Populate required arguments
    const _mutationArgs = {
        reportName,
        language,
        destination,
        parametersNames: _customParameters.parametersNames,
        parametersValues: _customParameters.parametersValues,
        errorCode: -2,
    };
    ui.console.debug(`Prepared mutation arguments : ${JSON.stringify(_mutationArgs)}`);
    try {
        result =
            (await pageInstance.$.graph
                .node('@sage/wh-system/GenericPrintReport')
                .mutations.printReport({
                reportName: false,
                language: false,
                destination: false,
                parametersNames: false,
                parametersValues: false,
                errorCode: true,
            }, {
                parameters: _mutationArgs,
            })
                .execute())?.errorCode ?? -1;
    }
    catch (error) {
        throw new xtrem_shared_1.SystemError(error.message, error);
    }
    return result;
}
//# sourceMappingURL=generic-print-report.js.map