import type { GraphApi } from '@sage/wh-system-api';
import * as ui from '@sage/xtrem-ui';
import { BarcodeManagementConfiguration } from './barcode-configurator';
import { AsyncAndVoidFunction, AsyncCompositeAllowed, BarcodeManagerSupportedFields, DictionaryDataGeneric, DictionaryGenericFieldSupported } from './screen-management';
import { BarcodeManagementServiceInterface, TypeOfServiceBarcode } from './type-of-barcode-management';
export declare abstract class BarcodeManagementService implements BarcodeManagementServiceInterface {
    protected readonly _storageKey: string;
    private readonly _barcodeManagementConfiguration?;
    /**
     * Initialize permanent data for page and parser
     * @param _storageKey                       : storage key used for this page
     * @param _barcodeManagementConfiguration   : optional configuration
     */
    constructor(_storageKey: string, _barcodeManagementConfiguration?: BarcodeManagementConfiguration);
    /**
     * Request to abort dispatch without error (end of scan) :
     * This is used only when onChange() has performed some operations,
     * ie : switching page... except when initialization is in progress
     * @param {function}    optional callback to be executed approx. 100ms after end of dispatching.
     * @returns {boolean}   true when request has be set
     */
    abortDispatch(postActionAbortDispatch?: AsyncAndVoidFunction): boolean;
    /**
     * Get barcode management configuration
     *  @returns barcode management configuration
     */
    get barcodeManagementConfiguration(): BarcodeManagementConfiguration | undefined;
    /**
     * Remove all composite and storage data
     * @param pageInstance current page
     * @param storageKey optional, for overriding current service key (use with caution)
     */
    clearAllCompositeDataAndStorage(pageInstance: ui.Page<GraphApi>, storageKey?: string): void;
    /**
     * Remove composite data
     */
    clearCompositeData(): void;
    /**
     * Remove composite data from storage
     * @param pageInstance current page
     * @param storageKey optional, for overriding current service key (use with caution)
     */
    clearCompositeDataStorage(pageInstance: ui.Page<GraphApi>, storageKey?: string): void;
    get scannedFieldId(): string | undefined;
    /**
     * This Method build instance with retrieving all data
     * @param pageInstance : current page
     * @param dictionaryFieldSupported : page fields supported
     * @param dictionaryDataComposites : extracted composite data, may be send to storage
     * @param checkCompositeDataAllowed? : optional client callback to check composite data code before to dispatch them
     */
    initialize(pageInstance: ui.Page<GraphApi>, dictionaryFieldSupported?: DictionaryGenericFieldSupported, dictionaryDataComposites?: DictionaryDataGeneric, checkCompositeDataAllowed?: AsyncCompositeAllowed): Promise<boolean>;
    /**
     * Return if abort dispatch session is requested
     */
    get isAbortDispatchInProgress(): boolean;
    /**
     * Check if raw data is a composite data
     * TODO: MUST be override by child class
     * @param _rawData
     * @returns
     */
    isCompositeData(_rawData: any): boolean;
    /**
     * Return if dispatch session is in progress
     */
    get isDispatchInProgress(): boolean;
    /**
     *
     * @returns true when some composite data have been stored.
     */
    get isExistsDataComposite(): boolean;
    /**
     * Check if exists some fields mapped into service,
     * ready to dispatch
     */
    get isExistsFieldsMapped(): boolean;
    /**
     * Check if exists some fields loaded into service
     */
    get isExistsFieldsSupported(): boolean;
    /**
     * Return if initialization is in progress
     */
    get isInitializationInProgress(): boolean;
    /**
     * Load composite data from storage and then delete it there.
     * @returns true when some data has been loaded
     */
    loadCompositeData(pageInstance: ui.Page<GraphApi>): boolean;
    /**
     * Save composite data, zero elements allowed
     * @param pageInstance current page
     * @returns true when operation has performed
     */
    saveCompositeData(pageInstance: ui.Page<GraphApi>): boolean;
    /**
     * Called when field update is in progress
     * @param pageInstance current page
     * @param currentField reference of field to updating
     * @param rawData received raw data
     * @param appendCompositeData true when is necessary to appending current date to previous set
     * @return true when is not necessary to continue and affect a value : composite value has been processed
     */
    scan(pageInstance: ui.Page<GraphApi>, currentField: BarcodeManagerSupportedFields, rawData: any, appendCompositeData?: boolean): Promise<boolean>;
    /**
     * Update screen fields supported.
     * field mapping was done after
     * @param pageInstance current page
     * @param dictionaryFieldSupported dictionary of page fields submitted
     * @returns true when done, false when no any field to process with data
     */
    setScreenFieldSupported(pageInstance: ui.Page<GraphApi>, dictionaryFieldSupported: DictionaryGenericFieldSupported): Promise<boolean>;
    /**
     *  Return type of service barcode
     *  @returns type of service barcode
     */
    get typeOfServiceBarcode(): TypeOfServiceBarcode;
    /**
     * Remove fields definition
     * @param removeCompositeData  : optionally remove composite data too
     */
    clearScreenFields(removeCompositeData?: boolean): void;
}
//# sourceMappingURL=barcode-management-service.d.ts.map