"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BarcodeManagementServiceFactory = void 0;
const barcode_configurator_1 = require("./barcode-configurator");
const management_service_composite_1 = require("./management-service-composite");
const management_service_gs1_1 = require("./management-service-gs1");
class BarcodeManagementServiceFactory {
    // eslint-disable-next-line class-methods-use-this
    async createService(pageInstance, serviceKey, codeFlow) {
        // If the flow code is not provided or the configuration was not found, the default service gs1 is applied
        if (codeFlow) {
            const _barcodeConfigurator = new barcode_configurator_1.BarcodeConfigurator();
            if (await _barcodeConfigurator.initConfigurator(pageInstance, codeFlow)) {
                return new management_service_composite_1.ManagementServiceComposite(serviceKey, _barcodeConfigurator.barcodeManagementConfiguration);
            }
        }
        return new management_service_gs1_1.ManagementServiceGs1(serviceKey);
    }
}
exports.BarcodeManagementServiceFactory = BarcodeManagementServiceFactory;
//# sourceMappingURL=barcode-management-service-factory.js.map