import type { GraphApi } from '@sage/wh-system-api';
import * as ui from '@sage/xtrem-ui';
import { CompositeDateFormat, CompositeFormat, ParserConfiguration } from '../shared-functions/barcode-parser-configuration';
import { DataTypeSupported } from '../shared-functions/parsed-generic-element';
import { DictionaryGenericFieldSupported } from './screen-management';
import { TypeOfServiceBarcode } from './type-of-barcode-management';
export interface BarcodeConfigurationLine {
    fieldKey: string;
    fieldName: string;
    fieldAlias?: string;
    description?: string;
    startPosition: number;
    length: number;
    fieldDataType: DataTypeSupported;
}
export interface BarcodeConfiguration {
    typeOfServiceBarcode: TypeOfServiceBarcode;
    compositeCode: string;
    localizedDescription: string;
    isActive: boolean;
    isBlankDeletion: boolean;
    compositeFormat: CompositeFormat;
    dateFormat: CompositeDateFormat;
    dateLabel: string;
    fieldSeparator: string;
    decimalSeparator: string;
    lines: BarcodeConfigurationLine[];
}
export interface BarcodeManagementConfiguration {
    typeOfServiceBarcode: TypeOfServiceBarcode;
    recordSize: number;
    numberOfAlias: number;
    parserConfiguration: ParserConfiguration;
    dictionaryFieldSupported: DictionaryGenericFieldSupported;
}
export declare class BarcodeConfigurator {
    private _barcodeConfiguration?;
    private _parserConfiguration?;
    private _barcodeManagementConfiguration?;
    constructor();
    /**
     *  Initialize the barcode configuration
     *
     * Configurations are returned only if they are all defined:
     * - Barcode configuration must be read and have lines.
     * - Parser configuration must be able to be generated.
     * - Field configuration is only generated if all provided fields were found on the screen.
     * @param pageInstance
     * @param codeFlow
     * @returns instance of barcode configuration or undefined
     */
    initConfigurator(pageInstance: ui.Page<GraphApi>, codeFlow: string): Promise<BarcodeConfiguration | undefined>;
    /**
     *  Compute the parser configuration :
     *  No configuration is returned if no rows could be retrieved.
     * @param _barcodeConfiguration
     *  @returns parser configuration or undefined
     */
    private static _computeParserConfiguration;
    /**
     *  Compute the screen management configuration
     * @param _barcodeConfiguration
     */
    private _computeManagementConfiguration;
    /**
     * Get the barcode configuration
     * @returns current instance of barcode configuration or undefined
     */
    get barcodeConfiguration(): BarcodeConfiguration | undefined;
    /**
     * Get the barcode management configuration
     * @returns current instance of barcode management configuration or undefined
     */
    get barcodeManagementConfiguration(): BarcodeManagementConfiguration | undefined;
    /**
     * Get the dictionary field supported
     * @returns current instance of dictionary field supported or undefined
     */
    get dictionaryFieldSupported(): DictionaryGenericFieldSupported | undefined;
    /**
     * Get the parser configuration
     * @returns current instance of parser configuration or undefined
     */
    get parserConfiguration(): ParserConfiguration | undefined;
    /**
     * Get the type of service barcode
     * @returns current instance of type of service barcode or undefined
     */
    get typeOfServiceBarcode(): TypeOfServiceBarcode | undefined;
    /**
     *  Get the barcode configuration for the given code flow for fabricator
     * @param pageInstance
     *  @param codeFlow
     *  @returns
     */
    private _getBarcodeConfiguration;
    /**
     *  Get the composite format for the given composite code type
     *  @param compositeCodeType
     *  @returns composite format type key
     */
    private _getCompositeFormat;
    /**
     * Get the current stock site
     *  @param pageInstance Current page instance
     *  @returns the current stock site
     */
    private _getCurrentStockSite;
    /**
     *  Get the date format for the given date format
     * @param dateFormat
     * @returns date format type key
     */
    private _getCompositeDateFormat;
    /**
     *  Get the data type for the given field data type
     * @param fieldDataType
     * @returns
     */
    private _getSupportedDataType;
    /**
     *  Get the data type for the given field data type
     * @param fieldDataType
     * @returns data type key or undefined if type is not supported (not possible to check immediately)
     */
    private _getSupportedFieldDateType;
    /**
     *  Get the barcode configuration for the given code flow
     * @param pageInstance
     * @param codeFlow
     * @returns
     */
    private _getBarcodeSetup;
}
//# sourceMappingURL=barcode-configurator.d.ts.map