import * as ui from '@sage/xtrem-ui';
export type PageButtonActions = Array<ui.PageAction>;
export type PageButtonActionsOrSeparators = Array<ui.PageAction | ReturnType<typeof ui.menuSeparator>>;
/**
 * Run the standard cancel action and close the page if it is opened in the sidebar
 * @param pageInstance the page where save is triggered
 */
export declare function cancelAndClosePanel<PageInstance extends ui.Page>(pageInstance: PageInstance): Promise<void>;
/**
 * Run the standard save action and close the page if it is opened in the sidebar
 * @param pageInstance the page where save is triggered
 */
export declare function saveAndClosePanel<PageInstance extends ui.Page>(pageInstance: PageInstance): Promise<void>;
export interface AppPageCrudActionArgs {
    page: ui.Page;
    isDirty?: boolean;
    isNewRecord?: boolean;
    create?: Array<ui.PageAction> | ui.PageAction;
    cancel?: Array<ui.PageAction> | ui.PageAction;
    remove?: Array<ui.PageAction> | ui.PageAction;
    duplicate?: Array<ui.PageAction> | ui.PageAction;
    save?: Array<ui.PageAction> | ui.PageAction;
    actions?: Array<ui.PageAction>;
}
/**
 * Manage activation of CRUD buttons
 * If the page is opened in the sidebar, the buttons Save and New are hidden
 * @param page: the page to manage
 * @param values: default value = page.$.values
 * @param isDirty: default value = page.$.isDirty,
 * @param cb: callback
 */
export declare function setApplicativePageCrudActions({ page, isDirty, isNewRecord, cancel, remove, duplicate, save, actions, }: AppPageCrudActionArgs): void;
export interface DisplayOfCommonPageActions {
    page: ui.Page;
    isDirty?: boolean;
    cancel?: PageButtonActions | ui.PageAction;
    remove?: PageButtonActions | ui.PageAction;
    duplicate?: PageButtonActions | ui.PageAction;
    save?: PageButtonActions | ui.PageAction;
    businessActions?: PageButtonActions | ui.PageAction;
}
/**
 * Manage default display of most page common actions
 * @param page:  page
 * @param isDirty: dirty state
 * @param cancel: the cancel action
 * @param remove: the remove action
 * @param duplicate: the duplicate action
 * @param save: the save action
 * @param businessActions: all other business actions
 */
export declare function setDisplayOfCommonPageActions({ page, isDirty, cancel, remove, duplicate, save, businessActions, }: DisplayOfCommonPageActions): void;
/**
 * Manage order of business action buttons
 * @param cancel: the cancel action
 * @param save: the save action
 * @param businessActions: all other business actions
 */
export declare function setOrderOfPageBusinessActions({ cancel, save, businessActions, }: {
    cancel: PageButtonActions | ui.PageAction;
    save: PageButtonActions | ui.PageAction;
    businessActions: PageButtonActions | ui.PageAction;
}): PageButtonActions;
/**
 * Manage order of header quick action buttons
 * @param duplicate: the duplicate action
 * @param quickActions: all other quick actions
 */
export declare function setOrderOfPageHeaderQuickActions({ duplicate, quickActions, }: {
    duplicate?: PageButtonActions | ui.PageAction;
    quickActions?: PageButtonActions | ui.PageAction;
}): PageButtonActions;
/**
 * Manage order of header dropdown action buttons
 * @param remove: the delete action
 * @param dropDownBusinessActions: all other dropdown actions and separators
 */
export declare function setOrderOfPageHeaderDropDownActions({ remove, dropDownBusinessActions, }: {
    remove?: PageButtonActions | ui.PageAction;
    dropDownBusinessActions?: PageButtonActionsOrSeparators | ui.PageAction;
}): PageButtonActionsOrSeparators;
/**
 * Manage order of table action buttons
 * @param actions: all table actions
 */
export declare function setOrderOfPageTableFieldActions({ actions, }: {
    actions: PageButtonActions | ui.PageAction;
}): PageButtonActions;
/**
 * Manage order of table header business action buttons
 * @param actions: all table actions
 */
export declare function setOrderOfPageTableHeaderBusinessActions({ actions, }: {
    actions: PageButtonActions | ui.PageAction;
}): PageButtonActions;
//# sourceMappingURL=applicative-crud-actions.d.ts.map