declare module '@sage/wh-system-api-partial' {
    import type { Package as SageXtremAppMetadata$Package } from '@sage/xtrem-app-metadata-api';
    import type { Package as SageXtremX3SystemUtils$Package, SysUser } from '@sage/xtrem-x3-system-utils-api';
    import type {
        AggregateQueryOperation,
        AggregateReadOperation,
        BinaryStream,
        ClientCollection,
        ClientNode,
        ClientNodeInput,
        GetDefaultsOperation,
        Operation as Node$Operation,
        QueryOperation,
        ReadOperation,
        VitalClientNode,
        VitalClientNodeInput,
        decimal,
        integer,
    } from '@sage/xtrem-client';
    export interface AbbreviationsOfTheWeekdays$Enum {
        mo: 1;
        tu: 2;
        we: 3;
        th: 4;
        fr: 5;
        sa: 6;
        su: 7;
    }
    export type AbbreviationsOfTheWeekdays = keyof AbbreviationsOfTheWeekdays$Enum;
    export interface ActionDeactivation$Enum {
        none: 1;
        standard: 2;
        vertical: 3;
        all: 4;
    }
    export type ActionDeactivation = keyof ActionDeactivation$Enum;
    export interface ActionFieldType$Enum {
        initButton: 1;
        beforeField: 2;
        initialization: 3;
        beforeEntry: 4;
        control: 5;
        afterField: 6;
        afterChange: 7;
        selection: 8;
        button1: 9;
        button2: 10;
        button3: 11;
        button4: 12;
        beforeLine: 13;
        afterLine: 14;
        button5: 15;
        button6: 16;
        button7: 17;
        button8: 18;
        button9: 19;
        button10: 20;
        button11: 21;
        button12: 22;
        button13: 23;
        button14: 24;
        button15: 25;
        button16: 26;
        button17: 27;
        button18: 28;
        button19: 29;
        button20: 30;
        click: 31;
    }
    export type ActionFieldType = keyof ActionFieldType$Enum;
    export interface ActionFlowManagement$Enum {
        webSiteField: 1;
        customization: 2;
        xslProcessor: 3;
    }
    export type ActionFlowManagement = keyof ActionFlowManagement$Enum;
    export interface ActionModels$Enum {
        objectManagement: 1;
        inquiry: 2;
        standardProcessing: 3;
        windowEntry: 4;
        listSelection: 5;
        tableSelection: 6;
        miscellaneousDisplay: 7;
        outsideModel: 8;
    }
    export type ActionModels = keyof ActionModels$Enum;
    export interface ActionType7860$Enum {
        miscellaneous: 1;
        control: 2;
        entry: 3;
        selection: 4;
        update: 5;
        informationSearch: 6;
        calculation: 7;
    }
    export type ActionType7860 = keyof ActionType7860$Enum;
    export interface ActionType7936$Enum {
        standard: 1;
        login: 2;
        logout: 3;
    }
    export type ActionType7936 = keyof ActionType7936$Enum;
    export interface ActionType7960$Enum {
        record: 1;
        list: 2;
        subprogram: 3;
        dialogBox: 4;
    }
    export type ActionType7960 = keyof ActionType7960$Enum;
    export interface ActualForecast$Enum {
        actual: 1;
        forecast: 2;
    }
    export type ActualForecast = keyof ActualForecast$Enum;
    export interface AddressType$Enum {
        absolute: 1;
        relativeSolutionPublication: 2;
        relativeFolder: 3;
    }
    export type AddressType = keyof AddressType$Enum;
    export interface AggregationLevel$Enum {
        day: 1;
        week: 2;
        substituteValue3: 3;
        halfMonth: 4;
        month: 5;
        quarter: 6;
        halfYear: 7;
        year: 8;
    }
    export type AggregationLevel = keyof AggregationLevel$Enum;
    export interface AmountConversionIntoLetters$Enum {
        noConversion: 1;
        french: 2;
        english: 3;
        german: 4;
        italian: 5;
        spanish: 6;
        portugese: 7;
        turkish: 8;
    }
    export type AmountConversionIntoLetters = keyof AmountConversionIntoLetters$Enum;
    export interface AndOr$Enum {
        and: 1;
        or: 2;
    }
    export type AndOr = keyof AndOr$Enum;
    export interface ApiLoadingType$Enum {
        application: 1;
        shared: 2;
    }
    export type ApiLoadingType = keyof ApiLoadingType$Enum;
    export interface ApiPackageType$Enum {
        main: 1;
        linked: 2;
    }
    export type ApiPackageType = keyof ApiPackageType$Enum;
    export interface AppointmentType7862$Enum {
        pending: 1;
        underProgress: 2;
        ended: 3;
        canceled: 4;
        error: 5;
    }
    export type AppointmentType7862 = keyof AppointmentType7862$Enum;
    export interface ApprovalRequest$Enum {
        no: 1;
        yes: 2;
        withSignature: 3;
    }
    export type ApprovalRequest = keyof ApprovalRequest$Enum;
    export interface ArchiveManagement$Enum {
        archiveDesign: 1;
        restoreDesign: 2;
        deleteArchive: 3;
    }
    export type ArchiveManagement = keyof ArchiveManagement$Enum;
    export interface ArchivingEventType$Enum {
        object: 1;
        report: 2;
        export: 3;
        log: 4;
        excel: 5;
        manual: 6;
    }
    export type ArchivingEventType = keyof ArchivingEventType$Enum;
    export interface ArgumentType$Enum {
        address: 1;
        value: 2;
        constant: 3;
    }
    export type ArgumentType = keyof ArgumentType$Enum;
    export interface AttachmentType$Enum {
        file: 1;
        imageFileInDatabase: 2;
        textFileInDatabase: 3;
    }
    export type AttachmentType = keyof AttachmentType$Enum;
    export interface AuthenticationMode$Enum {
        enterprise: 1;
        ldap: 2;
        windowsAd: 3;
        windowsNt: 4;
    }
    export type AuthenticationMode = keyof AuthenticationMode$Enum;
    export interface AuthorizationsBetweenFolders$Enum {
        none: 1;
        read: 2;
        all: 3;
    }
    export type AuthorizationsBetweenFolders = keyof AuthorizationsBetweenFolders$Enum;
    export interface BaseType57$Enum {
        oracle: 1;
        sqlServer: 2;
        reserved3: 3;
        reserved: 4;
        postgreSql: 5;
    }
    export type BaseType57 = keyof BaseType57$Enum;
    export interface BaseType$Enum {
        cIsam: 1;
        oracle: 2;
        folder: 3;
        sqlServer: 4;
        db2: 5;
        postgreSql: 6;
    }
    export type BaseType = keyof BaseType$Enum;
    export interface BatchFrequency$Enum {
        weekly: 1;
        monthly: 2;
    }
    export type BatchFrequency = keyof BatchFrequency$Enum;
    export interface BatchTaskType$Enum {
        processing: 1;
        script: 2;
    }
    export type BatchTaskType = keyof BatchTaskType$Enum;
    export interface Behaviors$Enum {
        creation: 1;
        update: 2;
        deletion: 3;
        pdfPrinting: 4;
        excelReporting: 5;
        wordReporting: 6;
        wordMailMerge: 7;
        quickEdit: 8;
    }
    export type Behaviors = keyof Behaviors$Enum;
    export interface BlockType7914$Enum {
        singleRecord: 1;
        multiRecord: 2;
    }
    export type BlockType7914 = keyof BlockType7914$Enum;
    export interface BlockType$Enum {
        table: 1;
        list: 2;
        photo: 3;
        text: 4;
        hidden: 5;
        flash: 6;
        office: 7;
        browser: 8;
        htmlEditor: 9;
        technique: 10;
        businessIntelligence: 11;
    }
    export type BlockType = keyof BlockType$Enum;
    export interface BoPromptType$Enum {
        simple: 1;
        multiple: 2;
    }
    export type BoPromptType = keyof BoPromptType$Enum;
    export interface Brackets7932$Enum {
        substituteValue1: 1;
        substituteValue2: 2;
        substituteValue3: 3;
        substituteValue4: 4;
        substituteValue5: 5;
    }
    export type Brackets7932 = keyof Brackets7932$Enum;
    export interface Brackets$Enum {
        substituteValue1: 1;
        substituteValue2: 2;
        substituteValue3: 3;
        substituteValue4: 4;
        substituteValue5: 5;
    }
    export type Brackets = keyof Brackets$Enum;
    export interface ButtonType$Enum {
        button: 1;
        menu: 2;
        line: 3;
    }
    export type ButtonType = keyof ButtonType$Enum;
    export interface CancellationCode$Enum {
        block: 1;
        delete: 2;
        rtz: 3;
        other: 4;
    }
    export type CancellationCode = keyof CancellationCode$Enum;
    export interface CharacterCoding$Enum {
        ascii: 1;
        utf8: 2;
        ucs2: 3;
    }
    export type CharacterCoding = keyof CharacterCoding$Enum;
    export interface CharacterFormat$Enum {
        iso8859: 1;
        ibmPc: 2;
        substituteValue3: 3;
        substituteValue4: 4;
        macIntosh: 5;
        hpRoman8: 6;
    }
    export type CharacterFormat = keyof CharacterFormat$Enum;
    export interface ChoiceOfExecutionsAfter$Enum {
        atTheEndOfAllThePreviousSequences: 1;
        atTheEndOfThePreviousSequence: 2;
        atTheEndOfTheTask: 3;
        atTheEndOfTheGroup: 4;
    }
    export type ChoiceOfExecutionsAfter = keyof ChoiceOfExecutionsAfter$Enum;
    export interface ClassType$Enum {
        basic: 1;
        persistent: 2;
        technical: 3;
        system: 4;
        interface: 5;
    }
    export type ClassType = keyof ClassType$Enum;
    export interface CodeTypes$Enum {
        reports: 1;
        reportParameters: 2;
    }
    export type CodeTypes = keyof CodeTypes$Enum;
    export interface CodingMode$Enum {
        decimal: 1;
        octal: 2;
        hexadecimal: 3;
    }
    export type CodingMode = keyof CodingMode$Enum;
    export interface CodingOfTheBase$Enum {
        ascii: 1;
        unicode: 2;
    }
    export type CodingOfTheBase = keyof CodingOfTheBase$Enum;
    export interface CollectionType$Enum {
        instances: 1;
        variables: 2;
    }
    export type CollectionType = keyof CollectionType$Enum;
    export interface ColorAlternative$Enum {
        none: 1;
        every2Lines: 2;
        every3Lines: 3;
    }
    export type ColorAlternative = keyof ColorAlternative$Enum;
    export interface ConditionedBlockAction$Enum {
        hideBlock: 1;
        dispalyBlock: 2;
    }
    export type ConditionedBlockAction = keyof ConditionedBlockAction$Enum;
    export interface ConditionedBlockCriteria$Enum {
        formula: 1;
        emptyBlock: 2;
        pagingOfABlock: 3;
        lastDynamicLinkUsed: 4;
        previousPage: 5;
        userLoggedIn: 6;
        profile: 7;
        emptyGadget: 8;
        selectedLine: 9;
        currentPage: 10;
    }
    export type ConditionedBlockCriteria = keyof ConditionedBlockCriteria$Enum;
    export interface ConditionedBlockPageCrit$Enum {
        firstPage: 1;
        lastPage: 2;
        otherPages: 3;
    }
    export type ConditionedBlockPageCrit = keyof ConditionedBlockPageCrit$Enum;
    export interface ConnectionFailureReason$Enum {
        incorrectUser: 1;
        tooManySessions: 2;
        numberOfAttemptsExceeded: 3;
        incorrectPassword: 4;
        noStartMenu: 5;
        tooManyUsers: 6;
        singleModeFolder: 7;
        menuDoesNotExist: 8;
        refusalByEntryPoint: 9;
        incorrectLanguage: 10;
        programError: 11;
        passwordChangeRefusal: 12;
    }
    export type ConnectionFailureReason = keyof ConnectionFailureReason$Enum;
    export interface ContactType$Enum {
        standard: 1;
        lead: 2;
    }
    export type ContactType = keyof ContactType$Enum;
    export interface ContainmentType$Enum {
        none: 1;
        partial: 2;
        fullElasticPool: 3;
    }
    export type ContainmentType = keyof ContainmentType$Enum;
    export interface ControlType$Enum {
        mandatoryValues: 1;
        prohibitedValues: 2;
        rangeOfValues: 3;
        tableReference: 4;
        expression: 5;
        other: 6;
    }
    export type ControlType = keyof ControlType$Enum;
    export interface ConversionSense$Enum {
        asciiUtf8: 1;
        asciiUcs2: 2;
        utf8Ascii: 3;
        utf8Ucs2: 4;
        ucs2Ascii: 5;
        ucs2Utf8: 6;
    }
    export type ConversionSense = keyof ConversionSense$Enum;
    export interface CopyOption$Enum {
        usersAndProfiles: 1;
        miscellaneousTables: 2;
        sequenceNumbers: 3;
        parameters: 4;
        controlTables: 5;
        sitesDepositors: 6;
        statistics: 7;
        importExport: 8;
        geodeParameters: 9;
        geodeDataBases: 10;
    }
    export type CopyOption = keyof CopyOption$Enum;
    export interface CopyOptions$Enum {
        creationOrUpdate: 1;
        cancelsAndReplaces: 2;
    }
    export type CopyOptions = keyof CopyOptions$Enum;
    export interface CopyType7816$Enum {
        automaticCopy: 1;
        conditionalCopy: 2;
    }
    export type CopyType7816 = keyof CopyType7816$Enum;
    export interface CopyType7950$Enum {
        copy: 1;
        patch: 2;
    }
    export type CopyType7950 = keyof CopyType7950$Enum;
    export interface CopyType$Enum {
        noCopy: 1;
        automaticCopy: 2;
        conditionalCopy: 3;
    }
    export type CopyType = keyof CopyType$Enum;
    export interface CreationAssistance$Enum {
        none: 1;
        all: 2;
        one: 3;
    }
    export type CreationAssistance = keyof CreationAssistance$Enum;
    export interface CustomizationVersion$Enum {
        version1: 1;
        version2: 2;
        version3: 3;
    }
    export type CustomizationVersion = keyof CustomizationVersion$Enum;
    export interface DashboardFramework$Enum {
        substituteValue1: 1;
        substituteValue2: 2;
        substituteValue3: 3;
        substituteValue4: 4;
        substituteValue5: 5;
        substituteValue6: 6;
        substituteValue7: 7;
        substituteValue8: 8;
    }
    export type DashboardFramework = keyof DashboardFramework$Enum;
    export interface DashboardParameterType$Enum {
        dataSource: 1;
        visualComponent: 2;
    }
    export type DashboardParameterType = keyof DashboardParameterType$Enum;
    export interface DashboardTypeToRecover$Enum {
        professionCode: 1;
        user: 2;
    }
    export type DashboardTypeToRecover = keyof DashboardTypeToRecover$Enum;
    export interface DataFileType$Enum {
        ascii1: 1;
        ascii2: 2;
        delimited: 3;
        fixedLength: 4;
        xml: 5;
        flat: 6;
        withHeader: 7;
        jsonApi: 8;
    }
    export type DataFileType = keyof DataFileType$Enum;
    export interface DataFilter$Enum {
        filtered: 1;
        none: 2;
    }
    export type DataFilter = keyof DataFilter$Enum;
    export interface DataType$Enum {
        date: 1;
        char: 2;
        integer: 3;
        decimal: 4;
        textFile: 5;
        imageFile: 6;
    }
    export type DataType = keyof DataType$Enum;
    export interface DataTypes7947$Enum {
        reference: 1;
        eMail: 2;
        phone: 3;
    }
    export type DataTypes7947 = keyof DataTypes7947$Enum;
    export interface DataTypes9028$Enum {
        descriptions: 1;
        shortInteger: 2;
        longInteger: 3;
        decimalDcb: 4;
        floatingNumber: 5;
        doublePrecision: 6;
        alphanumeric: 7;
        date: 8;
    }
    export type DataTypes9028 = keyof DataTypes9028$Enum;
    export interface DataTypes$Enum {
        localMenu: 1;
        shortInteger: 2;
        longInteger: 3;
        decimal: 4;
        floating: 5;
        double: 6;
        alphanumeric: 7;
        date: 8;
        imageFile: 9;
        textFile: 10;
        uuid: 11;
        datetime: 12;
    }
    export type DataTypes = keyof DataTypes$Enum;
    export interface DatabaseStatus$Enum {
        normal: 1;
        extensionDictionary: 2;
        dictionary: 3;
        aESystem: 4;
        other: 5;
    }
    export type DatabaseStatus = keyof DatabaseStatus$Enum;
    export interface DatesForStatusGenerator$Enum {
        dzMmDdYy: 1;
        dzMmDdYyyy: 2;
        dzMmmDdYyyy: 3;
        dZMmmmmmmmmDdYyyy: 4;
        dzMmDd: 5;
        dzMmYy: 6;
        dzMmYyyy: 7;
    }
    export type DatesForStatusGenerator = keyof DatesForStatusGenerator$Enum;
    export interface DaysOfTheWeek$Enum {
        monday: 1;
        tuesday: 2;
        wednesday: 3;
        thursday: 4;
        friday: 5;
        saturday: 6;
        sunday: 7;
    }
    export type DaysOfTheWeek = keyof DaysOfTheWeek$Enum;
    export interface DefaultDisplay$Enum {
        table: 1;
        graph: 2;
    }
    export type DefaultDisplay = keyof DefaultDisplay$Enum;
    export interface DefaultGraph$Enum {
        bars: 1;
        lines: 2;
        areas: 3;
        sectors: 4;
    }
    export type DefaultGraph = keyof DefaultGraph$Enum;
    export interface DefinitionLevel7809$Enum {
        company: 1;
        site: 2;
        user: 3;
        legislation: 4;
    }
    export type DefinitionLevel7809 = keyof DefinitionLevel7809$Enum;
    export interface DefinitionLevel$Enum {
        folder: 1;
        company: 2;
        site: 3;
    }
    export type DefinitionLevel = keyof DefinitionLevel$Enum;
    export interface DelegateOptions$Enum {
        no: 1;
        all: 2;
        cascade: 3;
        firstAvailable: 4;
    }
    export type DelegateOptions = keyof DelegateOptions$Enum;
    export interface DelegationType$Enum {
        copyForInformation: 1;
        withAuthority: 2;
        exceptional: 3;
    }
    export type DelegationType = keyof DelegationType$Enum;
    export interface DeletionType$Enum {
        function: 1;
        functionProfile: 2;
        module: 3;
    }
    export type DeletionType = keyof DeletionType$Enum;
    export interface DeliveryType$Enum {
        notDelivered: 1;
        deliveredEmpty: 2;
        deliveredWithIndusData: 3;
        commonData: 4;
        dataByCountry: 5;
    }
    export type DeliveryType = keyof DeliveryType$Enum;
    export interface Density$Enum {
        high: 1;
        low: 2;
    }
    export type Density = keyof Density$Enum;
    export interface DestinationLevel$Enum {
        range: 1;
        template: 2;
        list: 3;
    }
    export type DestinationLevel = keyof DestinationLevel$Enum;
    export interface DestinationTypes$Enum {
        preview: 1;
        printer: 2;
        message: 3;
        file: 4;
        printerFile: 5;
        zplPrinter: 6;
        archiving: 7;
    }
    export type DestinationTypes = keyof DestinationTypes$Enum;
    export interface DevelopmentLevel$Enum {
        standard: 1;
        addOn: 2;
        vertical: 3;
        specific: 4;
    }
    export type DevelopmentLevel = keyof DevelopmentLevel$Enum;
    export interface DimensionType$Enum {
        date: 1;
        localMenu: 2;
        miscellaneousTable: 3;
        others: 4;
    }
    export type DimensionType = keyof DimensionType$Enum;
    export interface DirectoryLocation$Enum {
        x3Server: 1;
        webX3Server: 2;
    }
    export type DirectoryLocation = keyof DirectoryLocation$Enum;
    export interface DisketteType$Enum {
        substituteValue1: 1;
        substituteValue2: 2;
    }
    export type DisketteType = keyof DisketteType$Enum;
    export interface DisplayOptionsWoRec$Enum {
        doNotDisplayAnything: 1;
        htmlCodeWithoutToken: 2;
        htmlCodeWithToken: 3;
    }
    export type DisplayOptionsWoRec = keyof DisplayOptionsWoRec$Enum;
    export interface DocumentGeneration$Enum {
        no: 1;
        all: 2;
        existingDocumentations: 3;
    }
    export type DocumentGeneration = keyof DocumentGeneration$Enum;
    export interface DocumentationContents$Enum {
        implementation: 1;
        functional: 2;
        setup: 3;
        development: 4;
        data: 5;
        userGuides: 6;
    }
    export type DocumentationContents = keyof DocumentationContents$Enum;
    export interface DocumentationDeletion$Enum {
        allParagraphs: 1;
        onlyOneParagraphAllExistingLanguages: 2;
    }
    export type DocumentationDeletion = keyof DocumentationDeletion$Enum;
    export interface DocumentationExtraction$Enum {
        extractionByLanguage: 1;
        extractionForTranslation: 2;
        extractionForReTranslation: 3;
    }
    export type DocumentationExtraction = keyof DocumentationExtraction$Enum;
    export interface DocumentationHtmlEditor$Enum {
        insertLine: 1;
        deleteLine: 2;
        insertColumn: 3;
        deleteColumn: 4;
        addColumn: 5;
        paragraph: 6;
        title4: 7;
        title5: 8;
        bold: 9;
        italic: 10;
        underline: 11;
        leftAlignment: 12;
        center: 13;
        rightAlignment: 14;
        list: 15;
        rightShift: 16;
        leftShift: 17;
        createModifyAnHttpLink: 18;
        insertAnImage: 19;
        createAButton: 20;
        createModifyATable: 21;
        deleteUnauthorizedTags: 22;
        viewModifyTheHtmlSource: 23;
        colorTheSelectedText: 24;
        defaultColor: 25;
        changeTheFontOfTheSelectedText: 26;
        normal: 27;
        sourceCode: 28;
    }
    export type DocumentationHtmlEditor = keyof DocumentationHtmlEditor$Enum;
    export interface DocumentationParagraphs$Enum {
        allParagraphs: 1;
        onlyOneParagraph: 2;
    }
    export type DocumentationParagraphs = keyof DocumentationParagraphs$Enum;
    export interface Download$Enum {
        notDownloaded: 1;
        allClients: 2;
        webServices: 3;
    }
    export type Download = keyof Download$Enum;
    export interface DynamicCrossTables$Enum {
        none: 1;
        page: 2;
        line: 3;
        column: 4;
        value: 5;
    }
    export type DynamicCrossTables = keyof DynamicCrossTables$Enum;
    export interface EmailAddressType$Enum {
        email: 1;
        otherEmail2: 2;
        otherEmail3: 3;
        otherEmail4: 4;
        otherEmail5: 5;
    }
    export type EmailAddressType = keyof EmailAddressType$Enum;
    export interface EmailTransmission$Enum {
        no: 1;
        yes: 2;
        copy: 3;
    }
    export type EmailTransmission = keyof EmailTransmission$Enum;
    export interface EmailType$Enum {
        client: 1;
        server: 2;
    }
    export type EmailType = keyof EmailType$Enum;
    export interface EntityType7913$Enum {
        action: 1;
        session: 2;
        dataAccess: 3;
    }
    export type EntityType7913 = keyof EntityType7913$Enum;
    export interface EntryMethod$Enum {
        enter: 1;
        display: 2;
        hidden: 3;
        technical: 4;
    }
    export type EntryMethod = keyof EntryMethod$Enum;
    export interface EntryMode$Enum {
        entered: 1;
        displayed: 2;
        hidden: 3;
    }
    export type EntryMode = keyof EntryMode$Enum;
    export interface EntryPointEnvironment$Enum {
        entryPoint: 1;
        object: 2;
    }
    export type EntryPointEnvironment = keyof EntryPointEnvironment$Enum;
    export interface ErrorType7878$Enum {
        info: 1;
        warning: 2;
        error: 3;
        fatalError4: 4;
        fatalError: 5;
    }
    export type ErrorType7878 = keyof ErrorType7878$Enum;
    export interface ErrorType$Enum {
        textDoesNotExist: 1;
        textWithoutItsTranslation: 2;
        duplicates: 3;
        translatedText: 4;
    }
    export type ErrorType = keyof ErrorType$Enum;
    export interface EventType7814$Enum {
        object: 1;
        functionEntry: 2;
        report: 3;
        taskEnd: 4;
    }
    export type EventType7814 = keyof EventType7814$Enum;
    export interface EventType7887$Enum {
        computeValue: 1;
        getValue: 2;
    }
    export type EventType7887 = keyof EventType7887$Enum;
    export interface EventType$Enum {
        miscellaneous: 1;
        object: 2;
        functionStart: 3;
        report: 4;
        endOfTask: 5;
        taskCancellation: 6;
        timeManagement: 7;
        importExport: 8;
        signature: 9;
        manual: 10;
    }
    export type EventType = keyof EventType$Enum;
    export interface Events$Enum {
        connection: 1;
        function: 2;
        others: 3;
    }
    export type Events = keyof Events$Enum;
    export interface ExcelExport$Enum {
        saveOnTheClientWorkstation: 1;
        exportInCsvFormat: 2;
        exportToExcel: 3;
    }
    export type ExcelExport = keyof ExcelExport$Enum;
    export interface ExcelReports$Enum {
        report1: 1;
        report2: 2;
        report3: 3;
        report4: 4;
        report5: 5;
        report6: 6;
        report7: 7;
        report8: 8;
        report9: 9;
        report10: 10;
        table1: 11;
        table2: 12;
        table3: 13;
        table4: 14;
        table515: 15;
        table516: 16;
        table5: 17;
        table8: 18;
        table9: 19;
        table10: 20;
        standard: 21;
        none: 22;
    }
    export type ExcelReports = keyof ExcelReports$Enum;
    export interface ExceptionType$Enum {
        withoutCorrespondence: 1;
        multipleCorrespondence: 2;
    }
    export type ExceptionType = keyof ExceptionType$Enum;
    export interface ExchangeRateType$Enum {
        dailyRate: 1;
        monthlyRate: 2;
        averageRate: 3;
        rateOfDis001: 4;
        eecRate: 5;
    }
    export type ExchangeRateType = keyof ExchangeRateType$Enum;
    export interface ExecutionType2923$Enum {
        workflowStart: 1;
        workflowEnd: 2;
        duringSignature: 3;
        line: 4;
        beforeLine: 5;
        beforeGroup: 6;
    }
    export type ExecutionType2923 = keyof ExecutionType2923$Enum;
    export interface ExecutionType$Enum {
        interactive: 1;
        importBatch: 2;
        always: 3;
    }
    export type ExecutionType = keyof ExecutionType$Enum;
    export interface ExportFormat$Enum {
        utf8: 1;
        ucs2: 2;
        ascii: 3;
    }
    export type ExportFormat = keyof ExportFormat$Enum;
    export interface FieldMaskType$Enum {
        abbreviation: 1;
        row: 2;
        pageNumber: 3;
        abscissa: 4;
        ordinate: 5;
        dimension: 6;
        format: 7;
        valueDefault: 8;
        control: 9;
        selection: 10;
        link: 11;
        mandatoryHelp: 12;
        errorHelp: 13;
        help: 14;
        buttons: 15;
        numberOfLines: 16;
        highTable: 17;
        lowTable: 18;
        covering: 19;
        options: 20;
        beforeLine: 21;
        afterLine: 22;
    }
    export type FieldMaskType = keyof FieldMaskType$Enum;
    export interface FieldOrigin$Enum {
        representation: 1;
        class: 2;
    }
    export type FieldOrigin = keyof FieldOrigin$Enum;
    export interface FieldType7821$Enum {
        measurement: 1;
        information: 2;
        dimension: 3;
        technical: 4;
    }
    export type FieldType7821 = keyof FieldType7821$Enum;
    export interface FieldType7826$Enum {
        dimension: 1;
        information: 2;
        parentDimension: 3;
        technical: 4;
    }
    export type FieldType7826 = keyof FieldType7826$Enum;
    export interface FieldType7846$Enum {
        identifier: 1;
        identifier2: 2;
        record: 3;
        parameter: 4;
    }
    export type FieldType7846 = keyof FieldType7846$Enum;
    export interface FieldType89$Enum {
        field: 1;
        expression: 2;
    }
    export type FieldType89 = keyof FieldType89$Enum;
    export interface FieldType$Enum {
        alphanumeric: 1;
        numeric: 2;
        date: 3;
        localMenu: 4;
    }
    export type FieldType = keyof FieldType$Enum;
    export interface FieldUseType$Enum {
        standard: 1;
        constant: 2;
        description: 3;
    }
    export type FieldUseType = keyof FieldUseType$Enum;
    export interface FieldUse$Enum {
        queryRecord: 1;
        query: 2;
        record: 3;
    }
    export type FieldUse = keyof FieldUse$Enum;
    export interface FinalDocumentGeneration$Enum {
        no: 1;
        complete: 2;
        accordingToActivityCode: 3;
    }
    export type FinalDocumentGeneration = keyof FinalDocumentGeneration$Enum;
    export interface FirstDayOfWeek$Enum {
        monday: 1;
        tuesday: 2;
        wednesday: 3;
        thursday: 4;
        friday: 5;
        saturday: 6;
        sunday: 7;
    }
    export type FirstDayOfWeek = keyof FirstDayOfWeek$Enum;
    export interface FolderType44$Enum {
        application: 1;
        development: 2;
    }
    export type FolderType44 = keyof FolderType44$Enum;
    export interface FolderType$Enum {
        application: 1;
        development: 2;
    }
    export type FolderType = keyof FolderType$Enum;
    export interface FontType$Enum {
        standard: 1;
        arial: 2;
        timesNewRoman: 3;
    }
    export type FontType = keyof FontType$Enum;
    export interface FormOrTableEntryMode$Enum {
        formAndTable: 1;
        form: 2;
        table: 3;
    }
    export type FormOrTableEntryMode = keyof FormOrTableEntryMode$Enum;
    export interface FormStatus$Enum {
        toProcess: 1;
        processed: 2;
        reserved3: 3;
        reserved4: 4;
        reserved5: 5;
        reserved6: 6;
        reserved7: 7;
        reserved8: 8;
        reserved9: 9;
        reserved10: 10;
        reserved11: 11;
        reserved12: 12;
        reserved13: 13;
        reserved14: 14;
        reserved15: 15;
        reserved16: 16;
        reserved17: 17;
        reserved18: 18;
        reserved: 19;
    }
    export type FormStatus = keyof FormStatus$Enum;
    export interface FormulaEnvironments$Enum {
        globalVariables: 1;
        localVariables: 2;
        functions: 3;
    }
    export type FormulaEnvironments = keyof FormulaEnvironments$Enum;
    export interface FormulaType$Enum {
        abcClasses: 1;
        headings: 2;
    }
    export type FormulaType = keyof FormulaType$Enum;
    export interface FunctionAccessType$Enum {
        yesNo: 1;
        totalInquiry: 2;
        object: 3;
    }
    export type FunctionAccessType = keyof FunctionAccessType$Enum;
    export interface FunctionContact942$Enum {
        small: 1;
        average: 2;
        large: 3;
    }
    export type FunctionContact942 = keyof FunctionContact942$Enum;
    export interface FunctionContact$Enum {
        president: 1;
        generalManager: 2;
        vicePresident: 3;
        director: 4;
        accountant: 5;
        purchasingAgent: 6;
        qualityControlManager: 7;
        inventoryManager: 8;
        branchManager: 9;
        externalConsultant: 10;
    }
    export type FunctionContact = keyof FunctionContact$Enum;
    export interface FunctionEnum$Enum {
        activation: 1;
        deactivation: 2;
    }
    export type FunctionEnum = keyof FunctionEnum$Enum;
    export interface FunctionNavigation$Enum {
        authorized: 1;
        prohibitedToThisFunction: 2;
        prohibitedFromThisFunction: 3;
        prohibitedInAllCases: 4;
    }
    export type FunctionNavigation = keyof FunctionNavigation$Enum;
    export interface GraphicObjectType$Enum {
        none: 1;
        checkBox: 2;
        buttonsVc: 3;
        buttonsVs: 4;
        buttonsHc: 5;
        buttonsHs: 6;
        spinEdit: 7;
        programBar: 8;
        photo: 9;
        multilineText: 10;
        relativeRtfFile: 11;
        absoluteTextFileRtf: 12;
        icon: 13;
    }
    export type GraphicObjectType = keyof GraphicObjectType$Enum;
    export interface GraphicalFieldType$Enum {
        value: 1;
        default: 2;
        description: 3;
        none: 4;
    }
    export type GraphicalFieldType = keyof GraphicalFieldType$Enum;
    export interface GraphicalPosition$Enum {
        toTheRight: 1;
        toTheLeft: 2;
        above: 3;
        below: 4;
    }
    export type GraphicalPosition = keyof GraphicalPosition$Enum;
    export interface GraphicalRepresentation$Enum {
        multiple: 1;
        cumulation: 2;
        comparison: 3;
        month: 4;
        week: 5;
        day: 6;
    }
    export type GraphicalRepresentation = keyof GraphicalRepresentation$Enum;
    export interface GraphicalRepresentations$Enum {
        multipleBars: 1;
        cumulationBars: 2;
        comparisonBars: 3;
        multipleLines: 4;
        cumulationLines: 5;
        comparisonLines: 6;
        multipleAreas: 7;
        cumulationAreas: 8;
        comparisonAreas: 9;
    }
    export type GraphicalRepresentations = keyof GraphicalRepresentations$Enum;
    export interface GraphicalThemes$Enum {
        x3: 1;
        sprh: 2;
        geode: 3;
        abel: 4;
        diapasonX: 5;
        x2: 6;
    }
    export type GraphicalThemes = keyof GraphicalThemes$Enum;
    export interface GraphicalType$Enum {
        simpleGraph: 1;
        multipleGraph: 2;
        planningCalendar: 3;
        xsl: 4;
        gantt: 5;
        queryTool: 6;
    }
    export type GraphicalType = keyof GraphicalType$Enum;
    export interface HeaderLine$Enum {
        substituteValue1: 1;
        header: 2;
        line: 3;
    }
    export type HeaderLine = keyof HeaderLine$Enum;
    export interface HelpKeyWordFieldType$Enum {
        table: 1;
        screen: 2;
        class: 3;
        representation: 4;
    }
    export type HelpKeyWordFieldType = keyof HelpKeyWordFieldType$Enum;
    export interface HttpCacheExpires$Enum {
        never: 1;
        always: 2;
        substituteValue3: 3;
        substituteValue4: 4;
        substituteValue5: 5;
        substituteValue6: 6;
        substituteValue7: 7;
        substituteValue8: 8;
        substituteValue9: 9;
        substituteValue10: 10;
        substituteValue11: 11;
    }
    export type HttpCacheExpires = keyof HttpCacheExpires$Enum;
    export interface ImageType$Enum {
        normal: 1;
        stretched: 2;
        proportional: 3;
    }
    export type ImageType = keyof ImageType$Enum;
    export interface InitialStatus$Enum {
        visible: 1;
        invisible: 2;
        technical: 3;
    }
    export type InitialStatus = keyof InitialStatus$Enum;
    export interface InterfaceOptimization$Enum {
        none: 1;
        noTextFile: 2;
        noImageFile: 3;
        neitherTextFileNotImageFile: 4;
        gadget: 5;
        photo: 6;
        reserved7: 7;
        reserved8: 8;
        reserved9: 9;
        reserved10: 10;
        reserved11: 11;
        reserved12: 12;
        reserved13: 13;
        reserved14: 14;
        reserved15: 15;
        reserved16: 16;
        reserved17: 17;
        reserved18: 18;
        reserved: 19;
    }
    export type InterfaceOptimization = keyof InterfaceOptimization$Enum;
    export interface InterfaceType7912$Enum {
        generatedAccessToTable: 1;
        subProgramAccess: 2;
        leftListAccess: 3;
        generatedAccessToView: 4;
        free5: 5;
        free6: 6;
        free7: 7;
        free8: 8;
        free9: 9;
        free10: 10;
        free11: 11;
        free12: 12;
        free13: 13;
        free14: 14;
        free15: 15;
        free16: 16;
        free17: 17;
        free18: 18;
        free: 19;
        subProgramAction: 20;
        objectAction: 21;
    }
    export type InterfaceType7912 = keyof InterfaceType7912$Enum;
    export interface JoinOption$Enum {
        inner: 1;
        leftOuter: 2;
        rightOuter: 3;
    }
    export type JoinOption = keyof JoinOption$Enum;
    export interface JoinType$Enum {
        mandatory: 1;
        shortcut: 2;
    }
    export type JoinType = keyof JoinType$Enum;
    export interface KindOfReference$Enum {
        reference: 1;
        localization: 2;
        collection: 3;
    }
    export type KindOfReference = keyof KindOfReference$Enum;
    export interface LdapConnectionType$Enum {
        no: 1;
        interactive: 2;
        interactiveAndWebServices: 3;
    }
    export type LdapConnectionType = keyof LdapConnectionType$Enum;
    export interface Levels$Enum {
        level1: 1;
        level2: 2;
        level3: 3;
    }
    export type Levels = keyof Levels$Enum;
    export interface LineMinimumInGrid$Enum {
        zero: 1;
        one: 2;
        maximum: 3;
    }
    export type LineMinimumInGrid = keyof LineMinimumInGrid$Enum;
    export interface LinkAttributes$Enum {
        simpleLink: 1;
        detail: 2;
        lookup: 3;
        summary: 4;
    }
    export type LinkAttributes = keyof LinkAttributes$Enum;
    export interface LinkDirection$Enum {
        towards: 1;
        from: 2;
    }
    export type LinkDirection = keyof LinkDirection$Enum;
    export interface LinkOrderForHelps$Enum {
        before: 1;
        after: 2;
    }
    export type LinkOrderForHelps = keyof LinkOrderForHelps$Enum;
    export interface LinkTarget$Enum {
        default: 1;
        newPage: 2;
        embedded: 3;
    }
    export type LinkTarget = keyof LinkTarget$Enum;
    export interface LinkType2916$Enum {
        substituteValue1: 1;
        substituteValue2: 2;
        substituteValue3: 3;
        substituteValue4: 4;
    }
    export type LinkType2916 = keyof LinkType2916$Enum;
    export interface LinkType2934$Enum {
        url: 1;
        xsl: 2;
        html: 3;
    }
    export type LinkType2934 = keyof LinkType2934$Enum;
    export interface LinkType7971$Enum {
        createRecord: 1;
        displayDetail: 2;
        modifyRecord: 3;
        deleteRecord: 4;
        displayList: 5;
        duplicateRecord: 6;
        displayAsExcel: 7;
        listInExcel: 8;
        selection: 9;
        displaySummary: 10;
        displayAsPdf: 11;
        listAsPdf: 12;
        displayInWord: 13;
        listInWord: 14;
        massMailRecord: 15;
        massMailList: 16;
        save: 17;
        cancel: 18;
        lobManagement: 19;
        print: 20;
        directPrint: 21;
        help: 22;
    }
    export type LinkType7971 = keyof LinkType7971$Enum;
    export interface LinkType7974$Enum {
        representation: 1;
        method: 2;
        operation: 3;
        x3Convergence: 4;
        free: 5;
        crystalReport: 6;
    }
    export type LinkType7974 = keyof LinkType7974$Enum;
    export interface LinkType$Enum {
        miscellaneous: 1;
        toAccounting: 2;
        toFixedAssets: 3;
        toPayroll: 4;
        toLogistics: 5;
    }
    export type LinkType = keyof LinkType$Enum;
    export interface LinkedFieldType$Enum {
        no: 1;
        long: 2;
        short: 3;
    }
    export type LinkedFieldType = keyof LinkedFieldType$Enum;
    export interface ListOfErrorConditions$Enum {
        stopOnErrorInPreviousSequences: 1;
        stopOnErrorInThePreviousSequence: 2;
        stopOnErrorInTheTask: 3;
        stopOnErrorInTheGroup: 4;
        alwaysExecute: 5;
    }
    export type ListOfErrorConditions = keyof ListOfErrorConditions$Enum;
    export interface ListOfValuesDescription$Enum {
        message: 1;
        miscellaneousTable: 2;
    }
    export type ListOfValuesDescription = keyof ListOfValuesDescription$Enum;
    export interface ListOfValuesManagement$Enum {
        manual: 1;
        automatic: 2;
        batch: 3;
    }
    export type ListOfValuesManagement = keyof ListOfValuesManagement$Enum;
    export interface ListType$Enum {
        list: 1;
        xml: 2;
    }
    export type ListType = keyof ListType$Enum;
    export interface LocalMenu9002$Enum {
        sunday: 1;
        monday: 2;
        tuesday: 3;
        wednesday: 4;
        thursday: 5;
        friday: 6;
        saturday: 7;
    }
    export type LocalMenu9002 = keyof LocalMenu9002$Enum;
    export interface LogFileLevel$Enum {
        noLogFile: 1;
        fieldLogFile: 2;
        blockAndFieldLogFile: 3;
    }
    export type LogFileLevel = keyof LogFileLevel$Enum;
    export interface LvTest$Enum {
        tan: 1;
        red: 2;
        navy: 3;
        pink: 4;
        aqua: 5;
        teal: 6;
        gold: 7;
        lime: 8;
        grey: 9;
        plum: 10;
        blue: 11;
        peru: 12;
        snow: 13;
        cyan: 14;
        rosyBrown: 15;
        darkBlue: 16;
        fireBrick: 17;
        darkCyan: 18;
        mintCream: 19;
        darkGoldenRod: 20;
        paleGoldenRod: 21;
        darkGrey: 22;
        paleGreen: 23;
        darkGreen: 24;
        lawnGreen: 25;
        limeGreen: 26;
        darkKhaki: 27;
        darkMagenta: 28;
        darkOliveGreen: 29;
        darkOrchid: 30;
        deepPink: 31;
        darkRed: 32;
        deepSkyBlue: 33;
        darkSlateGrey: 34;
        darkSalmon: 35;
        darkSeaGreen: 36;
        darkSlateBlue: 37;
        paleTurquoise: 38;
        darkTurquoise: 39;
        paleVioletRed: 40;
        darkViolet: 41;
        blueViolet: 42;
        indianRed: 43;
        floralWhite: 44;
        moccasin: 45;
        oldLace: 46;
        blancheAlmond: 47;
        whiteSmoke: 48;
        slateGrey: 49;
        azure: 50;
    }
    export type LvTest = keyof LvTest$Enum;
    export interface ManagementTypeButton$Enum {
        nonValidating: 1;
        validating: 2;
    }
    export type ManagementTypeButton = keyof ManagementTypeButton$Enum;
    export interface ManagerType$Enum {
        departmentHead: 1;
        vicePresident: 2;
        director: 3;
    }
    export type ManagerType = keyof ManagerType$Enum;
    export interface MappingSelection$Enum {
        textTranslation: 1;
        objectMapping: 2;
    }
    export type MappingSelection = keyof MappingSelection$Enum;
    export interface MessageImportance$Enum {
        low: 1;
        normal: 2;
        high: 3;
    }
    export type MessageImportance = keyof MessageImportance$Enum;
    export interface MethodAssignment$Enum {
        property: 1;
        collectionLine: 2;
        collection: 3;
        page: 4;
        record: 5;
    }
    export type MethodAssignment = keyof MethodAssignment$Enum;
    export interface MethodCategory$Enum {
        method: 1;
        function: 2;
        subprogram: 3;
    }
    export type MethodCategory = keyof MethodCategory$Enum;
    export interface MethodOperation$Enum {
        window: 1;
        import: 2;
        class: 3;
        query: 4;
        script: 5;
        nodeScript: 6;
    }
    export type MethodOperation = keyof MethodOperation$Enum;
    export interface MigrationStages$Enum {
        initialization: 1;
        commonData: 2;
        module: 3;
        postMigration: 4;
    }
    export type MigrationStages = keyof MigrationStages$Enum;
    export interface MigrationStatuses$Enum {
        pending: 1;
        inProgress: 2;
        completed: 3;
        completedWithErrors: 4;
        interrupted: 5;
        pendingInterruption: 6;
        pendingStop: 7;
        launched: 8;
        stopped: 9;
        blocked: 10;
        bypassed: 11;
    }
    export type MigrationStatuses = keyof MigrationStatuses$Enum;
    export interface ModuleTable$Enum {
        supervisor: 1;
        geodeGx: 2;
        inactive3: 3;
        inactive4: 4;
        inactive5: 5;
        inactive6: 6;
        inactive7: 7;
        inactive8: 8;
        inactive9: 9;
        inactive10: 10;
        sageX3Internal: 11;
        inactive12: 12;
        inactive13: 13;
        inactive14: 14;
        inactive15: 15;
        customModule1: 16;
        customModule2: 17;
        customModule3: 18;
        customModule4: 19;
    }
    export type ModuleTable = keyof ModuleTable$Enum;
    export interface MonthsOfTheYear$Enum {
        january: 1;
        february: 2;
        march: 3;
        april: 4;
        may: 5;
        june: 6;
        july: 7;
        august: 8;
        september: 9;
        october: 10;
        november: 11;
        december: 12;
    }
    export type MonthsOfTheYear = keyof MonthsOfTheYear$Enum;
    export interface MultipleGraphs$Enum {
        curves: 1;
        sectors: 2;
    }
    export type MultipleGraphs = keyof MultipleGraphs$Enum;
    export interface MutationTyp$Enum {
        custom: 1;
        create: 2;
        update: 3;
        delete: 4;
        createUpdateDelete: 5;
    }
    export type MutationTyp = keyof MutationTyp$Enum;
    export interface NatureOfSession$Enum {
        internal: 1;
        external: 2;
    }
    export type NatureOfSession = keyof NatureOfSession$Enum;
    export interface NoYesCriteriaNotDisplayed$Enum {
        no: 1;
        yes: 2;
        criteriaNotDisplayed: 3;
    }
    export type NoYesCriteriaNotDisplayed = keyof NoYesCriteriaNotDisplayed$Enum;
    export interface NodeBindingType$Enum {
        windows: 1;
        dataModel: 2;
        import: 3;
        script: 4;
        view: 5;
        class: 6;
        nodeScript: 7;
    }
    export type NodeBindingType = keyof NodeBindingType$Enum;
    export interface NodeDirection$Enum {
        input: 1;
        output: 2;
        both: 3;
    }
    export type NodeDirection = keyof NodeDirection$Enum;
    export interface NodeType$Enum {
        boolean: 1;
        integer: 2;
        decimal: 3;
        string: 4;
        date: 5;
        node: 6;
        translatableText: 7;
        enum: 8;
        object: 9;
        imageFile: 10;
        textFile: 11;
        dateTime: 12;
    }
    export type NodeType = keyof NodeType$Enum;
    export interface NormalAndMultipleGraphs$Enum {
        bars: 1;
        lines: 2;
        areas: 3;
        sectors: 4;
        multipleBars: 5;
        multipleLines: 6;
        multipleAreas: 7;
        multipleSectors: 8;
        cumulativeBars: 9;
        cumulativeLines: 10;
        cumulativeSectors: 11;
        cumulativeAreas: 12;
        comparativeBars: 13;
        comparativeLines: 14;
        comparativeAreas: 15;
        comparativeSectors: 16;
    }
    export type NormalAndMultipleGraphs = keyof NormalAndMultipleGraphs$Enum;
    export interface ObjectManagementType$Enum {
        simple: 1;
        table: 2;
        combined: 3;
        browser: 4;
    }
    export type ObjectManagementType = keyof ObjectManagementType$Enum;
    export interface ObjectParameterType$Enum {
        keys: 1;
        data: 2;
    }
    export type ObjectParameterType = keyof ObjectParameterType$Enum;
    export interface ObjectType42$Enum {
        table: 1;
        screen: 2;
        document: 3;
        object: 4;
        dataType: 5;
        action: 6;
        parameter: 7;
        activityCode: 8;
        function: 9;
        miscellaneous: 10;
        window11: 11;
        inquiry: 12;
        batchTask: 13;
        dashboard: 14;
        window: 15;
        free16: 16;
        free17: 17;
        free18: 18;
        free: 19;
        dimensionElement: 20;
        report: 21;
        transactionType: 22;
        style: 23;
        reportRpt: 24;
        reportBo: 25;
        gdprSetup: 26;
        utility: 27;
        package: 28;
    }
    export type ObjectType42 = keyof ObjectType42$Enum;
    export interface ObjectType$Enum {
        process: 1;
        menu: 2;
    }
    export type ObjectType = keyof ObjectType$Enum;
    export interface ObjectUpdateType$Enum {
        no: 1;
        validation: 2;
        recording: 3;
    }
    export type ObjectUpdateType = keyof ObjectUpdateType$Enum;
    export interface ObjectWsAction$Enum {
        read: 1;
        create: 2;
        delete: 3;
        save: 4;
        other: 5;
    }
    export type ObjectWsAction = keyof ObjectWsAction$Enum;
    export interface OfficeDocumentType$Enum {
        word: 1;
        excel: 2;
        powerPoint: 3;
        universal: 4;
    }
    export type OfficeDocumentType = keyof OfficeDocumentType$Enum;
    export interface OperationAccountForSpyFile$Enum {
        create: 1;
        change: 2;
        cancel: 3;
        validate: 4;
        edit: 5;
        code: 6;
    }
    export type OperationAccountForSpyFile = keyof OperationAccountForSpyFile$Enum;
    export interface OperationTracking$Enum {
        no: 1;
        yes: 2;
        cancellationAndChangeOfCode: 3;
    }
    export type OperationTracking = keyof OperationTracking$Enum;
    export interface OperationType$Enum {
        sum: 1;
        average: 2;
        minimum: 3;
    }
    export type OperationType = keyof OperationType$Enum;
    export interface OracleProcessSorting$Enum {
        sid: 1;
        oracleUser: 2;
        logonDate: 3;
        status: 4;
        application: 5;
        osUser: 6;
        osProcess: 7;
        machine: 8;
        cpu: 9;
        pgaMemory: 10;
        iOPhysReads: 11;
        logicalReads: 12;
        hardParses: 13;
        background: 14;
        lastExecution: 15;
    }
    export type OracleProcessSorting = keyof OracleProcessSorting$Enum;
    export interface OracleTraceSortOptions$Enum {
        standardChronological: 1;
        elapsedTime: 2;
        costOfSqlInstructions: 3;
        cpuUse: 4;
        diskUse: 5;
        advanced: 6;
    }
    export type OracleTraceSortOptions = keyof OracleTraceSortOptions$Enum;
    export interface Orientation$Enum {
        portrait: 1;
        landscape: 2;
    }
    export type Orientation = keyof Orientation$Enum;
    export interface OsType$Enum {
        unix: 1;
        windows: 2;
        linux: 3;
    }
    export type OsType = keyof OsType$Enum;
    export interface Pages$Enum {
        xml: 1;
        html: 2;
    }
    export type Pages = keyof Pages$Enum;
    export interface PaperSizes$Enum {
        default: 1;
        reportPreference: 2;
        printerPreference: 3;
        reserved4: 4;
        reserved5: 5;
        reserved6: 6;
        reserved: 7;
        letter812X11In: 8;
        letterSmall812X11In: 9;
        tabloid11X17In: 10;
        ledger17X11In: 11;
        legal812X14In: 12;
        statement512X812In: 13;
        executive714X1012In: 14;
        a3297X420Mm: 15;
        a4210X297Mm: 16;
        a4Small210X297Mm: 17;
        a5148X210Mm: 18;
        b4Jis250X354: 19;
        b5Jis182X257Mm: 20;
        folio812X13In: 21;
        quarto215X275Mm: 22;
        substituteValue23: 23;
        substituteValue24: 24;
        note812X11In: 25;
        envelope9378X878: 26;
        envelope10418X912: 27;
        envelope11412X1038: 28;
        envelope124276X11: 29;
        envelope145X1112: 30;
        cSizeSheet: 31;
        dSizeSheet: 32;
        eSizeSheet: 33;
        envelopeDl110X220Mm: 34;
        envelopeC5162X229Mm: 35;
        envelopeC3324X458Mm: 36;
        envelopeC4229X324Mm: 37;
        envelopeC6114X162Mm: 38;
        envelopeC65114X229Mm: 39;
        envelopeB4250X353Mm: 40;
        envelopeB5176X250Mm: 41;
        envelopeB6176X125Mm: 42;
        envelope110X230Mm: 43;
        envelopeMonarch3875X75In: 44;
        substituteValue45: 45;
        usStdFanfold1478X11In: 46;
        germanStdFanfold812X12In: 47;
        germanLegalFanfold812X13In: 48;
    }
    export type PaperSizes = keyof PaperSizes$Enum;
    export interface ParameterDefinitionLevel$Enum {
        folder: 1;
        company: 2;
        site: 3;
        user: 4;
        legislation: 5;
    }
    export type ParameterDefinitionLevel = keyof ParameterDefinitionLevel$Enum;
    export interface ParameterType7800$Enum {
        single: 1;
        range: 2;
        multiple: 3;
    }
    export type ParameterType7800 = keyof ParameterType7800$Enum;
    export interface ParameterType$Enum {
        char: 1;
        integer: 2;
        decimal: 3;
        date: 4;
        libelle: 5;
        clbfile: 6;
        blbfile: 7;
        instance: 8;
        uuident: 9;
        datetime: 10;
    }
    export type ParameterType = keyof ParameterType$Enum;
    export interface ParameterTypes10030$Enum {
        tinyInt: 1;
        shortInteger: 2;
        longInteger: 3;
        decimal: 4;
        floating: 5;
        double: 6;
        alphanumeric: 7;
        date: 8;
        blob: 9;
        clob: 10;
        uuid: 11;
        datetime: 12;
        instance: 13;
    }
    export type ParameterTypes10030 = keyof ParameterTypes10030$Enum;
    export interface ParameterTypes$Enum {
        parameter: 1;
        key: 2;
        endParameter: 3;
    }
    export type ParameterTypes = keyof ParameterTypes$Enum;
    export interface PatchIntegration$Enum {
        normalIntegration: 1;
        completeIntegrationOfUpdate: 2;
        recoveryFromNextPatch: 3;
        recoveryFromCurrentPatch: 4;
    }
    export type PatchIntegration = keyof PatchIntegration$Enum;
    export interface PatchStatus$Enum {
        pending: 1;
        inProgress: 2;
        completed: 3;
        notInstalled: 4;
        error: 5;
        completedWithErrors: 6;
    }
    export type PatchStatus = keyof PatchStatus$Enum;
    export interface PatchType$Enum {
        standard: 1;
        supervisor: 2;
        specific: 3;
        vertical: 4;
        addOn: 5;
    }
    export type PatchType = keyof PatchType$Enum;
    export interface Preloading$Enum {
        no: 1;
        partial: 2;
        total: 3;
    }
    export type Preloading = keyof Preloading$Enum;
    export interface PrintTypes$Enum {
        reports: 1;
        queries: 2;
        sqlQueries: 3;
        exports: 4;
        businessObjects: 5;
    }
    export type PrintTypes = keyof PrintTypes$Enum;
    export interface PrinterType$Enum {
        lase: 1;
        graphic: 2;
    }
    export type PrinterType = keyof PrinterType$Enum;
    export interface ProcessArchive$Enum {
        extraction: 1;
        integration: 2;
        deletion: 3;
    }
    export type ProcessArchive = keyof ProcessArchive$Enum;
    export interface ProcessFilter$Enum {
        currentFolder: 1;
        allFolders: 2;
    }
    export type ProcessFilter = keyof ProcessFilter$Enum;
    export interface ProcessType78$Enum {
        noInitialEntry: 1;
        yesNoConfirmation: 2;
        dialogBox: 3;
        windowEntry: 4;
        listSelection: 5;
        tableSelection: 6;
    }
    export type ProcessType78 = keyof ProcessType78$Enum;
    export interface ProcessType$Enum {
        integration: 1;
        validation: 2;
        import: 3;
        restoration: 4;
    }
    export type ProcessType = keyof ProcessType$Enum;
    export interface Processes$Enum {
        process: 1;
        menu: 2;
    }
    export type Processes = keyof Processes$Enum;
    export interface ProcessingType$Enum {
        list: 1;
        assembly: 2;
        validation: 3;
    }
    export type ProcessingType = keyof ProcessingType$Enum;
    export interface ProductEdition$Enum {
        substituteValue1: 1;
        premium: 2;
        standard: 3;
        standardNa: 4;
        standardUk: 5;
        standardSpain: 6;
        standardPortugal: 7;
        standardGermany: 8;
        standardSwitzerland: 9;
        standardChina: 10;
        standardSouthAfricaAndAsean: 11;
        standardAustralia: 12;
    }
    export type ProductEdition = keyof ProductEdition$Enum;
    export interface Products7857$Enum {
        x3: 1;
        sprh: 2;
        geode: 3;
        abel: 4;
    }
    export type Products7857 = keyof Products7857$Enum;
    export interface Products7884$Enum {
        sageX3: 1;
        sageX3Warehousing: 2;
        sageX3HrPayroll: 3;
        sageX3FixedAssets: 4;
    }
    export type Products7884 = keyof Products7884$Enum;
    export interface Products$Enum {
        enterpriseManagement: 1;
        x3HrPayroll: 2;
        enterpriseManagementWarehousing: 3;
        enterpriseManagementFixedAssets: 4;
        substituteValue5: 5;
        substituteValue6: 6;
    }
    export type Products = keyof Products$Enum;
    export interface ProfileTypeFunction$Enum {
        normal: 1;
        administrator: 2;
        developer: 3;
    }
    export type ProfileTypeFunction = keyof ProfileTypeFunction$Enum;
    export interface PropagationRule$Enum {
        no: 1;
        yes: 2;
        uponRequest: 3;
    }
    export type PropagationRule = keyof PropagationRule$Enum;
    export interface Protocol$Enum {
        httpStandard: 1;
        httpsSecure: 2;
        webSite: 3;
    }
    export type Protocol = keyof Protocol$Enum;
    export interface PrototypeFormat$Enum {
        aucun: 1;
        email: 2;
        phone: 3;
        combo: 4;
        radios: 5;
        tt: 6;
        password: 7;
    }
    export type PrototypeFormat = keyof PrototypeFormat$Enum;
    export interface PrototypeType$Enum {
        applicationXChoice: 1;
        applicationXInteger: 2;
        applicationXDecimal: 3;
        applicationXReal: 4;
        applicationXString: 5;
        applicationXDate: 6;
        applicationXDatime: 7;
        applicationXBoolean: 8;
    }
    export type PrototypeType = keyof PrototypeType$Enum;
    export interface QueryProgressStatus$Enum {
        standby: 1;
        inProgress: 2;
        finished: 3;
        held: 4;
        kill: 5;
        canceled: 6;
        error: 7;
        overdue: 8;
        warning: 9;
    }
    export type QueryProgressStatus = keyof QueryProgressStatus$Enum;
    export interface QueryType$Enum {
        normal: 1;
        shared: 2;
        recalculated: 3;
    }
    export type QueryType = keyof QueryType$Enum;
    export interface RangeType$Enum {
        object: 1;
        message: 2;
        miscellaneousTable: 3;
        field: 4;
    }
    export type RangeType = keyof RangeType$Enum;
    export interface Range$Enum {
        no: 1;
        startRange: 2;
        endRange: 3;
    }
    export type Range = keyof Range$Enum;
    export interface RateDate$Enum {
        journalEntryDate: 1;
        sourceDocumentDate: 2;
    }
    export type RateDate = keyof RateDate$Enum;
    export interface RecipientType$Enum {
        user: 1;
        site: 2;
        depositor: 3;
        carrier: 4;
        supplier: 5;
        client: 6;
        company: 7;
    }
    export type RecipientType = keyof RecipientType$Enum;
    export interface RecordType$Enum {
        header: 1;
        line: 2;
        footer: 3;
    }
    export type RecordType = keyof RecordType$Enum;
    export interface ReferenceType$Enum {
        property: 1;
        string: 2;
        integer: 3;
        date: 4;
        decimal: 5;
        enums: 6;
        propertyPath: 7;
        globalVariable: 8;
        expression: 9;
    }
    export type ReferenceType = keyof ReferenceType$Enum;
    export interface RegroupingSite$Enum {
        siteGrouping: 1;
        site: 2;
    }
    export type RegroupingSite = keyof RegroupingSite$Enum;
    export interface ReorderType$Enum {
        crystalReport: 1;
        disabledSinceV5InterchangeDataFormat: 2;
        wordForWindows: 3;
        disabledSinceV5ValueColumns: 4;
        richTextRtf: 5;
        disabledSinceV5ValuesSeparatedByCommasCsv: 6;
        disabledSinceV5ValuesSeparatedByTabs: 7;
        disabledSinceV5ValuesSeparatedByACharacter: 8;
        asciiText: 9;
        paginatedAsciiText: 10;
        disabledSinceV5AsciiTextSeparatedByTabs: 11;
        disabledSince136Release12: 12;
        disabledSince136Release13: 13;
        disabledSince136Release14: 14;
        disabledSince136Release15: 15;
        disabledSince136Release16: 16;
        disabledSince136Release17: 17;
        disabledSince136Release18: 18;
        disabledSince136Release19: 19;
        disabledSince140Odbc: 20;
        disabledSince140Html32: 21;
        disabledSince136Release22: 22;
        disabledSince136Release23: 23;
        disabledSince140Html4: 24;
        disabledSince136Release25: 25;
        disabledSince136Release: 26;
        excel972000: 27;
        excel972000Extended: 28;
        pdf: 29;
        substituteValue30: 30;
        workbookExtended: 31;
    }
    export type ReorderType = keyof ReorderType$Enum;
    export interface ReportDeveloperOptions$Enum {
        no: 1;
        yes: 2;
        administrator: 3;
    }
    export type ReportDeveloperOptions = keyof ReportDeveloperOptions$Enum;
    export interface ReportDevelopmentStatus$Enum {
        shared: 1;
        transferRequest: 2;
        sandbox: 3;
        commitRequest: 4;
        revertRequest: 5;
        crDesignerLoading: 6;
    }
    export type ReportDevelopmentStatus = keyof ReportDevelopmentStatus$Enum;
    export interface ReportGroup$Enum {
        supervisor: 1;
        masterData: 2;
        inputs: 3;
        outputs: 4;
        stocks: 5;
        diverse: 6;
    }
    export type ReportGroup = keyof ReportGroup$Enum;
    export interface RepresentationFacets$Enum {
        detail: 1;
        edit: 2;
        query: 3;
        lookup: 4;
        summary: 5;
    }
    export type RepresentationFacets = keyof RepresentationFacets$Enum;
    export interface RepresentationParameterType$Enum {
        propertyParameter: 1;
        displayedPropertyParameter: 2;
        linkParameter: 3;
    }
    export type RepresentationParameterType = keyof RepresentationParameterType$Enum;
    export interface RepresentationType7967$Enum {
        main: 1;
        child: 2;
    }
    export type RepresentationType7967 = keyof RepresentationType7967$Enum;
    export interface RepresentationType$Enum {
        desktop: 1;
        mobilePhone: 2;
        tablet: 3;
    }
    export type RepresentationType = keyof RepresentationType$Enum;
    export interface Representation$Enum {
        default: 1;
        bar: 2;
        line: 3;
    }
    export type Representation = keyof Representation$Enum;
    export interface ResetSequenceNumberToZero$Enum {
        noRtz: 1;
        annual: 2;
        monthly: 3;
        fiscalYear: 4;
        period: 5;
    }
    export type ResetSequenceNumberToZero = keyof ResetSequenceNumberToZero$Enum;
    export interface RetreivalOfSqlServerTrace$Enum {
        standard: 1;
        tuning: 2;
        advanced: 3;
    }
    export type RetreivalOfSqlServerTrace = keyof RetreivalOfSqlServerTrace$Enum;
    export interface RootDirectory$Enum {
        none: 1;
        htmlDesign: 2;
        xFilapp: 3;
        xFiles: 4;
        xTend: 5;
    }
    export type RootDirectory = keyof RootDirectory$Enum;
    export interface RuleTypes$Enum {
        init: 1;
        control: 2;
        propagate: 3;
        getvalue: 4;
        format: 5;
        readMedia: 6;
        updateMedia: 7;
        deleteMedia: 8;
        insertMedia: 9;
        readMediaCnt: 10;
        existMedia: 11;
    }
    export type RuleTypes = keyof RuleTypes$Enum;
    export interface ScreenResolution$Enum {
        lowResolution: 1;
        highResolution: 2;
    }
    export type ScreenResolution = keyof ScreenResolution$Enum;
    export interface ScreenType$Enum {
        tab: 1;
        dialogueBox: 2;
        fullScreen: 3;
        fullScreenWithList: 4;
        header: 5;
        vtScreen: 6;
    }
    export type ScreenType = keyof ScreenType$Enum;
    export interface SearchOperators$Enum {
        equal: 1;
        greaterThan: 2;
        lessThan: 3;
        different: 4;
    }
    export type SearchOperators = keyof SearchOperators$Enum;
    export interface SecurityLevel$Enum {
        high: 1;
        medium: 2;
        low: 3;
    }
    export type SecurityLevel = keyof SecurityLevel$Enum;
    export interface SelectionOperators7815$Enum {
        indifferent: 1;
        equalTo: 2;
        different: 3;
        greaterThan: 4;
        greaterThanOrEqualTo: 5;
        lessThan: 6;
        lessThanOrEqualTo: 7;
        like: 8;
        modified: 9;
        increased: 10;
        reduced: 11;
    }
    export type SelectionOperators7815 = keyof SelectionOperators7815$Enum;
    export interface SelectionOperators7926$Enum {
        indifferent: 1;
        substituteValue2: 2;
        substituteValue3: 3;
        substituteValue4: 4;
        substituteValue5: 5;
        substituteValue6: 6;
        substituteValue7: 7;
        startsWith: 8;
        contains: 9;
        doesNotContain: 10;
    }
    export type SelectionOperators7926 = keyof SelectionOperators7926$Enum;
    export interface SelectionOperators$Enum {
        all: 1;
        equal: 2;
        notEqualTo: 3;
        greaterThan: 4;
        greaterThanOrEqualTo: 5;
        lessThan: 6;
        lessThanOrEqualTo: 7;
        like: 8;
    }
    export type SelectionOperators = keyof SelectionOperators$Enum;
    export interface SelectionOptMainBlock$Enum {
        replacesTheSelectionOfTheMainBlock: 1;
        isAddedToTheSelectionOfTheMainBlock: 2;
        isAddedToAllTheCurrentSelections: 3;
    }
    export type SelectionOptMainBlock = keyof SelectionOptMainBlock$Enum;
    export interface SelectionType$Enum {
        none: 1;
        code: 2;
        query: 3;
        lastLinkClicked: 4;
        detail: 5;
    }
    export type SelectionType = keyof SelectionType$Enum;
    export interface SelectiveAssembly$Enum {
        allTypes: 1;
        cS: 2;
        web: 3;
    }
    export type SelectiveAssembly = keyof SelectiveAssembly$Enum;
    export interface SendType$Enum {
        any: 1;
        server: 2;
        client: 3;
    }
    export type SendType = keyof SendType$Enum;
    export interface SendingTypeWorkflow$Enum {
        alert: 1;
        eMail: 2;
    }
    export type SendingTypeWorkflow = keyof SendingTypeWorkflow$Enum;
    export interface SequenceNumberFields$Enum {
        constant: 1;
        year: 2;
        month: 3;
        week: 4;
        day: 5;
        company: 6;
        site: 7;
        sequenceNumber: 8;
        complement: 9;
        fiscalYear: 10;
        period: 11;
        formula: 12;
    }
    export type SequenceNumberFields = keyof SequenceNumberFields$Enum;
    export interface SequenceNumberType$Enum {
        alphanumeric: 1;
        numeric: 2;
    }
    export type SequenceNumberType = keyof SequenceNumberType$Enum;
    export interface SequenceType$Enum {
        normal: 1;
        databaseSequence: 2;
        grouped: 3;
    }
    export type SequenceType = keyof SequenceType$Enum;
    export interface ServerStatus$Enum {
        inactive: 1;
        active: 2;
        shuttingDown: 3;
        restartInProgress: 4;
    }
    export type ServerStatus = keyof ServerStatus$Enum;
    export interface SetupElements$Enum {
        all: 1;
        selected: 2;
        notSelected: 3;
    }
    export type SetupElements = keyof SetupElements$Enum;
    export interface Signature$Enum {
        cancelled: 1;
        toBeRead: 2;
        toBeSigned: 3;
        read: 4;
        signed: 5;
    }
    export type Signature = keyof Signature$Enum;
    export interface Size$Enum {
        none: 1;
        from1: 2;
        from0: 3;
    }
    export type Size = keyof Size$Enum;
    export interface Sizing$Enum {
        from1: 1;
        from0: 2;
    }
    export type Sizing = keyof Sizing$Enum;
    export interface SortFunctions$Enum {
        byCode: 1;
        byMenu: 2;
    }
    export type SortFunctions = keyof SortFunctions$Enum;
    export interface SortOpenItems$Enum {
        payByBp: 1;
        dueDate: 2;
    }
    export type SortOpenItems = keyof SortOpenItems$Enum;
    export interface SortOrder$Enum {
        ascending: 1;
        descending: 2;
    }
    export type SortOrder = keyof SortOrder$Enum;
    export interface SortType7917$Enum {
        none: 1;
        field: 2;
        random: 3;
    }
    export type SortType7917 = keyof SortType7917$Enum;
    export interface SortType$Enum {
        none: 1;
        ascending: 2;
        descending: 3;
    }
    export type SortType = keyof SortType$Enum;
    export interface SpecificFlag$Enum {
        standard: 1;
        vertical: 2;
        specific: 3;
    }
    export type SpecificFlag = keyof SpecificFlag$Enum;
    export interface SpecificsCompliance$Enum {
        risks: 1;
        errors: 2;
        fatalErrors: 3;
        impacts: 4;
    }
    export type SpecificsCompliance = keyof SpecificsCompliance$Enum;
    export interface SqlServerProcessSorting$Enum {
        processId: 1;
        database: 2;
        connectionUser: 3;
        logonDate: 4;
        status: 5;
        application: 6;
        command: 7;
        lastExecution: 8;
        hostProcess: 9;
        hostMachine: 10;
        cpu: 11;
        memory: 12;
        ioPhys: 13;
    }
    export type SqlServerProcessSorting = keyof SqlServerProcessSorting$Enum;
    export interface SqlServerTraceOptions$Enum {
        standardChronological: 1;
        durationTimeInMilliseconds: 2;
        cpuTimeConsumedInMilliseconds: 3;
        writesNumberOfPhysicalWritesPerformed: 4;
        readsNumberOfPhysicalReadsPerformed: 5;
    }
    export type SqlServerTraceOptions = keyof SqlServerTraceOptions$Enum;
    export interface StandardBottomOfPageCodes$Enum {
        search: 1;
        create: 2;
        change: 3;
        cancel: 4;
        copy: 5;
        next: 6;
        previous7: 7;
        list: 8;
        validate: 9;
        print: 10;
        previous: 11;
        last: 12;
        xSel: 13;
        table: 14;
        code: 15;
        page16: 16;
        page: 17;
        end: 18;
    }
    export type StandardBottomOfPageCodes = keyof StandardBottomOfPageCodes$Enum;
    export interface StandardMethods$Enum {
        creation: 1;
        deletion: 2;
        attachments: 3;
        comments: 4;
        browsing: 5;
        print: 6;
        read: 7;
        selection: 8;
        duplication: 9;
        modification: 10;
        executable: 11;
    }
    export type StandardMethods = keyof StandardMethods$Enum;
    export interface StatisticalFrequency$Enum {
        daily: 1;
        weekly: 2;
        substituteValue3: 3;
        monthly: 4;
        quarterly: 5;
        yearly: 6;
        substituteValue7: 7;
    }
    export type StatisticalFrequency = keyof StatisticalFrequency$Enum;
    export interface StatisticalType$Enum {
        realTime: 1;
        batch: 2;
    }
    export type StatisticalType = keyof StatisticalType$Enum;
    export interface StatisticalUpdate$Enum {
        incremental: 1;
        recovery: 2;
    }
    export type StatisticalUpdate = keyof StatisticalUpdate$Enum;
    export interface StatusDoc$Enum {
        deliverable: 1;
        setupKit: 2;
    }
    export type StatusDoc = keyof StatusDoc$Enum;
    export interface SubProgramTypes$Enum {
        miscellaneous: 1;
        control: 2;
        entry: 3;
        selection: 4;
        update: 5;
        xsl: 6;
        status: 7;
        infoSearch: 8;
        calculation: 9;
    }
    export type SubProgramTypes = keyof SubProgramTypes$Enum;
    export interface SubdivisionEntry$Enum {
        none: 1;
        subdivision1: 2;
        subdivision2: 3;
    }
    export type SubdivisionEntry = keyof SubdivisionEntry$Enum;
    export interface SupervisorCounters$Enum {
        workflowGroupSequenceNumber: 1;
        workflowLineSequenceNumber: 2;
        lotNbOfImportTempStorageSpace: 3;
        xtendForm: 4;
    }
    export type SupervisorCounters = keyof SupervisorCounters$Enum;
    export interface SynthesisOperators$Enum {
        mini: 1;
        maxi: 2;
        sum: 3;
        average: 4;
    }
    export type SynthesisOperators = keyof SynthesisOperators$Enum;
    export interface SyracuseFormat$Enum {
        boolean: 1;
        integer: 2;
        decimal: 3;
        real: 4;
        date: 5;
        time: 6;
        string: 7;
        text: 8;
        binaryData: 9;
        enumeration: 10;
        datetime: 11;
    }
    export type SyracuseFormat = keyof SyracuseFormat$Enum;
    export interface SyracuseTest$Enum {
        insertsBefore: 1;
        insertsAfter: 2;
        deletesFrom: 3;
    }
    export type SyracuseTest = keyof SyracuseTest$Enum;
    export interface SystemTransactionType$Enum {
        modification: 1;
        deletion: 2;
        creation: 3;
    }
    export type SystemTransactionType = keyof SystemTransactionType$Enum;
    export interface TableType2930$Enum {
        character: 1;
        characterOrGraph: 2;
        characterAndGraph: 3;
        graph: 4;
    }
    export type TableType2930 = keyof TableType2930$Enum;
    export interface TableType80$Enum {
        neutral: 1;
        cisam: 2;
        oracle: 3;
        system: 4;
        sqlServer: 5;
        db2Udb: 6;
        fileInMemoryVtb: 7;
    }
    export type TableType80 = keyof TableType80$Enum;
    export interface TableType$Enum {
        application: 1;
        supervisor: 2;
        sageX3System: 3;
        dictionary: 4;
        internal: 5;
    }
    export type TableType = keyof TableType$Enum;
    export interface TechnicalOrigin$Enum {
        classicPages: 1;
        classes: 2;
    }
    export type TechnicalOrigin = keyof TechnicalOrigin$Enum;
    export interface TechnicalTypeField$Enum {
        miscellaneous: 1;
        mimeType: 2;
        exclusion: 3;
        xsl: 4;
        menu: 5;
    }
    export type TechnicalTypeField = keyof TechnicalTypeField$Enum;
    export interface TelephoneNumberControl$Enum {
        none: 1;
        onlyInModificationMode: 2;
        always: 3;
    }
    export type TelephoneNumberControl = keyof TelephoneNumberControl$Enum;
    export interface TelephoneType$Enum {
        landline: 1;
        fax: 2;
        tollfree: 3;
        other: 4;
        mobile: 5;
    }
    export type TelephoneType = keyof TelephoneType$Enum;
    export interface TemplateType$Enum {
        structures: 1;
        mask: 2;
    }
    export type TemplateType = keyof TemplateType$Enum;
    export interface TextRoles$Enum {
        confidential: 1;
        internal: 2;
        external: 3;
        external2: 4;
    }
    export type TextRoles = keyof TextRoles$Enum;
    export interface TextType944$Enum {
        undetermined: 1;
        richText: 2;
        rawText: 3;
    }
    export type TextType944 = keyof TextType944$Enum;
    export interface TextType$Enum {
        text: 1;
        message: 2;
    }
    export type TextType = keyof TextType$Enum;
    export interface TimestampManagement$Enum {
        yes: 1;
        no: 2;
        periodic: 3;
    }
    export type TimestampManagement = keyof TimestampManagement$Enum;
    export interface Title$Enum {
        mr: 1;
        mrs: 2;
        miss: 3;
    }
    export type Title = keyof Title$Enum;
    export interface TracePresentation$Enum {
        listOfAllTracedSqlOrders: 1;
        listRestrictedToTheSpecifiedNumberOfSqlOrders: 2;
    }
    export type TracePresentation = keyof TracePresentation$Enum;
    export interface TransferType$Enum {
        file: 1;
        imageFileTable: 2;
        textFileTable: 3;
    }
    export type TransferType = keyof TransferType$Enum;
    export interface TranslationPriorityLevel$Enum {
        normal: 1;
        high: 2;
        maximum: 3;
        doNotTranslate: 4;
    }
    export type TranslationPriorityLevel = keyof TranslationPriorityLevel$Enum;
    export interface Type7881$Enum {
        simple: 1;
        reference: 2;
        richMedia: 3;
    }
    export type Type7881 = keyof Type7881$Enum;
    export interface Type7882$Enum {
        char: 1;
        integer: 2;
        decimal: 3;
        date: 4;
    }
    export type Type7882 = keyof Type7882$Enum;
    export interface TypeDeMiseAuPoint$Enum {
        inProgress: 1;
        debug: 2;
        otherSession: 3;
    }
    export type TypeDeMiseAuPoint = keyof TypeDeMiseAuPoint$Enum;
    export interface TypeOfActivity9837$Enum {
        work: 1;
        paidHolidays: 2;
        recuperationTime: 3;
        sickness: 4;
        training: 5;
    }
    export type TypeOfActivity9837 = keyof TypeOfActivity9837$Enum;
    export interface TypeOfDate913$Enum {
        days: 1;
        weeks: 2;
        months: 3;
        years: 4;
    }
    export type TypeOfDate913 = keyof TypeOfDate913$Enum;
    export interface TypeOfDate$Enum {
        currentDate: 1;
        startOfMonth: 2;
        endOfMonth: 3;
        startOfYear: 4;
        endOfYear: 5;
        startOfQuarter: 6;
        endOfQuarter: 7;
        startOfWeek: 8;
        endOfWeek: 9;
        startOfFortnight: 10;
        endOfFortnight: 11;
        startOf10DayPeriod: 12;
        endOf10DayPeriod: 13;
        formula: 14;
        absoluteDate: 15;
    }
    export type TypeOfDate = keyof TypeOfDate$Enum;
    export interface TypeOfDay$Enum {
        workingDay: 1;
        weekEnd: 2;
        holiday: 3;
    }
    export type TypeOfDay = keyof TypeOfDay$Enum;
    export interface TypeOfDependency$Enum {
        none: 1;
        reverse: 2;
        sizing: 3;
        formula: 4;
    }
    export type TypeOfDependency = keyof TypeOfDependency$Enum;
    export interface TypeOfGadget$Enum {
        gadget: 1;
        menu: 2;
        separator: 3;
    }
    export type TypeOfGadget = keyof TypeOfGadget$Enum;
    export interface TypeOfNonStandardFile$Enum {
        unspecified: 1;
        text: 2;
        image: 3;
        office: 4;
        word: 5;
        excel: 6;
        powerPoint: 7;
    }
    export type TypeOfNonStandardFile = keyof TypeOfNonStandardFile$Enum;
    export interface TypeOfParameters$Enum {
        character: 1;
        integer: 2;
        boolean: 3;
        numeric: 4;
        date: 5;
        text: 6;
        enumeration: 7;
    }
    export type TypeOfParameters = keyof TypeOfParameters$Enum;
    export interface TypeOfQuickSelectList$Enum {
        simple: 1;
        hierarchical: 2;
        selection: 3;
        recursive: 4;
        simpleSelection: 5;
    }
    export type TypeOfQuickSelectList = keyof TypeOfQuickSelectList$Enum;
    export interface TypeOfSession$Enum {
        primary1: 1;
        secondary2: 2;
        batch3: 3;
        webServices4: 4;
        terminal5: 5;
        eclipse6: 6;
        javaBridge7: 7;
        substituteValue8: 8;
        primary: 9;
        secondary: 10;
        batch11: 11;
        webServices12: 12;
        terminal13: 13;
        eclipse14: 14;
        javaBridge: 15;
        substituteValue16: 16;
        console: 17;
        substituteValue18: 18;
        substituteValue19: 19;
        webServices: 20;
        terminal: 21;
        substituteValue22: 22;
        substituteValue23: 23;
        substituteValue24: 24;
        classicPage: 25;
        substituteValue26: 26;
        substituteValue27: 27;
        substituteValue28: 28;
        substituteValue29: 29;
        eclipse: 30;
        substituteValue31: 31;
        substituteValue32: 32;
        webPage: 33;
        remoteClassicCall: 34;
        batch: 35;
    }
    export type TypeOfSession = keyof TypeOfSession$Enum;
    export interface TypeOfStatistic$Enum {
        normal: 1;
        rollingTotal: 2;
        ofTotal: 3;
        accumulated: 4;
    }
    export type TypeOfStatistic = keyof TypeOfStatistic$Enum;
    export interface TypesOfActivityCode$Enum {
        functional: 1;
        sizing: 2;
        localization: 3;
    }
    export type TypesOfActivityCode = keyof TypesOfActivityCode$Enum;
    export interface UnitType$Enum {
        length: 1;
        area: 2;
        volume: 3;
        weight: 4;
        time: 5;
        each: 6;
        packing: 7;
        other: 8;
    }
    export type UnitType = keyof UnitType$Enum;
    export interface UpdateFrequency$Enum {
        atEachUse: 1;
        everyHour: 2;
        everyDay: 3;
        everyWeek: 4;
        everyMonth: 5;
        theFirstTime: 6;
        substituteValue7: 7;
        everyMinute: 8;
        every10Seconds: 9;
    }
    export type UpdateFrequency = keyof UpdateFrequency$Enum;
    export interface UpdateOperations$Enum {
        creation: 1;
        modification: 2;
        deletion: 3;
    }
    export type UpdateOperations = keyof UpdateOperations$Enum;
    export interface UpdateStatus$Enum {
        controlOk: 1;
        inProgress: 2;
        ended: 3;
        notApplicable: 4;
        error: 5;
        endedWithWarnings: 6;
    }
    export type UpdateStatus = keyof UpdateStatus$Enum;
    export interface UpdateType$Enum {
        standard: 1;
        hotfix: 2;
        specific: 3;
        addOn: 4;
        internal: 5;
    }
    export type UpdateType = keyof UpdateType$Enum;
    export interface UpdatedDescription$Enum {
        lineMsgUpdated: 1;
        line2: 2;
    }
    export type UpdatedDescription = keyof UpdatedDescription$Enum;
    export interface UpdatingType$Enum {
        incremental: 1;
        cancelsAndReplaces: 2;
        incrementalAudit: 3;
    }
    export type UpdatingType = keyof UpdatingType$Enum;
    export interface UrlLocation$Enum {
        worldWideWeb: 1;
        publicFolder: 2;
        currentFolder: 3;
    }
    export type UrlLocation = keyof UrlLocation$Enum;
    export interface UserAccessType$Enum {
        noAccess: 1;
        inquiry: 2;
        change: 3;
    }
    export type UserAccessType = keyof UserAccessType$Enum;
    export interface UserFunctionsEnum$Enum {
        salesEngineer: 1;
        teleSales: 2;
        salesDirector: 3;
        customerSupport: 4;
        other: 5;
    }
    export type UserFunctionsEnum = keyof UserFunctionsEnum$Enum;
    export interface UserStatus$Enum {
        permanent: 1;
        temporary: 2;
        partTime: 3;
    }
    export type UserStatus = keyof UserStatus$Enum;
    export interface Utilities$Enum {
        singleUser: 1;
        noLock: 2;
        singleModule: 3;
    }
    export type Utilities = keyof Utilities$Enum;
    export interface UtilityExecution$Enum {
        executedAtTheStart: 1;
        executedAtTheEnd: 2;
        deferredExecution: 3;
        inactive: 4;
    }
    export type UtilityExecution = keyof UtilityExecution$Enum;
    export interface UtilityLaunchStatus$Enum {
        toLaunch: 1;
        launched: 2;
        inactive: 3;
        error: 4;
    }
    export type UtilityLaunchStatus = keyof UtilityLaunchStatus$Enum;
    export interface ValidationType7813$Enum {
        free: 1;
        complete: 2;
        additionalLanguage: 3;
    }
    export type ValidationType7813 = keyof ValidationType7813$Enum;
    export interface ValidationType7829$Enum {
        list: 1;
        all: 2;
        substituteValue3: 3;
    }
    export type ValidationType7829 = keyof ValidationType7829$Enum;
    export interface ValidityType$Enum {
        validated: 1;
        notValidated: 2;
        all: 3;
    }
    export type ValidityType = keyof ValidityType$Enum;
    export interface ValueType$Enum {
        constant: 1;
        fieldToken: 2;
        webField: 3;
        webFieldMandat: 4;
        accessCode: 5;
        entry: 6;
        block: 7;
    }
    export type ValueType = keyof ValueType$Enum;
    export interface Verbs$Enum {
        get: 1;
        head: 2;
        post: 3;
        options: 4;
        connect: 5;
        trace: 6;
        put: 7;
        delete: 8;
    }
    export type Verbs = keyof Verbs$Enum;
    export interface VitalRelationships$Enum {
        none: 1;
        vitalParent: 2;
        vitalChild: 3;
    }
    export type VitalRelationships = keyof VitalRelationships$Enum;
    export interface VocabularyValidationOptions$Enum {
        currentVersion: 1;
        standardVersion: 2;
    }
    export type VocabularyValidationOptions = keyof VocabularyValidationOptions$Enum;
    export interface WebServiceElement$Enum {
        mask: 1;
        element: 2;
        group: 3;
        table: 4;
    }
    export type WebServiceElement = keyof WebServiceElement$Enum;
    export interface WebServicesMessageSeverity$Enum {
        message: 1;
        warning: 2;
        error: 3;
        ok: 4;
    }
    export type WebServicesMessageSeverity = keyof WebServicesMessageSeverity$Enum;
    export interface WebServicesType$Enum {
        object: 1;
        subProgram: 2;
    }
    export type WebServicesType = keyof WebServicesType$Enum;
    export interface WebSiteFieldType$Enum {
        text: 1;
        integer: 2;
        decimal: 3;
        currency: 4;
        date: 5;
        imageAccess: 6;
        attachmentAccess: 7;
        localMenu: 8;
        flash: 9;
    }
    export type WebSiteFieldType = keyof WebSiteFieldType$Enum;
    export interface WebSiteType$Enum {
        none: 1;
        webSites: 2;
        webPages: 3;
        webSiteProfiles: 4;
        fieldTokens: 5;
        entity: 6;
        blockTokens: 7;
        conditionedBlockTokens: 8;
        webAction: 9;
        dynamicLinks: 10;
        specialFieldTokens: 11;
        webMessage: 12;
        interface: 13;
        advancedParam: 14;
        listOfValues: 15;
    }
    export type WebSiteType = keyof WebSiteType$Enum;
    export interface WhereUsed$Enum {
        substituteValue1: 1;
        substituteValue2: 2;
        substituteValue3: 3;
    }
    export type WhereUsed = keyof WhereUsed$Enum;
    export interface WindowType923$Enum {
        miscellaneous: 1;
        object: 2;
        inquiry: 3;
        inquiryCriteria: 4;
        selectionTable: 5;
    }
    export type WindowType923 = keyof WindowType923$Enum;
    export interface WindowType$Enum {
        fullScreen: 1;
        dialogBox: 2;
        messageBox: 3;
        selecting: 4;
    }
    export type WindowType = keyof WindowType$Enum;
    export interface WindowTypes$Enum {
        invalidWindows: 1;
        timeStampInferiorTo: 2;
        all: 3;
        windowsPendingValidation: 4;
    }
    export type WindowTypes = keyof WindowTypes$Enum;
    export interface WorkflowStatus$Enum {
        none: 1;
        toProcess: 2;
        processed: 3;
    }
    export type WorkflowStatus = keyof WorkflowStatus$Enum;
    export interface X3Products$Enum {
        all: 1;
        supervisor: 2;
        x3: 3;
        geode: 4;
        payroll: 5;
    }
    export type X3Products = keyof X3Products$Enum;
    export interface XslType$Enum {
        miscellaneous: 1;
        planning: 2;
        bom: 3;
        radar: 4;
    }
    export type XslType = keyof XslType$Enum;
    export interface Access extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        access: string;
        description: string;
        description1: string;
    }
    export interface AccessInput extends ClientNodeInput {
        access?: string;
        description?: string;
        description1?: string;
    }
    export interface AccessBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        access: string;
        description: string;
        description1: string;
    }
    export interface Access$Operations {
        query: QueryOperation<Access>;
        read: ReadOperation<Access>;
        aggregate: {
            read: AggregateReadOperation<Access>;
            query: AggregateQueryOperation<Access>;
        };
        getDefaults: GetDefaultsOperation<Access>;
    }
    export interface ActionParameter extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
    }
    export interface ActionParameterInput extends ClientNodeInput {
        code?: string;
    }
    export interface ActionParameterBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
    }
    export interface ActionParameter$Operations {
        query: QueryOperation<ActionParameter>;
        read: ReadOperation<ActionParameter>;
        aggregate: {
            read: AggregateReadOperation<ActionParameter>;
            query: AggregateQueryOperation<ActionParameter>;
        };
        getDefaults: GetDefaultsOperation<ActionParameter>;
    }
    export interface ActivityCode extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        screenSize: integer;
        databaseMinimumSize: integer;
        maximumSize: integer;
        activeFlag: boolean;
        description: integer;
        module: ModuleTable;
        sequence: integer;
        order: integer;
        type: TypesOfActivityCode;
        dependency: TypeOfDependency;
        activityCode: ActivityCode;
        formula: string;
        description1: string;
    }
    export interface ActivityCodeInput extends ClientNodeInput {
        code?: string;
        screenSize?: integer | string;
        databaseMinimumSize?: integer | string;
        maximumSize?: integer | string;
        activeFlag?: boolean | string;
        description?: integer | string;
        module?: ModuleTable;
        sequence?: integer | string;
        order?: integer | string;
        type?: TypesOfActivityCode;
        dependency?: TypeOfDependency;
        activityCode?: string;
        formula?: string;
        description1?: string;
    }
    export interface ActivityCodeBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        screenSize: integer;
        databaseMinimumSize: integer;
        maximumSize: integer;
        activeFlag: boolean;
        description: integer;
        module: ModuleTable;
        sequence: integer;
        order: integer;
        type: TypesOfActivityCode;
        dependency: TypeOfDependency;
        activityCode: ActivityCode;
        formula: string;
        description1: string;
    }
    export interface ActivityCode$Lookups {
        activityCode: QueryOperation<ActivityCode>;
    }
    export interface ActivityCode$Operations {
        query: QueryOperation<ActivityCode>;
        read: ReadOperation<ActivityCode>;
        aggregate: {
            read: AggregateReadOperation<ActivityCode>;
            query: AggregateQueryOperation<ActivityCode>;
        };
        lookups(dataOrId: string | { data: ActivityCodeInput }): ActivityCode$Lookups;
        getDefaults: GetDefaultsOperation<ActivityCode>;
    }
    export interface Company extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        name: string;
        shortName: string;
        isLegalCompany: boolean;
        legislation: MiscellaneousTable;
        mainSite: Site;
        identificationNumber: string;
        standardIndustrialClassificationCode: string;
        uniqueIdentificationNumber: string;
        legalForm: string;
        analyticalDimension: string;
        registredCapital: string;
        consolidation: string;
        divisionCode: string;
        europeanUnionVatNumber: string;
        firstFiscalYear: string;
        sector1: MiscellaneousTable;
        sector2: MiscellaneousTable;
        additionalNumber: integer;
        federalState: MiscellaneousTable;
        isRetention: boolean;
        isCollectionAgent: boolean;
        rexNumber: MiscellaneousTable;
        eoriNumber: string;
        subjectToTax: boolean;
        logo: Image;
    }
    export interface CompanyInput extends ClientNodeInput {
        code?: string;
        name?: string;
        shortName?: string;
        isLegalCompany?: boolean | string;
        legislation?: string;
        mainSite?: string;
        identificationNumber?: string;
        standardIndustrialClassificationCode?: string;
        uniqueIdentificationNumber?: string;
        legalForm?: string;
        analyticalDimension?: string;
        registredCapital?: decimal | string;
        consolidation?: string;
        divisionCode?: string;
        europeanUnionVatNumber?: string;
        firstFiscalYear?: string;
        sector1?: string;
        sector2?: string;
        additionalNumber?: integer | string;
        federalState?: string;
        isRetention?: boolean | string;
        isCollectionAgent?: boolean | string;
        rexNumber?: string;
        eoriNumber?: string;
        subjectToTax?: boolean | string;
        logo?: string;
    }
    export interface CompanyBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        name: string;
        shortName: string;
        isLegalCompany: boolean;
        legislation: MiscellaneousTable;
        mainSite: Site;
        identificationNumber: string;
        standardIndustrialClassificationCode: string;
        uniqueIdentificationNumber: string;
        legalForm: string;
        analyticalDimension: string;
        registredCapital: string;
        consolidation: string;
        divisionCode: string;
        europeanUnionVatNumber: string;
        firstFiscalYear: string;
        sector1: MiscellaneousTable;
        sector2: MiscellaneousTable;
        additionalNumber: integer;
        federalState: MiscellaneousTable;
        isRetention: boolean;
        isCollectionAgent: boolean;
        rexNumber: MiscellaneousTable;
        eoriNumber: string;
        subjectToTax: boolean;
        logo: Image;
    }
    export interface Company$Lookups {
        legislation: QueryOperation<MiscellaneousTable>;
        mainSite: QueryOperation<Site>;
        sector1: QueryOperation<MiscellaneousTable>;
        sector2: QueryOperation<MiscellaneousTable>;
        federalState: QueryOperation<MiscellaneousTable>;
        rexNumber: QueryOperation<MiscellaneousTable>;
        logo: QueryOperation<Image>;
    }
    export interface Company$Operations {
        query: QueryOperation<Company>;
        read: ReadOperation<Company>;
        aggregate: {
            read: AggregateReadOperation<Company>;
            query: AggregateQueryOperation<Company>;
        };
        lookups(dataOrId: string | { data: CompanyInput }): Company$Lookups;
        getDefaults: GetDefaultsOperation<Company>;
    }
    export interface Destination extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        description: string;
        shortDescription: string;
        isActive: boolean;
        accessCode: Access;
        destination: DestinationTypes;
        destinationFile: string;
        server: string;
        printerName: string;
        driver: string;
        port: string;
        pageOrientation: Orientation;
        printerType: PrinterType;
        numberOfCopies: integer;
        isAssembledCopies: boolean;
        orientation: integer;
    }
    export interface DestinationInput extends ClientNodeInput {
        code?: string;
        description?: string;
        shortDescription?: string;
        isActive?: boolean | string;
        accessCode?: string;
        destination?: DestinationTypes;
        destinationFile?: string;
        server?: string;
        printerName?: string;
        driver?: string;
        port?: string;
        pageOrientation?: Orientation;
        printerType?: PrinterType;
        numberOfCopies?: integer | string;
        isAssembledCopies?: boolean | string;
        orientation?: integer | string;
    }
    export interface DestinationBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        description: string;
        shortDescription: string;
        isActive: boolean;
        accessCode: Access;
        destination: DestinationTypes;
        destinationFile: string;
        server: string;
        printerName: string;
        driver: string;
        port: string;
        pageOrientation: Orientation;
        printerType: PrinterType;
        numberOfCopies: integer;
        isAssembledCopies: boolean;
        orientation: integer;
    }
    export interface Destination$Lookups {
        accessCode: QueryOperation<Access>;
    }
    export interface Destination$Operations {
        query: QueryOperation<Destination>;
        read: ReadOperation<Destination>;
        aggregate: {
            read: AggregateReadOperation<Destination>;
            query: AggregateQueryOperation<Destination>;
        };
        lookups(dataOrId: string | { data: DestinationInput }): Destination$Lookups;
        getDefaults: GetDefaultsOperation<Destination>;
    }
    export interface FunctionActions extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        internal: string;
        value: string;
        parameter: ActionParameter;
    }
    export interface FunctionActionsInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        internal?: string;
        value?: string;
        parameter?: string;
    }
    export interface FunctionActionsBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        internal: string;
        value: string;
        parameter: ActionParameter;
    }
    export interface FunctionActions$Lookups {
        parameter: QueryOperation<ActionParameter>;
    }
    export interface FunctionActions$Operations {
        query: QueryOperation<FunctionActions>;
        read: ReadOperation<FunctionActions>;
        aggregate: {
            read: AggregateReadOperation<FunctionActions>;
            query: AggregateQueryOperation<FunctionActions>;
        };
        lookups(dataOrId: string | { data: FunctionActionsInput }): FunctionActions$Lookups;
        getDefaults: GetDefaultsOperation<FunctionActions>;
    }
    export interface FunctionOptions extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        internal: string;
        code: string;
        activityCode: ActivityCode;
        title: integer;
        function: Function;
    }
    export interface FunctionOptionsInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        internal?: string;
        code?: string;
        activityCode?: string;
        title?: integer | string;
        function?: string;
    }
    export interface FunctionOptionsBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        internal: string;
        code: string;
        activityCode: ActivityCode;
        title: integer;
        function: Function;
    }
    export interface FunctionOptions$Lookups {
        activityCode: QueryOperation<ActivityCode>;
        function: QueryOperation<Function>;
    }
    export interface FunctionOptions$Operations {
        query: QueryOperation<FunctionOptions>;
        read: ReadOperation<FunctionOptions>;
        aggregate: {
            read: AggregateReadOperation<FunctionOptions>;
            query: AggregateQueryOperation<FunctionOptions>;
        };
        lookups(dataOrId: string | { data: FunctionOptionsInput }): FunctionOptions$Lookups;
        getDefaults: GetDefaultsOperation<FunctionOptions>;
    }
    export interface FunctionVariables extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        internal: string;
        activityCode: ActivityCode;
        value: string;
        variable: string;
    }
    export interface FunctionVariablesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        internal?: string;
        activityCode?: string;
        value?: string;
        variable?: string;
    }
    export interface FunctionVariablesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        internal: string;
        activityCode: ActivityCode;
        value: string;
        variable: string;
    }
    export interface FunctionVariables$Lookups {
        activityCode: QueryOperation<ActivityCode>;
    }
    export interface FunctionVariables$Operations {
        query: QueryOperation<FunctionVariables>;
        read: ReadOperation<FunctionVariables>;
        aggregate: {
            read: AggregateReadOperation<FunctionVariables>;
            query: AggregateQueryOperation<FunctionVariables>;
        };
        lookups(dataOrId: string | { data: FunctionVariablesInput }): FunctionVariables$Lookups;
        getDefaults: GetDefaultsOperation<FunctionVariables>;
    }
    export interface Function extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        internal: string;
        entryHelp: integer;
        activityCode: ActivityCode;
        module: ModuleTable;
        external: string;
        number: integer;
        menuTitle: integer;
        parentMenu: Function;
        description: integer;
        noOfOptions: integer;
        rowInMenu: integer;
        menuProcess: string;
        accessTypeObject: boolean;
        numberOfVariables: integer;
        entryPoints: string;
        authorizationSite: boolean;
        single: boolean;
        actions: ClientCollection<FunctionActions>;
        options: ClientCollection<FunctionOptions>;
        variables: ClientCollection<FunctionVariables>;
    }
    export interface FunctionInput extends ClientNodeInput {
        internal?: string;
        entryHelp?: integer | string;
        activityCode?: string;
        module?: ModuleTable;
        external?: string;
        number?: integer | string;
        menuTitle?: integer | string;
        parentMenu?: string;
        description?: integer | string;
        noOfOptions?: integer | string;
        rowInMenu?: integer | string;
        menuProcess?: string;
        accessTypeObject?: boolean | string;
        numberOfVariables?: integer | string;
        entryPoints?: string;
        authorizationSite?: boolean | string;
        single?: boolean | string;
        actions?: Partial<FunctionActionsInput>[];
        options?: Partial<FunctionOptionsInput>[];
        variables?: Partial<FunctionVariablesInput>[];
    }
    export interface FunctionBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        internal: string;
        entryHelp: integer;
        activityCode: ActivityCode;
        module: ModuleTable;
        external: string;
        number: integer;
        menuTitle: integer;
        parentMenu: Function;
        description: integer;
        noOfOptions: integer;
        rowInMenu: integer;
        menuProcess: string;
        accessTypeObject: boolean;
        numberOfVariables: integer;
        entryPoints: string;
        authorizationSite: boolean;
        single: boolean;
        actions: ClientCollection<FunctionActionsBinding>;
        options: ClientCollection<FunctionOptionsBinding>;
        variables: ClientCollection<FunctionVariablesBinding>;
    }
    export interface Function$Lookups {
        activityCode: QueryOperation<ActivityCode>;
        parentMenu: QueryOperation<Function>;
    }
    export interface Function$Operations {
        query: QueryOperation<Function>;
        read: ReadOperation<Function>;
        aggregate: {
            read: AggregateReadOperation<Function>;
            query: AggregateQueryOperation<Function>;
        };
        lookups(dataOrId: string | { data: FunctionInput }): Function$Lookups;
        getDefaults: GetDefaultsOperation<Function>;
    }
    export interface FunctionalProfilePerSite extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        profile: UserFunctionProfile;
        function: Function;
        options: string;
    }
    export interface FunctionalProfilePerSiteInput extends ClientNodeInput {
        site?: string;
        profile?: string;
        function?: string;
        options?: string;
    }
    export interface FunctionalProfilePerSiteBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        profile: UserFunctionProfile;
        function: Function;
        options: string;
    }
    export interface FunctionalProfilePerSite$Lookups {
        site: QueryOperation<Site>;
        profile: QueryOperation<UserFunctionProfile>;
        function: QueryOperation<Function>;
    }
    export interface FunctionalProfilePerSite$Operations {
        query: QueryOperation<FunctionalProfilePerSite>;
        read: ReadOperation<FunctionalProfilePerSite>;
        aggregate: {
            read: AggregateReadOperation<FunctionalProfilePerSite>;
            query: AggregateQueryOperation<FunctionalProfilePerSite>;
        };
        lookups(dataOrId: string | { data: FunctionalProfilePerSiteInput }): FunctionalProfilePerSite$Lookups;
        getDefaults: GetDefaultsOperation<FunctionalProfilePerSite>;
    }
    export interface FunctionalProfile extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        profile: UserFunctionProfile;
        function: Function;
        siteGrouping: Company;
        menu: RegroupingSite;
        access: boolean;
        options: string;
    }
    export interface FunctionalProfileInput extends ClientNodeInput {
        profile?: string;
        function?: string;
        siteGrouping?: string;
        menu?: RegroupingSite;
        access?: boolean | string;
        options?: string;
    }
    export interface FunctionalProfileBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        profile: UserFunctionProfile;
        function: Function;
        siteGrouping: Company;
        menu: RegroupingSite;
        access: boolean;
        options: string;
    }
    export interface FunctionalProfile$Lookups {
        profile: QueryOperation<UserFunctionProfile>;
        function: QueryOperation<Function>;
        siteGrouping: QueryOperation<Company>;
    }
    export interface FunctionalProfile$Operations {
        query: QueryOperation<FunctionalProfile>;
        read: ReadOperation<FunctionalProfile>;
        aggregate: {
            read: AggregateReadOperation<FunctionalProfile>;
            query: AggregateQueryOperation<FunctionalProfile>;
        };
        lookups(dataOrId: string | { data: FunctionalProfileInput }): FunctionalProfile$Lookups;
        getDefaults: GetDefaultsOperation<FunctionalProfile>;
    }
    export interface GeneralParameterSelectableValues extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        code: string;
        value: string;
    }
    export interface GeneralParameterSelectableValuesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        code?: string;
        value?: string;
    }
    export interface GeneralParameterSelectableValuesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        code: string;
        value: string;
    }
    export interface GeneralParameterSelectableValues$Operations {
        query: QueryOperation<GeneralParameterSelectableValues>;
        read: ReadOperation<GeneralParameterSelectableValues>;
        aggregate: {
            read: AggregateReadOperation<GeneralParameterSelectableValues>;
            query: AggregateQueryOperation<GeneralParameterSelectableValues>;
        };
        getDefaults: GetDefaultsOperation<GeneralParameterSelectableValues>;
    }
    export interface GeneralParameter extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        chapter: MiscellaneousTable;
        group: MiscellaneousTable;
        description: integer;
        activityCode: ActivityCode;
        valueType: FieldType;
        isEditable: boolean;
        localMenu: integer;
        definitionLevel: ParameterDefinitionLevel;
        isOffValue: boolean;
        processing: string;
        selectionOptions: string;
        canUserUpdate: boolean;
        sequence: integer;
        access: Access;
        folderValue: boolean;
        modifyingCondition: string;
        selectableValues: ClientCollection<GeneralParameterSelectableValues>;
    }
    export interface GeneralParameterInput extends ClientNodeInput {
        code?: string;
        chapter?: string;
        group?: string;
        description?: integer | string;
        activityCode?: string;
        valueType?: FieldType;
        isEditable?: boolean | string;
        localMenu?: integer | string;
        definitionLevel?: ParameterDefinitionLevel;
        isOffValue?: boolean | string;
        processing?: string;
        selectionOptions?: string;
        canUserUpdate?: boolean | string;
        sequence?: integer | string;
        access?: string;
        folderValue?: boolean | string;
        modifyingCondition?: string;
        selectableValues?: Partial<GeneralParameterSelectableValuesInput>[];
    }
    export interface GeneralParameterBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        chapter: MiscellaneousTable;
        group: MiscellaneousTable;
        description: integer;
        activityCode: ActivityCode;
        valueType: FieldType;
        isEditable: boolean;
        localMenu: integer;
        definitionLevel: ParameterDefinitionLevel;
        isOffValue: boolean;
        processing: string;
        selectionOptions: string;
        canUserUpdate: boolean;
        sequence: integer;
        access: Access;
        folderValue: boolean;
        modifyingCondition: string;
        selectableValues: ClientCollection<GeneralParameterSelectableValuesBinding>;
    }
    export interface GeneralParameter$Lookups {
        chapter: QueryOperation<MiscellaneousTable>;
        group: QueryOperation<MiscellaneousTable>;
        activityCode: QueryOperation<ActivityCode>;
        access: QueryOperation<Access>;
    }
    export interface GeneralParameter$Operations {
        query: QueryOperation<GeneralParameter>;
        read: ReadOperation<GeneralParameter>;
        aggregate: {
            read: AggregateReadOperation<GeneralParameter>;
            query: AggregateQueryOperation<GeneralParameter>;
        };
        lookups(dataOrId: string | { data: GeneralParameterInput }): GeneralParameter$Lookups;
        getDefaults: GetDefaultsOperation<GeneralParameter>;
    }
    export interface GeneralParametersData extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        company: Company;
        siteOrLegislationCode: Site;
        value: string;
        defaultSetOfValues: MiscellaneousTable;
    }
    export interface GeneralParametersDataInput extends ClientNodeInput {
        code?: string;
        company?: string;
        siteOrLegislationCode?: string;
        value?: string;
        defaultSetOfValues?: string;
    }
    export interface GeneralParametersDataBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        company: Company;
        siteOrLegislationCode: Site;
        value: string;
        defaultSetOfValues: MiscellaneousTable;
    }
    export interface GeneralParametersData$Mutations {
        readParameterValueDate: Node$Operation<
            {
                parameters?: {
                    company: string;
                    site: string;
                    code: string;
                };
            },
            {
                value: string;
            }
        >;
        readParameterValueInteger: Node$Operation<
            {
                parameters?: {
                    company: string;
                    site: string;
                    code: string;
                };
            },
            {
                value: integer;
            }
        >;
        readParameterValueString: Node$Operation<
            {
                parameters?: {
                    company: string;
                    site: string;
                    code: string;
                };
            },
            {
                value: string;
            }
        >;
    }
    export interface GeneralParametersData$Lookups {
        company: QueryOperation<Company>;
        siteOrLegislationCode: QueryOperation<Site>;
        defaultSetOfValues: QueryOperation<MiscellaneousTable>;
    }
    export interface GeneralParametersData$Operations {
        query: QueryOperation<GeneralParametersData>;
        read: ReadOperation<GeneralParametersData>;
        aggregate: {
            read: AggregateReadOperation<GeneralParametersData>;
            query: AggregateQueryOperation<GeneralParametersData>;
        };
        mutations: GeneralParametersData$Mutations;
        lookups(dataOrId: string | { data: GeneralParametersDataInput }): GeneralParametersData$Lookups;
        getDefaults: GetDefaultsOperation<GeneralParametersData>;
    }
    export interface GenericPrintReport extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        reportName: string;
    }
    export interface GenericPrintReportInput extends ClientNodeInput {
        reportName?: string;
    }
    export interface GenericPrintReportBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        reportName: string;
    }
    export interface GenericPrintReport$Mutations {
        printReport: Node$Operation<
            {
                parameters?: {
                    reportName: string;
                    language: string;
                    destination: string;
                    parametersNames: string[];
                    parametersValues: string[];
                    errorCode: integer | string;
                };
            },
            {
                errorCode: integer;
            }
        >;
    }
    export interface GenericPrintReport$Operations {
        query: QueryOperation<GenericPrintReport>;
        read: ReadOperation<GenericPrintReport>;
        aggregate: {
            read: AggregateReadOperation<GenericPrintReport>;
            query: AggregateQueryOperation<GenericPrintReport>;
        };
        mutations: GenericPrintReport$Mutations;
        getDefaults: GetDefaultsOperation<GenericPrintReport>;
    }
    export interface Image extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        identifier1: string;
        identifier2: string;
        identifier3: string;
        fileName: string;
        data: BinaryStream;
        specialFileType: TypeOfNonStandardFile;
    }
    export interface ImageInput extends ClientNodeInput {
        code?: string;
        identifier1?: string;
        identifier2?: string;
        identifier3?: string;
        fileName?: string;
        data?: BinaryStream;
        specialFileType?: TypeOfNonStandardFile;
    }
    export interface ImageBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        identifier1: string;
        identifier2: string;
        identifier3: string;
        fileName: string;
        data: BinaryStream;
        specialFileType: TypeOfNonStandardFile;
    }
    export interface Image$Operations {
        query: QueryOperation<Image>;
        read: ReadOperation<Image>;
        aggregate: {
            read: AggregateReadOperation<Image>;
            query: AggregateQueryOperation<Image>;
        };
        getDefaults: GetDefaultsOperation<Image>;
    }
    export interface Language extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        conversion: AmountConversionIntoLetters;
        standardLanguage: boolean;
        iso: string;
        unicodeLanguage: boolean;
        connectionLanguage: boolean;
        backupLanguage: Language;
        shortDescription: string;
        description: string;
        primaryLanguage: Language;
    }
    export interface LanguageInput extends ClientNodeInput {
        code?: string;
        conversion?: AmountConversionIntoLetters;
        standardLanguage?: boolean | string;
        iso?: string;
        unicodeLanguage?: boolean | string;
        connectionLanguage?: boolean | string;
        backupLanguage?: string;
        shortDescription?: string;
        description?: string;
        primaryLanguage?: string;
    }
    export interface LanguageBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        conversion: AmountConversionIntoLetters;
        standardLanguage: boolean;
        iso: string;
        unicodeLanguage: boolean;
        connectionLanguage: boolean;
        backupLanguage: Language;
        shortDescription: string;
        description: string;
        primaryLanguage: Language;
    }
    export interface Language$Lookups {
        backupLanguage: QueryOperation<Language>;
        primaryLanguage: QueryOperation<Language>;
    }
    export interface Language$Operations {
        query: QueryOperation<Language>;
        read: ReadOperation<Language>;
        aggregate: {
            read: AggregateReadOperation<Language>;
            query: AggregateQueryOperation<Language>;
        };
        lookups(dataOrId: string | { data: LanguageInput }): Language$Lookups;
        getDefaults: GetDefaultsOperation<Language>;
    }
    export interface MiscellaneousTable extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        glossaryId: MiscellaneousTables;
        code: string;
        alpha1: string;
        alpha2: string;
        alpha3: string;
        alpha4: string;
        alpha5: string;
        alpha6: string;
        alpha7: string;
        alpha8: string;
        alpha9: string;
        alpha10: string;
        alpha11: string;
        alpha12: string;
        alpha13: string;
        alpha14: string;
        alpha15: string;
        numeric1: string;
        numeric2: string;
        numeric3: string;
        numeric4: string;
        numeric5: string;
        numeric6: string;
        numeric7: string;
        numeric8: string;
        numeric9: string;
        numeric10: string;
        numeric11: string;
        numeric12: string;
        numeric13: string;
        numeric14: string;
        numeric15: string;
        description: string;
        shortDescription: string;
        defaultValue: boolean;
        dependency: MiscellaneousTable;
        legislation: MiscellaneousTable;
        activeFlag: boolean;
    }
    export interface MiscellaneousTableInput extends ClientNodeInput {
        glossaryId?: integer | string;
        code?: string;
        alpha1?: string;
        alpha2?: string;
        alpha3?: string;
        alpha4?: string;
        alpha5?: string;
        alpha6?: string;
        alpha7?: string;
        alpha8?: string;
        alpha9?: string;
        alpha10?: string;
        alpha11?: string;
        alpha12?: string;
        alpha13?: string;
        alpha14?: string;
        alpha15?: string;
        numeric1?: decimal | string;
        numeric2?: decimal | string;
        numeric3?: decimal | string;
        numeric4?: decimal | string;
        numeric5?: decimal | string;
        numeric6?: decimal | string;
        numeric7?: decimal | string;
        numeric8?: decimal | string;
        numeric9?: decimal | string;
        numeric10?: decimal | string;
        numeric11?: decimal | string;
        numeric12?: decimal | string;
        numeric13?: decimal | string;
        numeric14?: decimal | string;
        numeric15?: decimal | string;
        description?: string;
        shortDescription?: string;
        defaultValue?: boolean | string;
        dependency?: string;
        legislation?: string;
        activeFlag?: boolean | string;
    }
    export interface MiscellaneousTableBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        glossaryId: MiscellaneousTables;
        code: string;
        alpha1: string;
        alpha2: string;
        alpha3: string;
        alpha4: string;
        alpha5: string;
        alpha6: string;
        alpha7: string;
        alpha8: string;
        alpha9: string;
        alpha10: string;
        alpha11: string;
        alpha12: string;
        alpha13: string;
        alpha14: string;
        alpha15: string;
        numeric1: string;
        numeric2: string;
        numeric3: string;
        numeric4: string;
        numeric5: string;
        numeric6: string;
        numeric7: string;
        numeric8: string;
        numeric9: string;
        numeric10: string;
        numeric11: string;
        numeric12: string;
        numeric13: string;
        numeric14: string;
        numeric15: string;
        description: string;
        shortDescription: string;
        defaultValue: boolean;
        dependency: MiscellaneousTable;
        legislation: MiscellaneousTable;
        activeFlag: boolean;
    }
    export interface MiscellaneousTable$Lookups {
        glossaryId: QueryOperation<MiscellaneousTables>;
        dependency: QueryOperation<MiscellaneousTable>;
        legislation: QueryOperation<MiscellaneousTable>;
    }
    export interface MiscellaneousTable$Operations {
        query: QueryOperation<MiscellaneousTable>;
        read: ReadOperation<MiscellaneousTable>;
        aggregate: {
            read: AggregateReadOperation<MiscellaneousTable>;
            query: AggregateQueryOperation<MiscellaneousTable>;
        };
        lookups(dataOrId: string | { data: MiscellaneousTableInput }): MiscellaneousTable$Lookups;
        getDefaults: GetDefaultsOperation<MiscellaneousTable>;
    }
    export interface MiscellaneousTables extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        glossaryId: integer;
        tableNumber: string;
        description: string;
        shortDescription: string;
        alpha1: string;
        type1: string;
        option1: string;
        alpha2: string;
        type2: string;
        option2: string;
        numeric1: string;
        type3: string;
        option3: string;
        numeric2: string;
        type4: string;
        option4: string;
        number: integer;
        activityCode: ActivityCode;
        access: Access;
        module: ModuleTable;
        dependency: MiscellaneousTables;
        modifiableLength: boolean;
        length: integer;
        companyFilter: boolean;
        legislationMandatory: boolean;
        filterLegislation: boolean;
        activeFlag: boolean;
    }
    export interface MiscellaneousTablesInput extends ClientNodeInput {
        glossaryId?: integer | string;
        tableNumber?: string;
        description?: string;
        shortDescription?: string;
        alpha1?: string;
        type1?: string;
        option1?: string;
        alpha2?: string;
        type2?: string;
        option2?: string;
        numeric1?: string;
        type3?: string;
        option3?: string;
        numeric2?: string;
        type4?: string;
        option4?: string;
        number?: integer | string;
        activityCode?: string;
        access?: string;
        module?: ModuleTable;
        dependency?: integer | string;
        modifiableLength?: boolean | string;
        length?: integer | string;
        companyFilter?: boolean | string;
        legislationMandatory?: boolean | string;
        filterLegislation?: boolean | string;
        activeFlag?: boolean | string;
    }
    export interface MiscellaneousTablesBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        glossaryId: integer;
        tableNumber: string;
        description: string;
        shortDescription: string;
        alpha1: string;
        type1: string;
        option1: string;
        alpha2: string;
        type2: string;
        option2: string;
        numeric1: string;
        type3: string;
        option3: string;
        numeric2: string;
        type4: string;
        option4: string;
        number: integer;
        activityCode: ActivityCode;
        access: Access;
        module: ModuleTable;
        dependency: MiscellaneousTables;
        modifiableLength: boolean;
        length: integer;
        companyFilter: boolean;
        legislationMandatory: boolean;
        filterLegislation: boolean;
        activeFlag: boolean;
    }
    export interface MiscellaneousTables$Lookups {
        activityCode: QueryOperation<ActivityCode>;
        access: QueryOperation<Access>;
        dependency: QueryOperation<MiscellaneousTables>;
    }
    export interface MiscellaneousTables$Operations {
        query: QueryOperation<MiscellaneousTables>;
        read: ReadOperation<MiscellaneousTables>;
        aggregate: {
            read: AggregateReadOperation<MiscellaneousTables>;
            query: AggregateQueryOperation<MiscellaneousTables>;
        };
        lookups(dataOrId: string | { data: MiscellaneousTablesInput }): MiscellaneousTables$Lookups;
        getDefaults: GetDefaultsOperation<MiscellaneousTables>;
    }
    export interface SiteUnavailabilityDays extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        code: string;
        isUnavailable: boolean;
    }
    export interface SiteUnavailabilityDaysInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        code?: string;
        isUnavailable?: boolean | string;
    }
    export interface SiteUnavailabilityDaysBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        code: string;
        isUnavailable: boolean;
    }
    export interface SiteUnavailabilityDays$Operations {
        query: QueryOperation<SiteUnavailabilityDays>;
        read: ReadOperation<SiteUnavailabilityDays>;
        aggregate: {
            read: AggregateReadOperation<SiteUnavailabilityDays>;
            query: AggregateQueryOperation<SiteUnavailabilityDays>;
        };
        getDefaults: GetDefaultsOperation<SiteUnavailabilityDays>;
    }
    export interface Site extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        name: string;
        shortName: string;
        identificationNumber: string;
        standardIndustrialClassificationCode: string;
        isManufacturing: boolean;
        isSales: boolean;
        isPurchasing: boolean;
        isStockSite: boolean;
        isAccounting: boolean;
        financialSite: Site;
        legalCompany: Company;
        legislation: MiscellaneousTable;
        analyticalDimension: string;
        isCityInterior: string;
        eoriNumber: string;
        unavailabilityCode: string;
        unavailabilityDays: ClientCollection<SiteUnavailabilityDays>;
    }
    export interface SiteInput extends ClientNodeInput {
        code?: string;
        name?: string;
        shortName?: string;
        identificationNumber?: string;
        standardIndustrialClassificationCode?: string;
        isManufacturing?: boolean | string;
        isSales?: boolean | string;
        isPurchasing?: boolean | string;
        isStockSite?: boolean | string;
        isAccounting?: boolean | string;
        financialSite?: string;
        legalCompany?: string;
        legislation?: string;
        analyticalDimension?: string;
        isCityInterior?: string;
        eoriNumber?: string;
        unavailabilityCode?: string;
        unavailabilityDays?: Partial<SiteUnavailabilityDaysInput>[];
    }
    export interface SiteBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        name: string;
        shortName: string;
        identificationNumber: string;
        standardIndustrialClassificationCode: string;
        isManufacturing: boolean;
        isSales: boolean;
        isPurchasing: boolean;
        isStockSite: boolean;
        isAccounting: boolean;
        financialSite: Site;
        legalCompany: Company;
        legislation: MiscellaneousTable;
        analyticalDimension: string;
        isCityInterior: string;
        eoriNumber: string;
        unavailabilityCode: string;
        unavailabilityDays: ClientCollection<SiteUnavailabilityDaysBinding>;
    }
    export interface Site$Lookups {
        financialSite: QueryOperation<Site>;
        legalCompany: QueryOperation<Company>;
        legislation: QueryOperation<MiscellaneousTable>;
    }
    export interface Site$Operations {
        query: QueryOperation<Site>;
        read: ReadOperation<Site>;
        aggregate: {
            read: AggregateReadOperation<Site>;
            query: AggregateQueryOperation<Site>;
        };
        lookups(dataOrId: string | { data: SiteInput }): Site$Lookups;
        getDefaults: GetDefaultsOperation<Site>;
    }
    export interface SyracusMethod extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        profession: string;
        description: string;
        menuProfile: UserProfileMenu;
        functionProfile: UserFunctionProfile;
        biUserProfile: string;
        safeX3WasProfile: string;
    }
    export interface SyracusMethodInput extends ClientNodeInput {
        profession?: string;
        description?: string;
        menuProfile?: integer | string;
        functionProfile?: string;
        biUserProfile?: string;
        safeX3WasProfile?: string;
    }
    export interface SyracusMethodBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        profession: string;
        description: string;
        menuProfile: UserProfileMenu;
        functionProfile: UserFunctionProfile;
        biUserProfile: string;
        safeX3WasProfile: string;
    }
    export interface SyracusMethod$Lookups {
        menuProfile: QueryOperation<UserProfileMenu>;
        functionProfile: QueryOperation<UserFunctionProfile>;
    }
    export interface SyracusMethod$Operations {
        query: QueryOperation<SyracusMethod>;
        read: ReadOperation<SyracusMethod>;
        aggregate: {
            read: AggregateReadOperation<SyracusMethod>;
            query: AggregateQueryOperation<SyracusMethod>;
        };
        lookups(dataOrId: string | { data: SyracusMethodInput }): SyracusMethod$Lookups;
        getDefaults: GetDefaultsOperation<SyracusMethod>;
    }
    export interface UserAccess extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        profile: UserFunctionProfile;
        access: Access;
        user: User;
        inquiry: boolean;
        execution: boolean;
        modification: boolean;
    }
    export interface UserAccessInput extends ClientNodeInput {
        profile?: string;
        access?: string;
        user?: string;
        inquiry?: boolean | string;
        execution?: boolean | string;
        modification?: boolean | string;
    }
    export interface UserAccessBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        profile: UserFunctionProfile;
        access: Access;
        user: User;
        inquiry: boolean;
        execution: boolean;
        modification: boolean;
    }
    export interface UserAccess$Lookups {
        profile: QueryOperation<UserFunctionProfile>;
        access: QueryOperation<Access>;
        user: QueryOperation<User>;
    }
    export interface UserAccess$Operations {
        query: QueryOperation<UserAccess>;
        read: ReadOperation<UserAccess>;
        aggregate: {
            read: AggregateReadOperation<UserAccess>;
            query: AggregateQueryOperation<UserAccess>;
        };
        lookups(dataOrId: string | { data: UserAccessInput }): UserAccess$Lookups;
        getDefaults: GetDefaultsOperation<UserAccess>;
    }
    export interface UserFunctionProfileUserProfileDefaultSites extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        profile: string;
        site: Site;
    }
    export interface UserFunctionProfileUserProfileDefaultSitesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        profile?: string;
        site?: string;
    }
    export interface UserFunctionProfileUserProfileDefaultSitesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        profile: string;
        site: Site;
    }
    export interface UserFunctionProfileUserProfileDefaultSites$Lookups {
        site: QueryOperation<Site>;
    }
    export interface UserFunctionProfileUserProfileDefaultSites$Operations {
        query: QueryOperation<UserFunctionProfileUserProfileDefaultSites>;
        read: ReadOperation<UserFunctionProfileUserProfileDefaultSites>;
        aggregate: {
            read: AggregateReadOperation<UserFunctionProfileUserProfileDefaultSites>;
            query: AggregateQueryOperation<UserFunctionProfileUserProfileDefaultSites>;
        };
        lookups(
            dataOrId: string | { data: UserFunctionProfileUserProfileDefaultSitesInput },
        ): UserFunctionProfileUserProfileDefaultSites$Lookups;
        getDefaults: GetDefaultsOperation<UserFunctionProfileUserProfileDefaultSites>;
    }
    export interface UserFunctionProfile extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        profile: string;
        description: string;
        allAccessAllowed: boolean;
        deferredPrint: boolean;
        reportFilters: string;
        allAuthorizedFunctions: boolean;
        fixedDashboard: boolean;
        userProfileDefaultSites: ClientCollection<UserFunctionProfileUserProfileDefaultSites>;
    }
    export interface UserFunctionProfileInput extends ClientNodeInput {
        profile?: string;
        description?: string;
        allAccessAllowed?: boolean | string;
        deferredPrint?: boolean | string;
        reportFilters?: string;
        allAuthorizedFunctions?: boolean | string;
        fixedDashboard?: boolean | string;
        userProfileDefaultSites?: Partial<UserFunctionProfileUserProfileDefaultSitesInput>[];
    }
    export interface UserFunctionProfileBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        profile: string;
        description: string;
        allAccessAllowed: boolean;
        deferredPrint: boolean;
        reportFilters: string;
        allAuthorizedFunctions: boolean;
        fixedDashboard: boolean;
        userProfileDefaultSites: ClientCollection<UserFunctionProfileUserProfileDefaultSitesBinding>;
    }
    export interface UserFunctionProfile$Operations {
        query: QueryOperation<UserFunctionProfile>;
        read: ReadOperation<UserFunctionProfile>;
        aggregate: {
            read: AggregateReadOperation<UserFunctionProfile>;
            query: AggregateQueryOperation<UserFunctionProfile>;
        };
        getDefaults: GetDefaultsOperation<UserFunctionProfile>;
    }
    export interface UserFunctions extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        code: string;
        function: Function;
        parameter: string;
    }
    export interface UserFunctionsInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        code?: string;
        function?: string;
        parameter?: string;
    }
    export interface UserFunctionsBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        code: string;
        function: Function;
        parameter: string;
    }
    export interface UserFunctions$Lookups {
        function: QueryOperation<Function>;
    }
    export interface UserFunctions$Operations {
        query: QueryOperation<UserFunctions>;
        read: ReadOperation<UserFunctions>;
        aggregate: {
            read: AggregateReadOperation<UserFunctions>;
            query: AggregateQueryOperation<UserFunctions>;
        };
        lookups(dataOrId: string | { data: UserFunctionsInput }): UserFunctions$Lookups;
        getDefaults: GetDefaultsOperation<UserFunctions>;
    }
    export interface UserParameterValue extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        description: string;
        user: User;
        value: string;
        defaultSetOfValues: MiscellaneousTable;
    }
    export interface UserParameterValueInput extends ClientNodeInput {
        description?: string;
        user?: string;
        value?: string;
        defaultSetOfValues?: string;
    }
    export interface UserParameterValueBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        description: string;
        user: User;
        value: string;
        defaultSetOfValues: MiscellaneousTable;
    }
    export interface UserParameterValue$Mutations {
        readByUserParameterValueDate: Node$Operation<
            {
                parameters?: {
                    code: string;
                    user: string;
                };
            },
            {
                value: string;
            }
        >;
        readByUserParameterValueInteger: Node$Operation<
            {
                parameters?: {
                    code: string;
                    user: string;
                };
            },
            {
                value: integer;
            }
        >;
        readByUserParameterValueString: Node$Operation<
            {
                parameters?: {
                    code: string;
                    user: string;
                };
            },
            {
                value: string;
            }
        >;
        readParameterValueDate: Node$Operation<
            {
                parameters?: {
                    code: string;
                };
            },
            {
                value: string;
            }
        >;
        readParameterValueInteger: Node$Operation<
            {
                parameters?: {
                    code: string;
                };
            },
            {
                value: integer;
            }
        >;
        readParameterValueString: Node$Operation<
            {
                parameters?: {
                    code: string;
                };
            },
            {
                value: string;
            }
        >;
        updateUserSiteDepositor: Node$Operation<
            {
                parameters?: {
                    user: string;
                    site: string;
                    depositor: string;
                    errorCode: integer | string;
                };
            },
            {
                errorCode: integer;
            }
        >;
    }
    export interface UserParameterValue$Lookups {
        user: QueryOperation<User>;
        defaultSetOfValues: QueryOperation<MiscellaneousTable>;
    }
    export interface UserParameterValue$Operations {
        query: QueryOperation<UserParameterValue>;
        read: ReadOperation<UserParameterValue>;
        aggregate: {
            read: AggregateReadOperation<UserParameterValue>;
            query: AggregateQueryOperation<UserParameterValue>;
        };
        mutations: UserParameterValue$Mutations;
        lookups(dataOrId: string | { data: UserParameterValueInput }): UserParameterValue$Lookups;
        getDefaults: GetDefaultsOperation<UserParameterValue>;
    }
    export interface UserProfileMenu extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        profile: string;
        module: ModuleTable;
        profileType: ProfileTypeFunction;
        memory: integer;
        profileDescription: string;
        startMenu: string;
    }
    export interface UserProfileMenuInput extends ClientNodeInput {
        profile?: string;
        module?: ModuleTable;
        profileType?: ProfileTypeFunction;
        memory?: integer | string;
        profileDescription?: string;
        startMenu?: string;
    }
    export interface UserProfileMenuBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        profile: string;
        module: ModuleTable;
        profileType: ProfileTypeFunction;
        memory: integer;
        profileDescription: string;
        startMenu: string;
    }
    export interface UserProfileMenu$Operations {
        query: QueryOperation<UserProfileMenu>;
        read: ReadOperation<UserProfileMenu>;
        aggregate: {
            read: AggregateReadOperation<UserProfileMenu>;
            query: AggregateQueryOperation<UserProfileMenu>;
        };
        getDefaults: GetDefaultsOperation<UserProfileMenu>;
    }
    export interface UserSupervisors extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        code: string;
        supervisor: User;
    }
    export interface UserSupervisorsInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        code?: string;
        supervisor?: string;
    }
    export interface UserSupervisorsBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        code: string;
        supervisor: User;
    }
    export interface UserSupervisors$Lookups {
        supervisor: QueryOperation<User>;
    }
    export interface UserSupervisors$Operations {
        query: QueryOperation<UserSupervisors>;
        read: ReadOperation<UserSupervisors>;
        aggregate: {
            read: AggregateReadOperation<UserSupervisors>;
            query: AggregateQueryOperation<UserSupervisors>;
        };
        lookups(dataOrId: string | { data: UserSupervisorsInput }): UserSupervisors$Lookups;
        getDefaults: GetDefaultsOperation<UserSupervisors>;
    }
    export interface UserUserDestinations extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        code: string;
        destination: Destination;
    }
    export interface UserUserDestinationsInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        code?: string;
        destination?: string;
    }
    export interface UserUserDestinationsBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        code: string;
        destination: Destination;
    }
    export interface UserUserDestinations$Lookups {
        destination: QueryOperation<Destination>;
    }
    export interface UserUserDestinations$Operations {
        query: QueryOperation<UserUserDestinations>;
        read: ReadOperation<UserUserDestinations>;
        aggregate: {
            read: AggregateReadOperation<UserUserDestinations>;
            query: AggregateQueryOperation<UserUserDestinations>;
        };
        lookups(dataOrId: string | { data: UserUserDestinationsInput }): UserUserDestinations$Lookups;
        getDefaults: GetDefaultsOperation<UserUserDestinations>;
    }
    export interface User extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        activeInSelec: boolean;
        name: string;
        nameDescription: string;
        profession: SyracusMethod;
        menuProfile: UserProfileMenu;
        functionProfile: UserFunctionProfile;
        email: string;
        login: string;
        allAccessCodes: boolean;
        externalUser: boolean;
        x3Connection: boolean;
        webServicesConnection: boolean;
        defaultBankId: string;
        access: Access;
        bankIdNumber: string;
        userModel: User;
        profile: string;
        image: Image;
        picture: BinaryStream;
        functions: ClientCollection<UserFunctions>;
        supervisors: ClientCollection<UserSupervisors>;
        userDestinations: ClientCollection<UserUserDestinations>;
    }
    export interface UserInput extends ClientNodeInput {
        code?: string;
        activeInSelec?: boolean | string;
        name?: string;
        nameDescription?: string;
        profession?: string;
        menuProfile?: integer | string;
        functionProfile?: string;
        email?: string;
        login?: string;
        allAccessCodes?: boolean | string;
        externalUser?: boolean | string;
        x3Connection?: boolean | string;
        webServicesConnection?: boolean | string;
        defaultBankId?: string;
        access?: string;
        bankIdNumber?: string;
        userModel?: string;
        profile?: string;
        image?: string;
        picture?: BinaryStream;
        functions?: Partial<UserFunctionsInput>[];
        supervisors?: Partial<UserSupervisorsInput>[];
        userDestinations?: Partial<UserUserDestinationsInput>[];
    }
    export interface UserBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        activeInSelec: boolean;
        name: string;
        nameDescription: string;
        profession: SyracusMethod;
        menuProfile: UserProfileMenu;
        functionProfile: UserFunctionProfile;
        email: string;
        login: string;
        allAccessCodes: boolean;
        externalUser: boolean;
        x3Connection: boolean;
        webServicesConnection: boolean;
        defaultBankId: string;
        access: Access;
        bankIdNumber: string;
        userModel: User;
        profile: string;
        image: Image;
        picture: BinaryStream;
        functions: ClientCollection<UserFunctionsBinding>;
        supervisors: ClientCollection<UserSupervisorsBinding>;
        userDestinations: ClientCollection<UserUserDestinationsBinding>;
    }
    export interface User$Lookups {
        profession: QueryOperation<SyracusMethod>;
        menuProfile: QueryOperation<UserProfileMenu>;
        functionProfile: QueryOperation<UserFunctionProfile>;
        access: QueryOperation<Access>;
        userModel: QueryOperation<User>;
        image: QueryOperation<Image>;
    }
    export interface User$Operations {
        query: QueryOperation<User>;
        read: ReadOperation<User>;
        aggregate: {
            read: AggregateReadOperation<User>;
            query: AggregateQueryOperation<User>;
        };
        lookups(dataOrId: string | { data: UserInput }): User$Lookups;
        getDefaults: GetDefaultsOperation<User>;
    }
    export interface Package {
        '@sage/wh-system/Access': Access$Operations;
        '@sage/wh-system/ActionParameter': ActionParameter$Operations;
        '@sage/wh-system/ActivityCode': ActivityCode$Operations;
        '@sage/wh-system/Company': Company$Operations;
        '@sage/wh-system/Destination': Destination$Operations;
        '@sage/wh-system/FunctionActions': FunctionActions$Operations;
        '@sage/wh-system/FunctionOptions': FunctionOptions$Operations;
        '@sage/wh-system/FunctionVariables': FunctionVariables$Operations;
        '@sage/wh-system/Function': Function$Operations;
        '@sage/wh-system/FunctionalProfilePerSite': FunctionalProfilePerSite$Operations;
        '@sage/wh-system/FunctionalProfile': FunctionalProfile$Operations;
        '@sage/wh-system/GeneralParameterSelectableValues': GeneralParameterSelectableValues$Operations;
        '@sage/wh-system/GeneralParameter': GeneralParameter$Operations;
        '@sage/wh-system/GeneralParametersData': GeneralParametersData$Operations;
        '@sage/wh-system/GenericPrintReport': GenericPrintReport$Operations;
        '@sage/wh-system/Image': Image$Operations;
        '@sage/wh-system/Language': Language$Operations;
        '@sage/wh-system/MiscellaneousTable': MiscellaneousTable$Operations;
        '@sage/wh-system/MiscellaneousTables': MiscellaneousTables$Operations;
        '@sage/wh-system/SiteUnavailabilityDays': SiteUnavailabilityDays$Operations;
        '@sage/wh-system/Site': Site$Operations;
        '@sage/wh-system/SyracusMethod': SyracusMethod$Operations;
        '@sage/wh-system/UserAccess': UserAccess$Operations;
        '@sage/wh-system/UserFunctionProfileUserProfileDefaultSites': UserFunctionProfileUserProfileDefaultSites$Operations;
        '@sage/wh-system/UserFunctionProfile': UserFunctionProfile$Operations;
        '@sage/wh-system/UserFunctions': UserFunctions$Operations;
        '@sage/wh-system/UserParameterValue': UserParameterValue$Operations;
        '@sage/wh-system/UserProfileMenu': UserProfileMenu$Operations;
        '@sage/wh-system/UserSupervisors': UserSupervisors$Operations;
        '@sage/wh-system/UserUserDestinations': UserUserDestinations$Operations;
        '@sage/wh-system/User': User$Operations;
    }
    export interface GraphApi extends Package, SageXtremAppMetadata$Package, SageXtremX3SystemUtils$Package {}
}
declare module '@sage/wh-system-api' {
    export type * from '@sage/wh-system-api-partial';
}
declare module '@sage/xtrem-app-metadata-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/wh-system-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/xtrem-x3-system-utils-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/wh-system-api';
    export interface GraphApi extends GraphApiExtension {}
}
