// From file: @sage/xtrem-cli-compile/build/index.d.ts
declare module '@sage/xtrem-cli-compile/index' {
	export * from '@sage/xtrem-cli-compile/lib/index';
	//# sourceMappingURL=index.d.ts.map
}
// From file: @sage/xtrem-cli-compile/build/lib/index.d.ts
declare module '@sage/xtrem-cli-compile/lib/index' {
	export * from '@sage/xtrem-cli-compile/lib/compile/index';
	export * from '@sage/xtrem-cli-compile/lib/compile-plugin/index';
	//# sourceMappingURL=index.d.ts.map
}
// From file: @sage/xtrem-cli-compile/build/lib/compile-plugin/index.d.ts
declare module '@sage/xtrem-cli-compile/lib/compile-plugin/index' {
	export const compilePlugin: () => void;
	//# sourceMappingURL=index.d.ts.map
}
// From file: @sage/xtrem-cli-compile/build/lib/compile/watch-server.d.ts
declare module '@sage/xtrem-cli-compile/lib/compile/watch-server' {
	import { ExecutionMode, TypescriptObserverInput } from '@sage/xtrem-cli-lib';
	import { ApplicationStartServicesOptions } from '@sage/xtrem-core';
	import { Observable, Observer } from 'rxjs';
	export const startWatchServer: (executionMode: ExecutionMode, dir: string, isUsingReferences: boolean) => Observable<boolean>;
	export const typescriptObserver: (observerInput: TypescriptObserverInput, startServices: (dir: string, options: ApplicationStartServicesOptions) => Promise<void>) => Observer<boolean>;
	//# sourceMappingURL=watch-server.d.ts.map
}
// From file: @sage/xtrem-cli-compile/build/lib/compile/watch-client.d.ts
declare module '@sage/xtrem-cli-compile/lib/compile/watch-client' {
	import { ExecutionMode, TypescriptObserverInput } from '@sage/xtrem-cli-lib';
	import { Observer } from 'rxjs';
	import { WebpackResult } from '@sage/xtrem-cli-compile/lib/compile/utils/index';
	export const watchClientArtifacts: (executionMode: ExecutionMode, buildDir: string) => import("rxjs").Observable<WebpackResult> | undefined;
	export const printCompilerErrorMessage: (executionMode: ExecutionMode, error: {
	    message: string;
	    chunkName?: string;
	    chunkEntry?: boolean;
	    chunkInitial?: boolean;
	    file?: string;
	    moduleIdentifier?: string;
	    moduleName?: string;
	    loc?: string;
	    chunkId?: string | number;
	    moduleId?: string | number;
	    moduleTrace?: any;
	    details?: any;
	    stack?: any;
	}) => void;
	export const webpackObserver: ({ executionMode, deployedApp, dir, }: TypescriptObserverInput) => Observer<WebpackResult>;
	//# sourceMappingURL=watch-client.d.ts.map
}
// From file: @sage/xtrem-cli-compile/build/lib/compile/instrumenter.d.ts
declare module '@sage/xtrem-cli-compile/lib/compile/instrumenter' {
	import { ExecutionMode } from '@sage/xtrem-cli-lib';
	export const instrumentCode: (executionMode: ExecutionMode, dir: string) => void;
	//# sourceMappingURL=instrumenter.d.ts.map
}
// From file: @sage/xtrem-cli-compile/build/lib/compile/index.d.ts
declare module '@sage/xtrem-cli-compile/lib/compile/index' {
	import { compileServer } from '@sage/xtrem-cli-compile/lib/compile/compile-server';
	export interface CompileOptions {
	    skipClient: boolean;
	    skipCop: boolean;
	    skipServer: boolean;
	    skipClean: boolean;
	    skipDts: boolean;
	    skipApiClient: boolean;
	    force: boolean;
	    isInstrumented: boolean;
	    isBinary: boolean;
	    isProd: boolean;
	    isUsingReferences: boolean;
	    isOnlyApi: boolean;
	    isOnlyChanged: boolean;
	    skipApplication?: boolean;
	    skipClientTypeCheck?: boolean;
	}
	export * from '@sage/xtrem-cli-compile/lib/compile/utils/index';
	export * from '@sage/xtrem-cli-compile/lib/compile/watch-client';
	export * from '@sage/xtrem-cli-compile/lib/compile/watch-server';
	export { compileServer };
	export function compile(options: CompileOptions): Promise<void>;
	//# sourceMappingURL=index.d.ts.map
}
// From file: @sage/xtrem-cli-compile/build/lib/compile/dts-generator.d.ts
declare module '@sage/xtrem-cli-compile/lib/compile/dts-generator' {
	import { ExecutionMode } from '@sage/xtrem-cli-lib';
	export const generateSingleDefinition: (executionMode: ExecutionMode, dir: string) => void;
	//# sourceMappingURL=dts-generator.d.ts.map
}
// From file: @sage/xtrem-cli-compile/build/lib/compile/copy-dictionaries.d.ts
declare module '@sage/xtrem-cli-compile/lib/compile/copy-dictionaries' {
	import { ExecutionMode } from '@sage/xtrem-cli-lib';
	export const copyDictionaries: (executionMode: ExecutionMode, dir: string) => void;
	//# sourceMappingURL=copy-dictionaries.d.ts.map
}
// From file: @sage/xtrem-cli-compile/build/lib/compile/compile-ui.d.ts
declare module '@sage/xtrem-cli-compile/lib/compile/compile-ui' {
	import { ExecutionMode } from '@sage/xtrem-cli-lib';
	import { CompileOptions } from '@sage/xtrem-cli-compile/lib/compile/index';
	export const compileUi: (executionMode: ExecutionMode, buildDir: string, options: CompileOptions, packageName: string) => Promise<void>;
	//# sourceMappingURL=compile-ui.d.ts.map
}
// From file: @sage/xtrem-cli-compile/build/lib/compile/compile-server.d.ts
declare module '@sage/xtrem-cli-compile/lib/compile/compile-server' {
	import { ExecutionMode } from '@sage/xtrem-cli-lib';
	export interface CompileServerOptions {
	    isUsingReferences?: boolean;
	    skipQueueFileGeneration?: boolean;
	}
	export const compileServer: (executionMode: ExecutionMode, dir: string, options?: CompileServerOptions) => void;
	//# sourceMappingURL=compile-server.d.ts.map
}
// From file: @sage/xtrem-cli-compile/build/lib/compile/clean.d.ts
declare module '@sage/xtrem-cli-compile/lib/compile/clean' {
	import { ExecutionMode } from '@sage/xtrem-cli-lib';
	export const clean: (executionMode: ExecutionMode, dir: string, options?: {
	    force: boolean;
	}) => void;
	//# sourceMappingURL=clean.d.ts.map
}
// From file: @sage/xtrem-cli-compile/build/lib/compile/binary.d.ts
declare module '@sage/xtrem-cli-compile/lib/compile/binary' {
	import { ExecutionMode } from '@sage/xtrem-cli-lib';
	export const binaryEncoding: (executionMode: ExecutionMode, dir: string) => Promise<void>;
	//# sourceMappingURL=binary.d.ts.map
}
// From file: @sage/xtrem-cli-compile/build/lib/compile/utils/xtrem-client-plugin.d.ts
declare module '@sage/xtrem-cli-compile/lib/compile/utils/xtrem-client-plugin' {
	export {};
	//# sourceMappingURL=xtrem-client-plugin.d.ts.map
}
// From file: @sage/xtrem-cli-compile/build/lib/compile/utils/transformers.d.ts
declare module '@sage/xtrem-cli-compile/lib/compile/utils/transformers' {
	import '@sage/xtrem-minify';
	//# sourceMappingURL=transformers.d.ts.map
}
// From file: @sage/xtrem-cli-compile/build/lib/compile/utils/server-compilation.d.ts
declare module '@sage/xtrem-cli-compile/lib/compile/utils/server-compilation' {
	import { ExecutionMode } from '@sage/xtrem-cli-lib';
	import * as ts from 'typescript';
	export const getTsProgram: (dir: string, options?: {
	    configFileName?: string;
	    excludeOverride?: string[];
	    includeOverride?: string[];
	    tsconfigOverride?: Partial<ts.CompilerOptions>;
	}) => ts.Program;
	export const getFiles: (dir: string, options?: {
	    configFileName?: string;
	    excludeOverride?: string[];
	    includeOverride?: string[];
	}) => any;
	export const getCompilerOptions: (dir: string, configFileNme?: string, tsconfigOverride?: Partial<ts.CompilerOptions>) => ts.CompilerOptions;
	export const printCompilerError: (executionMode: ExecutionMode) => (diagnostic: ts.Diagnostic) => void;
	//# sourceMappingURL=server-compilation.d.ts.map
}
// From file: @sage/xtrem-cli-compile/build/lib/compile/utils/index.d.ts
declare module '@sage/xtrem-cli-compile/lib/compile/utils/index' {
	export * from '@sage/xtrem-cli-compile/lib/compile/utils/client-compilation';
	export * from '@sage/xtrem-cli-compile/lib/compile/utils/server-compilation';
	export * from '@sage/xtrem-cli-compile/lib/compile/utils/xtrem-client-plugin';
	//# sourceMappingURL=index.d.ts.map
}
// From file: @sage/xtrem-cli-compile/build/lib/compile/utils/client-compilation.d.ts
declare module '@sage/xtrem-cli-compile/lib/compile/utils/client-compilation' {
	import { ExecutionMode, PackagingMode } from '@sage/xtrem-cli-lib';
	import { Observable } from 'rxjs';
	import * as webpack from 'webpack';
	export const compileClientAndSharedFunctions: (executionMode: ExecutionMode, dir: string) => void;
	export const checkTypesOnClientArtifactsAndBuildDeclarations: (executionMode: ExecutionMode, dir: string) => void;
	export const filterExternals: ({ request }: any) => Promise<string | void>;
	export const isCompilable: (filePath: string) => boolean;
	export const getWebpackEntry: (executionMode: ExecutionMode, dir: string, isOnlyChanged: boolean) => (() => webpack.Entry);
	interface CompileInput {
	    executionMode: ExecutionMode;
	    buildDir: string;
	    isProd: boolean;
	    isInstrumented: boolean;
	    isFast?: boolean;
	    isWatch?: boolean;
	    isOnlyChanged?: boolean;
	    packageName: string;
	}
	export const compilePagesAndStickers: ({ executionMode, buildDir, isProd, isInstrumented, isWatch, isOnlyChanged, packageName, }: CompileInput) => Observable<WebpackResult>;
	interface WebpackInput {
	    buildDir: string;
	    entry: () => webpack.Entry;
	    output: webpack.Configuration['output'];
	    packagingMode?: PackagingMode;
	    isInstrumented: boolean;
	    options?: webpack.Configuration;
	}
	export const compileFiles: ({ buildDir, entry, output, packagingMode, isInstrumented, options, }: WebpackInput) => Observable<WebpackResult>;
	export type WebpackResult = {
	    stats: webpack.Stats | undefined | null;
	    error: Error | undefined | null;
	};
	export {};
	//# sourceMappingURL=client-compilation.d.ts.map
}
declare module '@sage/xtrem-cli-compile' {
	export * from '@sage/xtrem-cli-compile/index';
}
