/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.webpackObserver=exports.printCompilerErrorMessage=exports.watchClientArtifacts=void 0;const xtrem_cli_lib_1=require("@sage/xtrem-cli-lib"),xtrem_core_1=require("@sage/xtrem-core"),glob_1=require("glob"),utils_1=require("./utils"),watchClientArtifacts=(e,r)=>{const t={cwd:r,absolute:true,realpath:true},i=glob_1.glob.sync("./lib/pages/*.ts",t).filter(utils_1.isCompilable),s=glob_1.glob.sync("./lib/stickers/*.ts",t).filter(utils_1.isCompilable);if(i.length<=0&&s.length<=0)return void(0,xtrem_cli_lib_1.printInfo)(e,"No client side artifacts found.");return(0,utils_1.compilePagesAndStickers)({executionMode:e,buildDir:r,isProd:false,isInstrumented:false,isWatch:true,isOnlyChanged:false,packageName:r.split("/").pop()??""})};exports.watchClientArtifacts=watchClientArtifacts;const printCompilerErrorMessage=(e,r)=>{console.log(r);try{const t=r.stack?.split("\n"),i=JSON.parse(t[t.length-1]);(0,xtrem_cli_lib_1.printWarning)(e,`${i.file}:${i.line}:${i.character}\n${i.content}`)}catch(t){(0,xtrem_cli_lib_1.printWarning)(e,r.message)}};exports.printCompilerErrorMessage=printCompilerErrorMessage;const webpackObserver=({executionMode:e,deployedApp:r,dir:t})=>({next:i=>{const s=i.stats&&i.stats.toJson(),l=s&&s.warnings&&s.warnings.length>0,o=s&&s.errors&&s.errors.length>0;if(!i.error&&!l&&!o){if(r.app)return xtrem_core_1.ArtifactManager.clearStored(),(0,xtrem_cli_lib_1.printSuccess)(e,"Webpack compiler finished successfully. Please refresh your webpage to see the changes."),void(0,xtrem_cli_lib_1.broadcastCompilerSuccessMessage)("client");(0,xtrem_cli_lib_1.printSuccess)(e,"Webpack compiler finished successfully."),(0,xtrem_cli_lib_1.broadcastCompilerSuccessMessage)("client")}else{if(!s)return;if(l)s.warnings?.forEach(r=>{(0,xtrem_cli_lib_1.addTsLoaderErrorToDispatchQueue)(r.message,t),(0,exports.printCompilerErrorMessage)(e,r)});if(o)s.errors?.forEach(r=>{(0,xtrem_cli_lib_1.addTsLoaderErrorToDispatchQueue)(r.message,t),(0,exports.printCompilerErrorMessage)(e,r)});(0,xtrem_cli_lib_1.printWarning)(e,`${(0,xtrem_cli_lib_1.plural)("error was","errors were",(s.errors??[]).length)} found during Webpack compilation.\nHot-reloading is enabled though, you can issue another build just by re-saving any page/sticker file.\nNote that the Xtrem server will be restarted automatically upon every successful build.`)}},error:r=>(0,xtrem_cli_lib_1.printWarning)(e,`Unexpected error from watch-client: ${r}`),complete:()=>{}});exports.webpackObserver=webpackObserver;
//# sourceMappingURL=watch-client.js.map