/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.XtremClientPlugin=void 0;const xtrem_cli_lib_1=require("@sage/xtrem-cli-lib"),xtrem_cli_transformers_1=require("@sage/xtrem-cli-transformers"),fs=require("fs"),glob=require("glob"),lodash_1=require("lodash"),path=require("path"),ts=require("typescript"),webpack=require("webpack"),globParent=require("glob-parent"),propertyNameRegex=/\.([A-Za-z]*)(<[\s\S]*>)?$/,artifactFolders=[xtrem_cli_lib_1.ArtifactTypes.Pages,xtrem_cli_lib_1.ArtifactTypes.Stickers,xtrem_cli_lib_1.ArtifactTypes.PageExtensions,xtrem_cli_lib_1.ArtifactTypes.PageFragments],directories=[];class XtremClientPlugin{constructor(e,t=xtrem_cli_lib_1.ExecutionMode.STANDALONE){this.appDir=e,this.executionMode=t}static getEntries(e,t,r,s,i){return()=>{if("string"!=typeof r&&!Array.isArray(r))throw new TypeError("globOptions must be a string or an array of strings");if(s&&"object"!=typeof s)throw new TypeError("globOptions must be an object");if(!Array.isArray(r))r=[r];let a={};if(r.forEach(e=>{const r=globParent(e);if(-1===directories.indexOf(r))directories.push(r);const n=XtremClientPlugin.getFiles(t,e,s,i);a={...n,...a}}),i)(0,xtrem_cli_lib_1.printInfo)(e,`Building the following files:\n${Object.keys(a).join("\n")}`);return a}}static getFiles(e,t,r,s){const i={},a=globParent(t);return glob.sync(t,r).filter(t=>{if(!s)return true;const r=(0,xtrem_cli_transformers_1.getMetadataFilePathForClientFile)(e,t.toString());if(!fs.existsSync(r))return true;return(0,xtrem_cli_transformers_1.hashFile)(t.toString())!==JSON.parse(fs.readFileSync(r,"utf-8")).md5}).forEach(e=>{const t=path.relative(a,e.toString()),r=path.basename(t.replace(path.extname(e.toString()),"").split(path.sep).join("/")),s=path.basename(a);i[`${s}/${r}`]=e.toString()}),i}apply(e){e.hooks.afterCompile.tapAsync(this.constructor.name,this.afterCompile.bind(this)),e.hooks.watchRun.tapAsync(`${this.constructor.name}watchRun`,this.afterChangesDetected.bind(this))}afterChangesDetected(e,t){(0,xtrem_cli_lib_1.printInfo)(this.executionMode,"Client changes detected!"),(0,xtrem_cli_lib_1.broadcastMessage)(xtrem_cli_lib_1.EventType.COMPILER_STARTED,"client"),t()}mapClientUtilityDependencyChain(e,t,r,s=[]){t.dependencies.forEach(t=>{const i=e.moduleGraph.getModule(t);if(!i?.resource||r.includes(i.resource))return;if("CommonJsRequireDependency"===t.constructor.name&&!r.includes(i.resource)&&(-1!==i.resource.indexOf("lib/client-functions")||-1!==i.resource.indexOf("lib/shared-functions")))r.push(i.resource);if(!s.includes(i.resource))s.push(i.resource),this.mapClientUtilityDependencyChain(e,i,r,s)})}extractUsedTranslationKeysToMetaFile(e){Array.from(e.modules.values()).forEach(t=>{if(!t?.resource||!t.resource.startsWith(this.appDir)||!(0,xtrem_cli_transformers_1.isClientArtifactFile)(t.resource))return;const r=[];this.mapClientUtilityDependencyChain(e,t,r);const s={};r.forEach(e=>{const t=fs.readFileSync(e,"utf-8"),r=ts.createSourceFile(path.basename(e),t,ts.ScriptTarget.ES2022),transformer=e=>t=>ts.visitNode(t,(0,xtrem_cli_transformers_1.messageTransformVisitor)(s,"",t.fileName,e,true));ts.transform(r,[transformer])});const i=Object.keys(s);if(0===i.length)return;const a=(0,xtrem_cli_transformers_1.getMetadataFilePathForClientFile)(this.appDir,t.resource),n=JSON.parse(fs.readFileSync(a,"utf-8")),o=(0,lodash_1.get)(n,"literals.strings",[]);(0,lodash_1.set)(n,"literals.strings",(0,lodash_1.uniq)([...o,...i])),fs.writeFileSync(a,JSON.stringify(n,null,4))})}afterCompile(e,t){try{this.extractUsedTranslationKeysToMetaFile(e),directories.forEach(t=>e.contextDependencies.add(t)),e.fileDependencies.forEach(t=>{if(!t.includes("package.json")){this.checkUiArtifacts(t).forEach(t=>{e.errors.push(new webpack.WebpackError(t))})}},this)}catch(t){e.errors.push(t)}finally{t()}}getArtifactsFolderName(e){let t;const r=fs.realpathSync(e),s=artifactFolders.filter(e=>fs.existsSync(path.resolve(this.appDir,`lib/${e}`))).map(e=>({folderName:e,folderPath:fs.realpathSync(path.resolve(this.appDir,`lib/${e}`))})).find(e=>r.startsWith(e.folderPath));if(s)t=s.folderName;return t}checkUiArtifacts(e){if(this.getArtifactsFolderName(e)&&"index.ts"!==path.basename(e)&&fs.lstatSync(e).isFile()){const t=fs.readFileSync(e,"utf-8"),r=ts.createSourceFile(path.basename(e),t,ts.ScriptTarget.ES2022),s=r.statements.filter(ts.isClassDeclaration).find(e=>Boolean(e&&e.heritageClauses&&e.heritageClauses.length>0));if(s)return XtremClientPlugin.checkDecoratorsAndTypes(e,r,s)}return[]}static checkDecoratorsAndTypes(e,t,r){const s=[],i=r.name;if(i&&r.name&&path.basename(e).replace(".ts","")!==(0,lodash_1.kebabCase)(r.name.getText(t)))s.push(`Xtrem Page error: in '${e}' the class name must be the same as the filename with camel case naming conventions. Class name found: ${i.getText(t)}.`);const a=(ts.getDecorators(r)||[]).some(e=>{if(ts.isCallExpression(e.expression)){return e.expression.expression.getText(t).includes("pageFragment")}return false});return r.members.filter(ts.isPropertyDeclaration).forEach(r=>{const i=ts.getDecorators(r)?.[0];if(i&&ts.isCallExpression(i.expression)){const n=i.expression.expression.getText(t),o=r.type?`:${t.getLineAndCharacterOfPosition(r.type.pos).line+1}`:"",c=r.name.getText(t),l=(n.replace("Field","").replace("extension","").replace("Extension","").replace("Override","").replace("override","").match(propertyNameRegex)??["",""])[1].toLowerCase(),p=r.type?r.type.getText(t):"",f=(p.replace("Field","").match(propertyNameRegex)??["",""])[1].toLowerCase();if(l&&f&&l!==f)s.push(`Xtrem Page error: in '${e}${o}' the "${c}" property is misconfigured because the decorator type "${n}" doesn't match the "${p}" property type.`);if(a&&n&&!n.toLowerCase().includes("field"))s.push(`Xtrem Page error: in '${e}${o}' the "${c}" property is decorated but is not a field in a page fragment.`)}}),s}}exports.XtremClientPlugin=XtremClientPlugin;
//# sourceMappingURL=xtrem-client-plugin.js.map