/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.compileFiles=exports.compilePagesAndStickers=exports.getWebpackEntry=exports.isCompilable=exports.filterExternals=exports.checkTypesOnClientArtifactsAndBuildDeclarations=exports.compileClientAndSharedFunctions=void 0;const xtrem_cli_lib_1=require("@sage/xtrem-cli-lib"),xtrem_cli_transformers_1=require("@sage/xtrem-cli-transformers"),path=require("path"),rxjs_1=require("rxjs"),ts=require("typescript"),webpack=require("webpack"),server_compilation_1=require("./server-compilation"),xtrem_client_plugin_1=require("./xtrem-client-plugin"),TerserPlugin=require("terser-webpack-plugin"),compileClientAndSharedFunctions=(e,r)=>{(0,xtrem_cli_lib_1.printInfo)(e,"Compiling client and shared functions...");const t=(0,server_compilation_1.getTsProgram)(r,{configFileName:"tsconfig-artifacts.json",includeOverride:["lib/client-functions","lib/shared-functions"],tsconfigOverride:{declaration:false,composite:false,declarationMap:false}}),i=t.emit(void 0,void 0,void 0,void 0,{before:[xtrem_cli_transformers_1.decimalTransformer,xtrem_cli_transformers_1.messageTransformer,xtrem_cli_transformers_1.pageMetadataTransformer]}),s=ts.getPreEmitDiagnostics(t).concat(i.diagnostics);if(s.forEach((0,server_compilation_1.printCompilerError)(e)),0===s.length)(0,xtrem_cli_lib_1.printSuccess)(e,"Shared and client functions compiled.");else(0,xtrem_cli_lib_1.quitWithError)(e,"Failed to compile shared and client functions.")};exports.compileClientAndSharedFunctions=compileClientAndSharedFunctions;const checkTypesOnClientArtifactsAndBuildDeclarations=(e,r)=>{(0,xtrem_cli_lib_1.printInfo)(e,"Type checking client...");const t=(0,server_compilation_1.getTsProgram)(r,{configFileName:"tsconfig-artifacts.json",excludeOverride:["build/*/*.d.ts"],tsconfigOverride:{strictNullChecks:false,skipLibCheck:true,emitDeclarationOnly:true}}),i=t.emit(),s=ts.getPreEmitDiagnostics(t).concat(i.diagnostics);if(s.forEach((0,server_compilation_1.printCompilerError)(e)),0===s.length)(0,xtrem_cli_lib_1.printSuccess)(e,"Type checks passed.");else(0,xtrem_cli_lib_1.quitWithError)(e,"Failed to compile client.")};exports.checkTypesOnClientArtifactsAndBuildDeclarations=checkTypesOnClientArtifactsAndBuildDeclarations;const filterExternals=({request:e})=>{if(/@sage\/xtrem-ui/.test(e))return Promise.resolve(`commonjs ${e}`);if(/@sage\/xtrem-async-helper/.test(e))return Promise.resolve(`commonjs ${e}`);if(/@sage\/xtrem-i18n/.test(e))return Promise.resolve(`commonjs ${e}`);if(/@sage\/xtrem-date-time/.test(e))return Promise.resolve(`commonjs ${e}`);if(/@sage\/xtrem-decimal/.test(e))return Promise.resolve(`commonjs ${e}`);if(/@sage\/xtrem-shared/.test(e))return Promise.resolve(`commonjs ${e}`);if(/@sage\/xtrem-client/.test(e))return Promise.resolve(`commonjs ${e}`);if(/@sage\/xtrem-core/.test(e))return Promise.resolve(`commonjs ${e}`);if("lodash"===e)return Promise.resolve(`commonjs ${e}`);if("react"===e)return Promise.resolve(`commonjs ${e}`);return Promise.resolve()};exports.filterExternals=filterExternals;const isCompilable=e=>{const r=path.basename(e);return"index.ts"!==r&&"_index.ts"!==r&&r.endsWith(".ts")};exports.isCompilable=isCompilable;const getWebpackEntry=(e,r,t)=>xtrem_client_plugin_1.XtremClientPlugin.getEntries(e,r,["./lib/pages/*.ts","./lib/stickers/*.ts","./lib/page-extensions/*.ts","./lib/page-fragments/*.ts","./lib/widgets/*.ts"],{ignore:"**/index.ts",cwd:r,absolute:true,realpath:true},t);exports.getWebpackEntry=getWebpackEntry;const compilePagesAndStickers=({executionMode:e,buildDir:r,isProd:t,isInstrumented:i,isWatch:s=false,isOnlyChanged:o=false,packageName:n})=>{const l=(0,exports.getWebpackEntry)(e,r,o),a={path:path.resolve(r,"build/lib").toLowerCase(),filename:"[name].js",library:{name:"xtremArtifact",type:"assign-properties"},devtoolNamespace:n,devtoolModuleFilenameTemplate:"webpack://[namespace]/[resource-path]"},c=t?xtrem_cli_lib_1.PackagingMode.PROD:xtrem_cli_lib_1.PackagingMode.DEV;return(0,exports.compileFiles)({buildDir:r,entry:l,output:a,packagingMode:c,isInstrumented:i,options:s?{watch:true}:{}})};exports.compilePagesAndStickers=compilePagesAndStickers;const compileFiles=({buildDir:e,entry:r,output:t,packagingMode:i=xtrem_cli_lib_1.PackagingMode.DEV,isInstrumented:s,options:o={}})=>{const n=i===xtrem_cli_lib_1.PackagingMode.DEV,l=o&&o.watch||false;let a="source-map";if(!s)a=n?"eval-source-map":false;const c={tsLoader:require.resolve("ts-loader"),threadLoader:require.resolve("thread-loader")},m={entry:r,mode:n?"development":"production",devtool:a,performance:{hints:false,maxEntrypointSize:512e3,maxAssetSize:512e3},optimization:i===xtrem_cli_lib_1.PackagingMode.PROD?{minimize:true,minimizer:[new TerserPlugin({terserOptions:{keep_classnames:true,keep_fnames:true}})]}:void 0,...l?{watchOptions:{aggregateTimeout:600},devServer:{contentBase:path.resolve(e,"build/lib").toLowerCase(),compress:true,publicPath:"/",port:4e3,host:"0.0.0.0",historyApiFallback:{index:"/"},proxy:[{target:"http://localhost:8240"}]}}:{},output:t,plugins:[new xtrem_client_plugin_1.XtremClientPlugin(e),new webpack.ProvidePlugin({Buffer:["buffer","Buffer"]})],externals:[exports.filterExternals],module:{rules:[...!l?[{loader:c.threadLoader,options:{workerParallelJobs:50,workerNodeArgs:["--max-old-space-size=1024"],poolRespawn:false,poolTimeout:2e3,poolParallelJobs:50}}]:[],{test:/\.ts$/,exclude:/node_modules/,loader:c.tsLoader,options:{happyPackMode:!l,colors:false,configFile:path.resolve(e,"tsconfig-artifacts.json"),errorFormatter:e=>JSON.stringify(e),getCustomTransformers:require.resolve("./transformers")}}]},resolve:{fallback:{buffer:require.resolve("buffer/")},extensions:[".ts",".tsx",".js",".json"]},...o};return runWebpack({compiler:webpack(m),isWatchEnabled:l})};exports.compileFiles=compileFiles;const runWebpack=({compiler:e,isWatchEnabled:r=false})=>{if(r)return new rxjs_1.Observable(r=>{e.watch({ignored:/node_modules/,poll:true},(e,t)=>{r.next({stats:t,error:e})})});return new rxjs_1.Observable(r=>{e.run((e,t)=>{r.next({stats:t,error:e})})})};
//# sourceMappingURL=client-compilation.js.map