/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";var __createBinding=this&&this.__createBinding||(Object.create?function(e,i,r,t){if(void 0===t)t=r;var n=Object.getOwnPropertyDescriptor(i,r);if(!n||("get"in n?!i.__esModule:n.writable||n.configurable))n={enumerable:true,get:function(){return i[r]}};Object.defineProperty(e,t,n)}:function(e,i,r,t){if(void 0===t)t=r;e[t]=i[r]}),__exportStar=this&&this.__exportStar||function(e,i){for(var r in e)if("default"!==r&&!Object.prototype.hasOwnProperty.call(i,r))__createBinding(i,e,r)};Object.defineProperty(exports,"__esModule",{value:true}),exports.compileServer=void 0,exports.compile=compile;const xtrem_cli_lib_1=require("@sage/xtrem-cli-lib"),xtrem_cli_transformers_1=require("@sage/xtrem-cli-transformers"),xtrem_client_gen_1=require("@sage/xtrem-client-gen"),xtrem_cop_1=require("@sage/xtrem-cop"),xtrem_core_1=require("@sage/xtrem-core"),xtrem_i18n_1=require("@sage/xtrem-i18n"),xtrem_shared_1=require("@sage/xtrem-shared"),chalk=require("chalk"),fs=require("fs"),_=require("lodash"),path=require("path"),binary_1=require("./binary"),clean_1=require("./clean"),compile_server_1=require("./compile-server");Object.defineProperty(exports,"compileServer",{enumerable:true,get:function(){return compile_server_1.compileServer}});const compile_ui_1=require("./compile-ui"),copy_dictionaries_1=require("./copy-dictionaries"),dts_generator_1=require("./dts-generator"),instrumenter_1=require("./instrumenter");async function compile(e){const{executionMode:i,dir:r}=xtrem_cli_lib_1.cliContext,{skipClient:t,skipCop:n,skipServer:a,skipClean:o,skipDts:s,skipApiClient:c,force:l,isInstrumented:g,isBinary:m,isUsingReferences:u,isOnlyApi:f,isOnlyChanged:p}=e,x=Date.now();if(f)(0,xtrem_client_gen_1.generateClientPackageJsonFromPackageJson)(r),process.exit();if(process.env.XTREM_USE_TEST_APPLICATION="0",a&&m)(0,xtrem_cli_lib_1.quitWithError)(i,"In order to compile to binary format, you have to also compile the server side artifacts.");if(l||!o&&!p)(0,clean_1.clean)(i,r,{force:l});else if(p)xtrem_cli_lib_1.cliContext.printWarning("The build folder was not cleaned as the --only-changed flag was applied.");else xtrem_cli_lib_1.cliContext.printInfo("Skipping build folder cleanup.");if(!a)(0,compile_server_1.compileServer)(i,r,{isUsingReferences:u});else if(!c)(0,xtrem_cli_lib_1.quitWithError)(i,"In order to generate the client API schema, you have to also compile the server side artifacts. Try adding the --skip-api-client flag or removing the --skip-server one");else xtrem_cli_lib_1.cliContext.printInfo("Skipping server side artifacts.");if(!a&&!s)(0,dts_generator_1.generateSingleDefinition)(i,r);else xtrem_cli_lib_1.cliContext.printInfo("Skipping single declaration file generation. Reason: "+(a?"skip server":"skip DTS"));if(!e.skipApplication){const e=await xtrem_core_1.ApplicationManager.getApplication(r,{applicationType:"dev-tool"});if(checkMainPackageLocales(e,i),e.mainPackage.isMain||e.mainPackage.api.workflowSteps)if(aggregateNotificationListenerRoutingData(e),!fs.existsSync(path.join(e.mainPackage.dir,"lib"))){if(xtrem_cli_lib_1.cliContext.printSuccess(`${chalk.bgGreen(" 🌋 ")} It's all done, you are ready to roll!`),i===xtrem_cli_lib_1.ExecutionMode.STANDALONE)process.exit();return}if(!n&&!path.join(e.mainPackage.dir,"../..").endsWith("/x3")){xtrem_cli_lib_1.cliContext.printInfo("Verifying code..."),(0,xtrem_cop_1.verifyDependsOn)(e);const r=await e.verifySqlConversions();if(r>0)(0,xtrem_cli_lib_1.quitWithError)(i,`Found ${r} errors in the getValue/computeValue decorators`);xtrem_cli_lib_1.cliContext.printSuccess("Code was successfully verified.")}else xtrem_cli_lib_1.cliContext.printInfo("Skipping code verification.");if(!c)xtrem_cli_lib_1.cliContext.printInfo("Generating API reference TS declaration package..."),await(0,xtrem_client_gen_1.generateClientPackage)(e),xtrem_cli_lib_1.cliContext.printSuccess("API reference TS declaration package generated successfully.");else xtrem_cli_lib_1.cliContext.printInfo("Skipping API reference TS declaration package generation.")}if(g)(0,instrumenter_1.instrumentCode)(i,r);if(m)await(0,binary_1.binaryEncoding)(i,r);if(!t)if(process.env.SKIP_CLIENT)xtrem_cli_lib_1.cliContext.printWarning("SKIP_CLIENT environment variable found, skipping client compilation...");else await(0,compile_ui_1.compileUi)(i,r,e,require(path.resolve(r,"package.json")).name);else xtrem_cli_lib_1.cliContext.printInfo("Skipping client side artifacts.");if(xtrem_cli_lib_1.cliContext.printInfo("Preparing string literal files..."),(0,xtrem_cli_transformers_1.mergeTranslationFiles)(r),(0,xtrem_i18n_1.resetDictionary)(),xtrem_cli_lib_1.cliContext.printSuccess("String literal files prepared."),(0,copy_dictionaries_1.copyDictionaries)(i,r),xtrem_cli_lib_1.cliContext.printSuccess(`${chalk.bgGreen(" 🌋 ")} It's all done, you are ready to roll! (${Date.now()-x} ms)`,false),i===xtrem_cli_lib_1.ExecutionMode.STANDALONE)process.exit()}function aggregateNotificationListenerRoutingData(e){let i=(0,xtrem_shared_1.createDictionary)(),r=(0,xtrem_shared_1.createDictionary)(),t=(0,xtrem_shared_1.createDictionary)(),n=(0,xtrem_shared_1.createDictionary)();e.getPackages().forEach(e=>{if(e.isMain&&!e.hasListeners)return;const a=getRoutingDataForPackage(e),o=getMessageQueueDataForPackage(e),s=getSelfManagedMessageQueueDataForPackage(e);i=(0,xtrem_cli_transformers_1.mergeRoutings)(i,a),r=(0,xtrem_cli_transformers_1.mergeRoutings)(r,a),t={...t,...o},n={...n,...s};const c=path.join(e.dir,"test/fixtures/routing.json");if(fs.existsSync(c)){const e=JSON.parse(fs.readFileSync(c,"utf-8"));r=(0,xtrem_cli_transformers_1.mergeRoutings)(r,e)}});const a=e.workflowManager.getWorkflowTopics().map(e=>({topic:e,queue:"workflow",sourceFileName:"<workflow step>"}));i=(0,xtrem_cli_transformers_1.mergeRoutings)(i,{"@sage/xtrem-workflow":a}),r=(0,xtrem_cli_transformers_1.mergeRoutings)(r,{"@sage/xtrem-workflow":a});const o=(0,xtrem_cli_transformers_1.getRoutingFilePath)(e.mainPackage.dir);xtrem_cli_lib_1.cliContext.printInfo(`Writing file ${o}`),fs.writeFileSync(o,JSON.stringify(i,null,4),"utf-8");const s=xtrem_cli_transformers_1.defaultElasticMq,c=Object.keys(t).filter(e=>!t[e].devOnly),l=(0,xtrem_cli_transformers_1.getAllElasticMqConfigs)(e.dir,r,void 0,(0,xtrem_cli_transformers_1.getElasticMqConfigs)(c));s.queues=_.merge(s.queues,l);const g=Object.keys(n);e.getPackages().forEach(i=>{const t=_.kebabCase(i.name.split("/").pop()),n=(0,xtrem_cli_transformers_1.getAllElasticMqConfigs)(e.dir,r,t,(0,xtrem_cli_transformers_1.getElasticMqConfigs)(g));s.queues=_.merge(s.queues,n)}),(0,xtrem_cli_transformers_1.updateElasticMqConfigFile)(e.workspaceId,e.workspaceDir,s.queues)}function getRoutingDataForPackage(e){const i=(0,xtrem_cli_transformers_1.getRoutingFilePath)(e.dir);if(fs.existsSync(i))return xtrem_cli_lib_1.cliContext.printInfo(`Routing file found in package ${e.name}: ${i}`),(0,xtrem_cli_transformers_1.getRoutingData)(i);return{}}function getMessageQueueDataFromFile(e,i){if(fs.existsSync(e))return xtrem_cli_lib_1.cliContext.printInfo(`${i}: ${e}`),(0,xtrem_cli_transformers_1.getMessageQueueData)(e);return{}}function getMessageQueueDataForPackage(e){return getMessageQueueDataFromFile((0,xtrem_cli_transformers_1.getMessageQueueFilePath)(e.dir),`Message queue file found in package ${e.name}`)}function getSelfManagedMessageQueueDataForPackage(e){return getMessageQueueDataFromFile((0,xtrem_cli_transformers_1.getMessageQueueFilePath)(e.dir).replace(".json","-self-managed.json"),`Self managed message queue file found in package ${e.name}`)}function checkMainPackageLocales(e,i){if(e.mainPackage.isMain&&e.mainPackage.packageJson?.xtrem?.locales){const r=e.mainPackage.packageJson.xtrem.locales.filter(e=>""===e||void 0===xtrem_shared_1.locales.find(i=>e===i));if(r.length>0)(0,xtrem_cli_lib_1.quitWithError)(i,`Found ${JSON.stringify(r)}: unknown locales in package.json`)}}__exportStar(require("./utils"),exports),__exportStar(require("./watch-client"),exports),__exportStar(require("./watch-server"),exports);
//# sourceMappingURL=index.js.map