/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.binaryEncoding=void 0;const xtrem_cli_lib_1=require("@sage/xtrem-cli-lib"),esquery=require("esquery"),glob_1=require("glob"),lodash=require("lodash"),xtremBytenode=require("@sage/xtrem-minify"),parse=require("espree").parse;function getPreservedRanges(e){const r=parse(e,{ecmaVersion:2022}),s=esquery.query(r,'CallExpression:has(SequenceExpression > MemberExpression[property.name="registerSqlFunction"])');if(s.length>0)return[[0,e.length]];const i=[...esquery.query(r,"Property[key.name=/^(defaultValue|getValue|filter|isClearedByReset|where)$/]"),...esquery.query(r,"Property[key.name=/^(set|join)$/] > ObjectExpression > Property")].filter(e=>"FunctionExpression"===e.value.type),t=esquery.query(r,"Property").filter(e=>"FunctionExpression"===e.value.type),n=lodash.difference(t,i),o=esquery.query(r,"FunctionDeclaration"),a=esquery.query(r,"ArrowFunctionExpression"),getStart=e=>e.start,getEnd=e=>e.end,getRange=e=>[getStart(e),getEnd(e)],declarationStartRange=(e,r)=>[getStart(e),getStart(r)],declarationEndRange=(e,r)=>[getEnd(r)-1,getEnd(e)];return[...i.map(getRange),...s.map(getRange),...n.map(e=>declarationStartRange(e,e.value.body)),...n.map(e=>declarationEndRange(e,e.value.body)),...o.map(e=>declarationStartRange(e,e.body)),...o.map(e=>declarationEndRange(e,e.body)),...a.map(e=>declarationStartRange(e,e.body)),...a.map(e=>declarationEndRange(e,e.body))].filter(e=>e[1]>e[0]).sort((e,r)=>e[0]-r[0])}const binaryEncoding=async(e,r)=>{(0,xtrem_cli_lib_1.printInfo)(e,"Encoding server side artifacts to binary format...");const s={cwd:r,absolute:true,realpath:true,ignore:["./build/index.js","./build/lib/index.js","./build/lib/{pages,sticker,menu-items,client-functions,shared-functions}/**/*.js"]};if(/\/(x3-services|wh-services)\//.test(r.replace(/\\/g,"/")))s.ignore.push("./build/lib/node*/**/*.js");const i=glob_1.glob.sync("./build/**/*.js",s);await xtremBytenode.compileAllFiles(r,i,{compileAsModule:true,compress:true,deleteSource:true,getPreservedRanges}),(0,xtrem_cli_lib_1.printSuccess)(e,"Server side artifacts encoded to binary format.")};exports.binaryEncoding=binaryEncoding;
//# sourceMappingURL=binary.js.map