/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.compilePlugin=void 0;const xtrem_cli_lib_1=require("@sage/xtrem-cli-lib"),xtrem_cli_transformers_1=require("@sage/xtrem-cli-transformers"),fs=require("fs"),path=require("path"),webpack_merge_1=require("webpack-merge"),utils_1=require("../compile/utils"),webpack=require("webpack"),compilePlugin=()=>{const{executionMode:e,dir:r}=xtrem_cli_lib_1.cliContext,s=path.resolve(r,"build"),i=path.resolve(r,"webpack.config.js"),t=xtrem_cli_lib_1.packageHelper.getPackageJson(r);if(true!==t?.xtremPlugin)(0,xtrem_cli_lib_1.quitWithError)(e,"Is this package really an Xtrem UI plugin? If so make sure to set the `xtremPlugin` property to true in your package file.");if(fs.existsSync(s))(0,xtrem_cli_lib_1.printInfo)(e,"Cleaning build directory..."),(0,xtrem_cli_lib_1.safeRmSync)(s,{recursive:true}),(0,xtrem_cli_lib_1.printSuccess)(e,"Build directory is clear.");const o=fs.existsSync(i)?require(i):{};(0,xtrem_cli_lib_1.printInfo)(e,"Building plugin...");const l={tsLoader:require.resolve("ts-loader"),urlLoader:require.resolve("url-loader"),styleLoader:require.resolve("style-loader"),cssLoader:require.resolve("css-loader"),sassLoader:require.resolve("sass-loader")},a=(0,webpack_merge_1.merge)({entry:fs.existsSync(path.resolve(r,"lib","index.tsx"))?"./lib/index.tsx":"./lib/index.ts",mode:"production",devtool:false,target:"web",context:r,output:{path:s,libraryTarget:"commonjs",filename:"index.js"},externals:[utils_1.filterExternals],plugins:[new webpack.optimize.LimitChunkCountPlugin({maxChunks:1})],module:{rules:[{test:/\.tsx?$/,exclude:/node_modules/,loader:l.tsLoader,options:{colors:false,configFile:path.resolve(r,"tsconfig.json"),errorFormatter:e=>JSON.stringify(e),getCustomTransformers:()=>({before:[xtrem_cli_transformers_1.messageTransformer,xtrem_cli_transformers_1.pageMetadataTransformer]})}},{test:/\.(png|woff|woff2|eot|ttf|svg|gif)$/,use:[{loader:l.urlLoader,options:{limit:1e5}}]},{test:/\.css$/,use:[l.styleLoader,{loader:l.cssLoader,options:{url:{filter:e=>!e.startsWith("/")}}}]},{test:/\.scss$/,use:[l.styleLoader,l.cssLoader,l.sassLoader],include:path.resolve(r,"lib")}]},resolve:{extensions:[".ts",".tsx",".js",".json"]}},o);webpack(a)?.run((s,i)=>{const t=i&&i.toJson();if(i.hasWarnings()&&t.warnings)t.warnings.forEach(r=>{(0,xtrem_cli_lib_1.printWarning)(e,r.message)});if(i.hasErrors()&&t.errors)t.errors.forEach(r=>{(0,xtrem_cli_lib_1.printWarning)(e,r.message)});if(s)(0,xtrem_cli_lib_1.quitWithError)(e,s.message);if(i.hasErrors())(0,xtrem_cli_lib_1.quitWithError)(e,"See compilation errors above.");if((0,xtrem_cli_transformers_1.mergeTranslationFiles)(r),(0,xtrem_cli_lib_1.printSuccess)(e,"Plugin is ready."),e===xtrem_cli_lib_1.ExecutionMode.STANDALONE)process.exit(0)})};exports.compilePlugin=compilePlugin;
//# sourceMappingURL=index.js.map