/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.PostgresPool=void 0,exports.create=create;const xtrem_postgres_1=require("@sage/xtrem-postgres"),xtrem_x3_sql_1=require("@sage/xtrem-x3-sql"),xtremToPostgreSql={boolean:{type:"BOOL",default:null},enum:{type:"INT2",default:null},short:{type:"INT4",default:null},reference:{type:"INT8",default:null},integer:{type:"INT8",default:null},integerRange:{type:"INT8RANGE",default:null},decimalRange:{type:"NUMRANGE",default:null},date:{type:"DATE",default:null},dateRange:{type:"DATERANGE",default:null},datetimeRange:{type:"TSTZRANGE",default:null},time:{type:"TIME",default:null},datetime:{type:"TIMESTAMPTZ(3)",default:null},float:{type:"FLOAT4",default:null},decimal:{type:"NUMERIC",default:null},double:{type:"FLOAT8",default:null},binaryStream:{type:"BYTEA",default:"''"},textStream:{type:"TEXT",default:"''"},string:{type:"VARCHAR",default:"''"},uuid:{type:"UUID",default:null},byte:{type:"INT2",default:null},binary:{type:"BYTEA",default:null},json:{type:"JSONB",default:null},integerArray:{type:"_INT8",default:null},enumArray:{type:"_INT2",default:null},referenceArray:{type:"_INT8",default:null},stringArray:{type:"_VARCHAR",default:null}},postgreSqlToXtrem={};Object.keys(xtremToPostgreSql).forEach(e=>{const t=xtremToPostgreSql[e];postgreSqlToXtrem[t.type]={name:e,default:t.default}}),postgreSqlToXtrem.TIMESTAMP={name:"datetime",default:null},postgreSqlToXtrem.TSRANGE={name:"datetimeRange",default:null},postgreSqlToXtrem["TIMESTAMPTZ(6)"]={name:"datetime",default:null};class PostgresPool extends xtrem_x3_sql_1.Pool{#e;constructor(e,t){if(super(e,t),this.dialect="postgres",!e.hostname)throw new Error("Hostname is required in the configuration");if(!e.database)throw new Error("Database is required in the configuration");if(!e.password)throw new Error("Password is required in the configuration");this.#e=new xtrem_postgres_1.ConnectionPool("user",e),xtrem_postgres_1.ConnectionPool.setup({logger:t})}param(e){return`$${e+1}`}checkConnection(e){return e}createConnection(){return this.logger&&this.logger.debug(()=>"connecting ..."),this.#e.allocConnection("x3-services")}closeConnection(e){try{this.#e.releaseConnection(e)}catch(e){this.logger?.error(e.stack)}}execute(e,t,n,a){let l,o,s,r;if("string"==typeof e)l=null,o=e,s=t,r=n;else l=e,o=t,s=n,r=a;if(null==l)return this.withConnection(e=>this.execute(e,o,s,r));return this.#e.execute(l,o,s,r)}createReader(e,t,n,a){return this.logger&&this.logger.verbose(()=>`[${this.config.user}] Reader ${t}, args=${n?n.join(","):""}`),this.#e.createReader(e,t,n,a)}tableExists(e,t){const n="SELECT to_regclass($1);";return this.withConnection(async a=>{const l=await this.execute(a,n,[`${t}.${e}`]);return!!(l.length&&null!=l[0].to_regclass)})}viewExists(e,t){const n="SELECT to_regclass($1);";return this.withConnection(async a=>{const l=await this.execute(a,n,[`${t}.${e}`]);return!!(l.length&&null!=l[0].to_regclass)})}describeNumberColumn(e,t,n){const a=+n.numeric_precision,l=+n.numeric_scale;if(!a&&!l)switch(+n.type_type){case 0:if("UPDTICK_0"!==t.name)this.logger?.warn(`${e}.${t.name}: unknown number type, no info`);t.type="decimal",t.precision=38,t.scale=0;break;case 1:t.type="byte";break;case 2:t.type="short";break;case 3:t.type="integer";break;default:{if(4!==n.type_type)this.logger?.warn(`${e}.${t.name}: unknown number type, TYPTYP=${n.TYPE_TYPE}`);t.type="decimal";let a=+n.zone_length;if(0===a)a=+n.type_length;t.precision=Math.floor(a),t.scale=Math.round(10*(a-t.precision)),t.precision+=t.scale,t.useFloatingPointFormat=n.zone_option&&-1!==n.zone_option.indexOf("F")||n.type_option&&-1!==n.type_option.indexOf("F");break}}else if(!l)switch(a){case 3:t.type="byte";break;case 5:t.type="short";break;case 10:t.type="integer";break;default:this.logger?.warn(`${e}.${t.name}: unknown number type, TYPTYP=${n.TYPE_TYPE}, precision=${a}`),t.type="decimal",t.precision=a,t.scale=0}else t.type="decimal",t.precision=a,t.scale=l}_sqlRowToColumnDefinition(e,t){const n={name:String(t.column_name).toUpperCase(),isNullable:"NO"!==t.is_nullable};switch(n.default=t.column_default??null,t.udt_name){case"int2":case"int4":case"int8":case"numeric":this.describeNumberColumn(e.tableName,n,t);break;case"varchar":case"string":n.type="string",n.maxLength=parseInt(t.character_maximum_length,10);break;default:if(t.udt_name?.toUpperCase().startsWith("TIMESTAMPTZ"))t.udt_name=`${t.udt_name}(${t.datetime_precision})`;if(n.type=postgreSqlToXtrem[t.udt_name.toUpperCase()]?.name,null==n.type)throw new Error(`Unmanaged column type. column=${t.column_name}, data_type=${t.data_type}, udt_name=${t.udt_name}`)}return n}static _transformSqlArgs(e){const t=[e.schemaName];if(e.tableName)t.push(e.tableName);return t}async fillColumnInfos(e,t){const n=`SELECT UPPER(c.table_name) table_name, c.ordinal_position, c.udt_name, UPPER(c.column_name) column_name, c.data_type, c.character_maximum_length, c.numeric_precision,\n                c.numeric_scale, c.datetime_precision, c.is_nullable, c.column_default,\n                z.LONG_0 ZONE_LENGTH, z.OPTION_0 ZONE_OPTION,\n                t.TYPTYP_0 TYPE_TYPE, t.OPTION_0 TYPE_OPTION, t.LNGTYP_0 TYPE_LENGTH\n                FROM information_schema.tables a\n                JOIN information_schema.columns c ON a.table_name = c.table_name AND a.table_schema = c.table_schema\n                LEFT JOIN ${this.getFullTableName(e.schemaName,"ATABZON")} z ON LOWER(z.CODFIC_0) = LOWER(c.table_name) AND ARRAY_LENGTH(REGEXP_MATCH(LOWER(c.COLUMN_NAME), CONCAT(LOWER(z.CODZONE_0),'\\_.*')),1)>0\n                LEFT JOIN ${this.getFullTableName(e.schemaName,"ATYPE")} t ON z.CODTYP_0 = t.CODTYP_0\n                WHERE c.table_schema NOT IN ('pg_catalog', 'information_schema')\n                AND LOWER(a.table_schema) = LOWER($1) ${t.tableName?" AND LOWER(a.table_name) = LOWER($2)":""}\n                UNION ALL\n                SELECT UPPER(c.table_name) table_name, c.ordinal_position, c.udt_name, UPPER(c.column_name) column_name, c.data_type, c.character_maximum_length, c.numeric_precision,\n                c.numeric_scale, c.datetime_precision, c.is_nullable, c.column_default,\n                z.lng_0 ZONE_LENGTH, z.option_0 ZONE_OPTION,\n                t.TYPTYP_0 TYPE_TYPE, t.OPTION_0 TYPE_OPTION, t.LNGTYP_0 TYPE_LENGTH\n                FROM information_schema.views a\n                JOIN information_schema.columns c ON a.table_name = c.table_name AND a.table_schema = c.table_schema\n                LEFT JOIN ${this.getFullTableName(e.schemaName,"AVIEWD")} z ON LOWER(z.CODVUE_0) = LOWER(c.table_name) AND ARRAY_LENGTH(REGEXP_MATCH(LOWER(c.COLUMN_NAME), CONCAT(LOWER(z.FLDVUE_0),'\\_.*')),1)>0\n                LEFT JOIN ${this.getFullTableName(e.schemaName,"ATYPE")} t ON z.CODTYP_0 = t.CODTYP_0\n                WHERE c.table_schema NOT IN ('pg_catalog', 'information_schema')\n                AND LOWER(c.table_schema) = LOWER($1) ${t.tableName?" AND LOWER(c.table_name) = LOWER($2)":""}\n                ORDER BY table_name, ordinal_position`;await this.withConnection(async a=>{const buildColumn=t=>this._sqlRowToColumnDefinition(e,t);await this.createReader(a,n,PostgresPool._transformSqlArgs(t),{logLevel:"debug"}).forEach(t=>{e.columns=e.columns??[],e.columns.push(buildColumn(t))})})}static parseIndexDefinition(e,t){if(!t)return[];const n=t.match(/\(([\w\s,".]+?)\)/);return(n?n[1].split(",").map(e=>e.trim()):[]).map(n=>{const a=/^(?:([\w_.]+_coalesce\(([\w_"]+)\)|COALESCE\(([\w_"]+), ([\w\s()'^:-]+)?\))|([\w_"]+))(?:\s+(DESC|ASC))?$/.exec(n);if(!a)throw new Error(`Could not parse column definition '${n}' of index ${e} on '${t}'`);return{name:(a[2]||a[3]||a[5]).replace(/"/g,"").toUpperCase(),ascending:"DESC"!==a[6],expression:a[1]}})}async fillIndexInfos(e,t){const n=`SELECT c.tablename table_name, c.indexname index_name, c.indexdef index_def FROM pg_indexes c\n                          WHERE LOWER(c.schemaname) = LOWER($1) ${t.tableName?" AND LOWER(c.tablename) = LOWER($2)":""}\n                          ORDER BY c.tablename, c.indexname;`;await this.withConnection(a=>this.createReader(a,n,PostgresPool._transformSqlArgs(t),{logLevel:"debug"}).forEach(t=>{const n=t.index_name,a=t.index_def,l=PostgresPool.parseIndexDefinition(n,a);e.indexes.push({name:t.index_name.toUpperCase(),isUnique:a.includes("CREATE UNIQUE INDEX"),columns:l})}))}async readTableSchema(e,t,n){const a={schemaName:e,tableName:t,isView:await this.viewExists(t,e),columns:[],indexes:[]},l={schemaName:e,tableName:t};if(!n?.skipColumns){const e=performance.now();if(this.logger)this.logger.debug(()=>`Loading columns for table ${t}`);if(await this.fillColumnInfos(a,l),this.logger)this.logger.debug(()=>`Loaded columns for table ${t} in ${performance.now()-e} ms`)}if(!n?.skipIndexes){const e=performance.now();if(this.logger)this.logger.debug(()=>`Loading indexes for table ${t}`);if(await this.fillIndexInfos(a,l),this.logger)this.logger.debug(()=>`Loaded indexes for tables ${t} in ${performance.now()-e} ms`)}return a}getFullTableDefName(e){return this.getFullTableName(e.schemaName,e.tableName)}getFullTableName(e,t,n){const a=e?`${e}.${t}`:`${t}`;return n?`${a} ${n}`:a}}function create(e,t){return new PostgresPool(e,t)}exports.PostgresPool=PostgresPool;
//# sourceMappingURL=pool.js.map